/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.routebox.seda;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.camel.AsyncEndpoint;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.WaitForTaskToComplete;
import org.apache.camel.component.routebox.RouteboxComponent;
import org.apache.camel.component.routebox.RouteboxConfiguration;
import org.apache.camel.component.routebox.RouteboxConsumer;
import org.apache.camel.component.routebox.RouteboxEndpoint;
import org.apache.camel.component.routebox.RouteboxProducer;
import org.apache.camel.component.routebox.seda.RouteboxSedaConsumer;
import org.apache.camel.component.routebox.seda.RouteboxSedaProducer;
import org.apache.camel.spi.BrowsableEndpoint;

public class RouteboxSedaEndpoint
extends RouteboxEndpoint
implements AsyncEndpoint,
BrowsableEndpoint,
MultipleConsumersSupport {
    private WaitForTaskToComplete waitForTaskToComplete = WaitForTaskToComplete.IfReplyExpected;
    private volatile BlockingQueue<Exchange> queue;
    private volatile Set<RouteboxProducer> producers = new CopyOnWriteArraySet<RouteboxProducer>();
    private volatile Set<RouteboxConsumer> consumers = new CopyOnWriteArraySet<RouteboxConsumer>();

    public RouteboxSedaEndpoint(String endpointUri, RouteboxComponent component, RouteboxConfiguration config) throws Exception {
        super(endpointUri, (Component)component, config);
    }

    public RouteboxSedaEndpoint(String endpointUri, RouteboxComponent component, RouteboxConfiguration config, BlockingQueue<Exchange> queue) throws Exception {
        this(endpointUri, component, config);
        this.queue = queue;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        RouteboxSedaConsumer answer = new RouteboxSedaConsumer(this, processor);
        this.configureConsumer(answer);
        return answer;
    }

    public Producer createProducer() throws Exception {
        return new RouteboxSedaProducer(this, this.queue, this.getWaitForTaskToComplete(), this.getConfig().getConnectionTimeout());
    }

    public boolean isSingleton() {
        return true;
    }

    public void onStarted(RouteboxProducer producer) {
        this.producers.add(producer);
    }

    public void onStopped(RouteboxProducer producer) {
        this.producers.remove(producer);
    }

    public void onStarted(RouteboxConsumer consumer) {
        this.consumers.add(consumer);
    }

    public void onStopped(RouteboxConsumer consumer) {
        this.consumers.remove(consumer);
    }

    public Set<RouteboxConsumer> getConsumers() {
        return new HashSet<RouteboxConsumer>(this.consumers);
    }

    public Set<RouteboxProducer> getProducers() {
        return new HashSet<RouteboxProducer>(this.producers);
    }

    public void setQueue(BlockingQueue<Exchange> queue) {
        this.queue = queue;
    }

    public WaitForTaskToComplete getWaitForTaskToComplete() {
        return this.waitForTaskToComplete;
    }

    public void setWaitForTaskToComplete(WaitForTaskToComplete waitForTaskToComplete) {
        this.waitForTaskToComplete = waitForTaskToComplete;
    }

    public BlockingQueue<Exchange> getQueue() {
        if (this.queue == null) {
            this.queue = this.getConfig().getQueueSize() > 0 ? new LinkedBlockingQueue<Exchange>(this.getConfig().getQueueSize()) : new LinkedBlockingQueue<Exchange>();
        }
        return this.queue;
    }

    public boolean isMultipleConsumersSupported() {
        return true;
    }

    public List<Exchange> getExchanges() {
        return new ArrayList<Exchange>(this.getQueue());
    }
}

