/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.routebox.strategy;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.routebox.RouteboxEndpoint;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.SynchronizationAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteboxDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(RouteboxDispatcher.class);
    private ProducerTemplate producer;

    public RouteboxDispatcher(ProducerTemplate producer) {
        this.producer = producer;
    }

    public Exchange dispatchSync(RouteboxEndpoint endpoint, Exchange exchange) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Dispatching exchange {} to endpoint {}", (Object)exchange, (Object)endpoint.getEndpointUri());
        }
        URI dispatchUri = this.selectDispatchUri(endpoint, exchange);
        Exchange reply = exchange.getPattern() == ExchangePattern.InOnly ? this.producer.send(dispatchUri.toASCIIString(), exchange) : this.issueRequest((Endpoint)endpoint, ExchangePattern.InOut, exchange.getIn().getBody(), exchange.getIn().getHeaders());
        return reply;
    }

    public Exchange dispatchAsync(RouteboxEndpoint endpoint, Exchange exchange) throws Exception {
        Exchange reply;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Dispatching exchange {} to endpoint {}", (Object)exchange, (Object)endpoint.getEndpointUri());
        }
        URI dispatchUri = this.selectDispatchUri(endpoint, exchange);
        if (exchange.getPattern() == ExchangePattern.InOnly) {
            this.producer.asyncSend(dispatchUri.toASCIIString(), exchange);
            reply = exchange;
        } else {
            CompletableFuture future = this.producer.asyncCallback(dispatchUri.toASCIIString(), exchange, (Synchronization)new SynchronizationAdapter());
            reply = (Exchange)future.get(endpoint.getConfig().getConnectionTimeout(), TimeUnit.MILLISECONDS);
        }
        return reply;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected URI selectDispatchUri(RouteboxEndpoint endpoint, Exchange exchange) throws Exception {
        URI dispatchUri;
        List<URI> consumerUris = this.getInnerContextConsumerList(endpoint.getConfig().getInnerContext());
        if (consumerUris.isEmpty()) {
            throw new CamelExchangeException("No routes found to dispatch in Routebox at " + (Object)((Object)endpoint), exchange);
        }
        if (consumerUris.size() == 1) {
            dispatchUri = consumerUris.get(0);
        } else if (!endpoint.getConfig().getDispatchMap().isEmpty()) {
            String key = (String)exchange.getIn().getHeader("ROUTE_DISPATCH_KEY", String.class);
            if (!endpoint.getConfig().getDispatchMap().containsKey(key)) throw new CamelExchangeException("No matching entry found in Dispatch Map for ROUTE_DISPATCH_KEY: " + key, exchange);
            dispatchUri = new URI(endpoint.getConfig().getDispatchMap().get(key));
        } else {
            dispatchUri = endpoint.getConfig().getDispatchStrategy().selectDestinationUri(consumerUris, exchange);
            if (dispatchUri == null) {
                throw new CamelExchangeException("No matching inner routes found for Operation", exchange);
            }
        }
        if (!LOG.isDebugEnabled()) return dispatchUri;
        LOG.debug("Dispatch URI set to: {}", (Object)dispatchUri.toASCIIString());
        return dispatchUri;
    }

    protected List<URI> getInnerContextConsumerList(CamelContext context) throws URISyntaxException {
        ArrayList<URI> consumerList = new ArrayList<URI>();
        List routeDefinitions = context.getRouteDefinitions();
        for (RouteDefinition routeDefinition : routeDefinitions) {
            List inputs = routeDefinition.getInputs();
            for (FromDefinition input : inputs) {
                consumerList.add(new URI(input.getUri()));
            }
        }
        return consumerList;
    }

    public Exchange issueRequest(Endpoint endpoint, ExchangePattern pattern, final Object body, final Map<String, Object> headers) throws CamelExecutionException {
        Exchange exchange = this.producer.send(endpoint, pattern, new Processor(){

            public void process(Exchange exchange) throws Exception {
                Message in = exchange.getIn();
                in.getHeaders().putAll(headers);
                in.setBody(body);
            }
        });
        return exchange;
    }
}

