/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servlet;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class ServletEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":contextPath";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "servlet".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "contextPath", null, true, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(24);
        props.add("muteException");
        props.add("httpMethodRestrict");
        props.add("eagerCheckContentAvailable");
        props.add("httpBinding");
        props.add("synchronous");
        props.add("matchOnUriPrefix");
        props.add("attachmentMultipartBinding");
        props.add("contextPath");
        props.add("exchangePattern");
        props.add("chunked");
        props.add("mapHttpMessageBody");
        props.add("servletName");
        props.add("mapHttpMessageFormUrlEncodedBody");
        props.add("fileNameExtWhitelist");
        props.add("async");
        props.add("responseBufferSize");
        props.add("bridgeErrorHandler");
        props.add("disableStreamCache");
        props.add("headerFilterStrategy");
        props.add("transferException");
        props.add("optionsEnabled");
        props.add("mapHttpMessageHeaders");
        props.add("traceEnabled");
        props.add("exceptionHandler");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

