/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.AbstractQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.StaticService;
import org.apache.camel.spi.ThreadPoolFactory;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.concurrent.RejectableScheduledThreadPoolExecutor;
import org.apache.camel.util.concurrent.RejectableThreadPoolExecutor;
import org.apache.camel.util.concurrent.SizedScheduledExecutorService;
import org.apache.camel.util.concurrent.ThreadFactoryTypeAware;
import org.apache.camel.util.concurrent.ThreadType;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DefaultThreadPoolFactory
extends ServiceSupport
implements CamelContextAware,
ThreadPoolFactory,
StaticService {
    private CamelContext camelContext;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public ExecutorService newCachedThreadPool(ThreadFactory threadFactory) {
        return ThreadPoolFactoryType.from(threadFactory, Integer.MAX_VALUE).newCachedThreadPool(threadFactory);
    }

    public ExecutorService newThreadPool(ThreadPoolProfile profile, ThreadFactory factory) {
        boolean allow = profile.getAllowCoreThreadTimeOut() != null ? profile.getAllowCoreThreadTimeOut() : true;
        return this.newThreadPool(profile.getPoolSize(), profile.getMaxPoolSize(), profile.getKeepAliveTime(), profile.getTimeUnit(), profile.getMaxQueueSize(), allow, profile.getRejectedExecutionHandler(), factory);
    }

    public ExecutorService newThreadPool(int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit timeUnit, int maxQueueSize, boolean allowCoreThreadTimeOut, RejectedExecutionHandler rejectedExecutionHandler, ThreadFactory threadFactory) throws IllegalArgumentException {
        if (corePoolSize < 0) {
            throw new IllegalArgumentException("CorePoolSize must be >= 0, was " + corePoolSize);
        }
        if (maxPoolSize < corePoolSize) {
            throw new IllegalArgumentException("MaxPoolSize must be >= corePoolSize, was " + maxPoolSize + " >= " + corePoolSize);
        }
        return ThreadPoolFactoryType.from(threadFactory, corePoolSize, maxPoolSize, maxQueueSize).newThreadPool(corePoolSize, maxPoolSize, keepAliveTime, timeUnit, maxQueueSize, allowCoreThreadTimeOut, rejectedExecutionHandler, threadFactory);
    }

    public ScheduledExecutorService newScheduledThreadPool(ThreadPoolProfile profile, ThreadFactory threadFactory) {
        return ThreadPoolFactoryType.from(threadFactory, profile).newScheduledThreadPool(profile, threadFactory);
    }

    private static enum ThreadPoolFactoryType {
        PLATFORM{

            @Override
            ExecutorService newCachedThreadPool(ThreadFactory threadFactory) {
                return Executors.newCachedThreadPool(threadFactory);
            }

            @Override
            ExecutorService newThreadPool(int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit timeUnit, int maxQueueSize, boolean allowCoreThreadTimeOut, RejectedExecutionHandler rejectedExecutionHandler, ThreadFactory threadFactory) throws IllegalArgumentException {
                AbstractQueue workQueue;
                if (corePoolSize == 0 && maxQueueSize <= 0) {
                    workQueue = new SynchronousQueue();
                    corePoolSize = 1;
                    maxPoolSize = 1;
                } else {
                    workQueue = maxQueueSize <= 0 ? new SynchronousQueue() : new LinkedBlockingQueue(maxQueueSize);
                }
                RejectableThreadPoolExecutor answer = new RejectableThreadPoolExecutor(corePoolSize, maxPoolSize, keepAliveTime, timeUnit, workQueue);
                answer.setThreadFactory(threadFactory);
                answer.allowCoreThreadTimeOut(allowCoreThreadTimeOut);
                if (rejectedExecutionHandler == null) {
                    rejectedExecutionHandler = new ThreadPoolExecutor.CallerRunsPolicy();
                }
                answer.setRejectedExecutionHandler(rejectedExecutionHandler);
                return answer;
            }

            @Override
            ScheduledExecutorService newScheduledThreadPool(ThreadPoolProfile profile, ThreadFactory threadFactory) {
                RejectedExecutionHandler rejectedExecutionHandler = profile.getRejectedExecutionHandler();
                if (rejectedExecutionHandler == null) {
                    rejectedExecutionHandler = new ThreadPoolExecutor.CallerRunsPolicy();
                }
                RejectableScheduledThreadPoolExecutor answer = new RejectableScheduledThreadPoolExecutor(profile.getPoolSize().intValue(), threadFactory, rejectedExecutionHandler);
                answer.setRemoveOnCancelPolicy(true);
                if (profile.getMaxPoolSize() > 0) {
                    return new SizedScheduledExecutorService((ScheduledThreadPoolExecutor)answer, (long)profile.getMaxQueueSize().intValue());
                }
                return answer;
            }
        }
        ,
        VIRTUAL{

            @Override
            ExecutorService newCachedThreadPool(ThreadFactory threadFactory) {
                return Executors.newThreadPerTaskExecutor(threadFactory);
            }

            @Override
            ExecutorService newThreadPool(int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit timeUnit, int maxQueueSize, boolean allowCoreThreadTimeOut, RejectedExecutionHandler rejectedExecutionHandler, ThreadFactory threadFactory) throws IllegalArgumentException {
                return Executors.newThreadPerTaskExecutor(threadFactory);
            }

            @Override
            ScheduledExecutorService newScheduledThreadPool(ThreadPoolProfile profile, ThreadFactory threadFactory) {
                return Executors.newScheduledThreadPool(0, threadFactory);
            }
        };


        static ThreadPoolFactoryType from(ThreadFactory threadFactory, ThreadPoolProfile profile) {
            return ThreadPoolFactoryType.from(threadFactory, profile.getPoolSize(), profile.getMaxPoolSize(), profile.getMaxQueueSize());
        }

        static ThreadPoolFactoryType from(ThreadFactory threadFactory, int corePoolSize, int maxPoolSize, int maxQueueSize) {
            return ThreadPoolFactoryType.from(threadFactory, corePoolSize == 0 && maxQueueSize <= 0 ? 1 : maxPoolSize);
        }

        static ThreadPoolFactoryType from(ThreadFactory threadFactory, int maxPoolSize) {
            ThreadFactoryTypeAware factoryTypeAware;
            if (ThreadType.current() == ThreadType.PLATFORM) {
                return PLATFORM;
            }
            return maxPoolSize > 1 && threadFactory instanceof ThreadFactoryTypeAware && (factoryTypeAware = (ThreadFactoryTypeAware)threadFactory).isVirtual() ? VIRTUAL : PLATFORM;
        }

        abstract ExecutorService newCachedThreadPool(ThreadFactory var1);

        abstract ExecutorService newThreadPool(int var1, int var2, long var3, TimeUnit var5, int var6, boolean var7, RejectedExecutionHandler var8, ThreadFactory var9) throws IllegalArgumentException;

        abstract ScheduledExecutorService newScheduledThreadPool(ThreadPoolProfile var1, ThreadFactory var2);
    }
}

