/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.camel.component.telegram.model.InlineKeyboardMarkup;
import org.apache.camel.component.telegram.model.InlineQueryResult;
import org.apache.camel.component.telegram.model.InputMessageContent;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class InlineQueryResultArticle
extends InlineQueryResult {
    private static final String TYPE = "article";
    private String title;
    @JsonProperty(value="input_message_content")
    private InputMessageContent inputMessageContext;
    private String url;
    @JsonProperty(value="hide_url")
    private Boolean hideUrl;
    private String description;
    @JsonProperty(value="thumb_url")
    private String thumbUrl;
    @JsonProperty(value="thumb_width")
    private Integer thumbWidth;
    @JsonProperty(value="thumb_height")
    private Integer thumbHeight;

    public InlineQueryResultArticle() {
        super(TYPE);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getTitle() {
        return this.title;
    }

    public InputMessageContent getInputMessageContext() {
        return this.inputMessageContext;
    }

    public String getUrl() {
        return this.url;
    }

    public Boolean getHideUrl() {
        return this.hideUrl;
    }

    public String getDescription() {
        return this.description;
    }

    public String getThumbUrl() {
        return this.thumbUrl;
    }

    public Integer getThumbWidth() {
        return this.thumbWidth;
    }

    public Integer getThumbHeight() {
        return this.thumbHeight;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setInputMessageContext(InputMessageContent inputMessageContext) {
        this.inputMessageContext = inputMessageContext;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setHideUrl(Boolean hideUrl) {
        this.hideUrl = hideUrl;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setThumbUrl(String thumbUrl) {
        this.thumbUrl = thumbUrl;
    }

    public void setThumbWidth(Integer thumbWidth) {
        this.thumbWidth = thumbWidth;
    }

    public void setThumbHeight(Integer thumbHeight) {
        this.thumbHeight = thumbHeight;
    }

    public static final class Builder {
        private String id;
        private InlineKeyboardMarkup replyMarkup;
        private String title;
        private InputMessageContent inputMessageContext;
        private String url;
        private Boolean hideUrl;
        private String description;
        private String thumbUrl;
        private Integer thumbWidth;
        private Integer thumbHeight;

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder inputMessageContext(InputMessageContent inputMessageContext) {
            this.inputMessageContext = inputMessageContext;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder hideUrl(Boolean hideUrl) {
            this.hideUrl = hideUrl;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder thumbUrl(String thumbUrl) {
            this.thumbUrl = thumbUrl;
            return this;
        }

        public Builder thumbWidth(Integer thumbWidth) {
            this.thumbWidth = thumbWidth;
            return this;
        }

        public Builder thumbHeight(Integer thumbHeight) {
            this.thumbHeight = thumbHeight;
            return this;
        }

        public InlineQueryResultArticle build() {
            InlineQueryResultArticle inlineResult = new InlineQueryResultArticle();
            inlineResult.setType(InlineQueryResultArticle.TYPE);
            inlineResult.setId(this.id);
            inlineResult.setReplyMarkup(this.replyMarkup);
            inlineResult.title = this.title;
            inlineResult.inputMessageContext = this.inputMessageContext;
            inlineResult.url = this.url;
            inlineResult.thumbWidth = this.thumbWidth;
            inlineResult.thumbUrl = this.thumbUrl;
            inlineResult.description = this.description;
            inlineResult.hideUrl = this.hideUrl;
            inlineResult.thumbHeight = this.thumbHeight;
            return inlineResult;
        }
    }
}

