/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.whatsapp;

import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
public class WhatsAppConfiguration {
    @UriParam(description="The authorization access token taken from whatsapp-business dashboard.", label="security", secret=true)
    @Metadata(required=true)
    private String authorizationToken;
    @UriPath(description="The phone number ID taken from whatsapp-business dashboard.")
    @Metadata(required=true)
    private String phoneNumberId;
    @UriParam(label="advanced", description="Can be used to set an alternative base URI, e.g. when you want to test the component against a mock WhatsApp API")
    private String baseUri;
    @UriParam(description="Facebook graph api version.", label="advanced")
    private String apiVersion;
    @UriParam(description="Webhook verify token", label="advanced")
    private String webhookVerifyToken;
    @UriParam(description="Webhook path", label="advanced", defaultValue="webhook")
    private String webhookPath = "camel-whatsapp/webhook";

    public String getAuthorizationToken() {
        return this.authorizationToken;
    }

    public void setAuthorizationToken(String authorizationToken) {
        this.authorizationToken = authorizationToken;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getPhoneNumberId() {
        return this.phoneNumberId;
    }

    public void setPhoneNumberId(String phoneNumberId) {
        this.phoneNumberId = phoneNumberId;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public String getWebhookVerifyToken() {
        return this.webhookVerifyToken;
    }

    public void setWebhookVerifyToken(String webhookVerifyToken) {
        this.webhookVerifyToken = webhookVerifyToken;
    }

    public String getWebhookPath() {
        return this.webhookPath;
    }

    public void setWebhookPath(String webhookPath) {
        this.webhookPath = webhookPath;
    }

    public String toString() {
        return "WhatsAppConfiguration{authorizationToken='" + this.authorizationToken + "', baseUri='" + this.baseUri + "', apiVersion='" + this.apiVersion + "', phoneNumberId='" + this.phoneNumberId + "'}";
    }
}

