/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.whatsapp;

import java.net.http.HttpClient;
import java.time.Duration;
import java.util.List;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.webhook.WebhookCapableEndpoint;
import org.apache.camel.component.webhook.WebhookConfiguration;
import org.apache.camel.component.whatsapp.WhatsAppConfiguration;
import org.apache.camel.component.whatsapp.WhatsAppConstants;
import org.apache.camel.component.whatsapp.WhatsAppProducer;
import org.apache.camel.component.whatsapp.WhatsAppService;
import org.apache.camel.component.whatsapp.WhatsAppWebhookProcessor;
import org.apache.camel.component.whatsapp.service.WhatsAppServiceRestAPIAdapter;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="3.19.0", scheme="whatsapp", title="WhatsApp", syntax="whatsapp:phoneNumberId", producerOnly=true, category={Category.CLOUD, Category.API, Category.CHAT}, headersClass=WhatsAppConstants.class)
public class WhatsAppEndpoint
extends ScheduledPollEndpoint
implements WebhookCapableEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(WhatsAppEndpoint.class);
    @UriParam
    private WhatsAppConfiguration configuration;
    @UriParam(label="advanced", description="HttpClient implementation")
    private HttpClient httpClient;
    @UriParam(label="advanced", description="WhatsApp service implementation")
    private WhatsAppService whatsappService;
    private WebhookConfiguration webhookConfiguration;

    public WhatsAppEndpoint(String endpointUri, Component component, WhatsAppConfiguration configuration, HttpClient client) {
        super(endpointUri, component);
        this.configuration = configuration;
        this.httpClient = client;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.httpClient == null) {
            this.httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).connectTimeout(Duration.ofSeconds(10L)).build();
        }
        if (this.whatsappService == null) {
            this.whatsappService = new WhatsAppServiceRestAPIAdapter(this.httpClient, this.configuration.getBaseUri(), this.configuration.getApiVersion(), this.configuration.getPhoneNumberId(), this.configuration.getAuthorizationToken());
        }
        LOG.debug("client {}", (Object)this.httpClient);
        LOG.debug("whatsappService {}", (Object)this.whatsappService);
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.httpClient = null;
    }

    public Producer createProducer() throws Exception {
        return new WhatsAppProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("consumer not supported");
    }

    public Processor createWebhookHandler(Processor next) {
        return new WhatsAppWebhookProcessor(next, this.configuration);
    }

    public List<String> getWebhookMethods() {
        return List.of("POST", "GET");
    }

    public void registerWebhook() throws Exception {
    }

    public void setWebhookConfiguration(WebhookConfiguration webhookConfiguration) {
        webhookConfiguration.setWebhookPath(this.configuration.getWebhookPath());
        this.webhookConfiguration = webhookConfiguration;
    }

    public void unregisterWebhook() throws Exception {
    }

    public WhatsAppConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(WhatsAppConfiguration configuration) {
        this.configuration = configuration;
    }

    public WhatsAppService getWhatsappService() {
        return this.whatsappService;
    }

    public void setWhatsappService(WhatsAppService whatsappService) {
        this.whatsappService = whatsappService;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public WebhookConfiguration getWebhookConfiguration() {
        return this.webhookConfiguration;
    }
}

