/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.maven.deployer.servlet;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import org.apache.cocoon.maven.deployer.servlet.ShieldedClassLoaderManager;

public class ShieldingServlet
extends HttpServlet {
    protected Servlet servlet;
    protected ClassLoader classloader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.classloader = ShieldedClassLoaderManager.getClassLoader(config.getServletContext());
        String servletName = config.getInitParameter("servlet-class");
        if (servletName == null) {
            throw new ServletException("ShieldingServlet: Init-Parameter 'servlet-class' is missing.");
        }
        ShieldedClassLoaderManager.logDebug(config.getServletContext(), "ShieldingServlet: Loading servlet class " + servletName);
        try {
            Class<?> servletClass = this.classloader.loadClass(servletName);
            this.servlet = (Servlet)servletClass.newInstance();
        }
        catch (Exception e) {
            throw new ServletException("Cannot load servlet " + servletName, (Throwable)e);
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classloader);
            this.servlet.init(this.getServletConfig());
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classloader);
            this.servlet.service(request, response);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.servlet != null) {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.classloader);
                this.servlet.destroy();
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
        super.destroy();
    }
}

