/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.maven.deployer.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parseXml(File file) throws IOException, SAXException {
        Document document;
        block5: {
            BufferedInputStream is = null;
            try {
                is = new BufferedInputStream(new FileInputStream(file));
                document = XMLUtils.parseXml(is);
                Object var4_3 = null;
                if (is == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var4_4 = null;
                    if (is == null) break block6;
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException ignore) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)is).close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        return document;
    }

    public static Document parseXml(InputStream source) throws IOException, SAXException {
        try {
            DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
            documentFactory.setNamespaceAware(true);
            documentFactory.setValidating(false);
            DocumentBuilder docBuilder = documentFactory.newDocumentBuilder();
            docBuilder.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    if (systemId.equals("http://java.sun.com/dtd/web-app_2_3.dtd")) {
                        return new InputSource(this.getClass().getResourceAsStream("web-app_2_3.dtd"));
                    }
                    return null;
                }
            });
            return docBuilder.parse(source);
        }
        catch (ParserConfigurationException pce) {
            throw new IOException("Creating document failed:" + pce.getMessage());
        }
    }

    public static void write(Document node, OutputStream out) throws TransformerFactoryConfigurationError, TransformerException {
        Properties format = new Properties();
        format.put("method", "xml");
        format.put("omit-xml-declaration", "no");
        format.put("indent", "yes");
        if (node.getDoctype() != null) {
            if (node.getDoctype().getPublicId() != null) {
                format.put("doctype-public", node.getDoctype().getPublicId());
            }
            if (node.getDoctype().getSystemId() != null) {
                format.put("doctype-system", node.getDoctype().getSystemId());
            }
        }
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperties(format);
        transformer.transform(new DOMSource(node), new StreamResult(out));
    }

    public static List getChildNodes(Element parent, String nodeName) {
        NodeList children;
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (parent != null && nodeName != null && (children = parent.getChildNodes()) != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                if (!nodeName.equals(children.item(i).getLocalName())) continue;
                nodes.add(children.item(i));
            }
        }
        return nodes;
    }

    public static Element getChildNode(Element parent, String nodeName) {
        List children = XMLUtils.getChildNodes(parent, nodeName);
        if (children.size() > 0) {
            return (Element)children.get(0);
        }
        return null;
    }

    public static String getValue(Element node) {
        if (node != null) {
            if (node.getNodeType() == 2) {
                return node.getNodeValue();
            }
            node.normalize();
            NodeList childs = node.getChildNodes();
            int length = childs.getLength();
            for (int i = 0; i < length; ++i) {
                if (childs.item(i).getNodeType() != 3) continue;
                return childs.item(i).getNodeValue().trim();
            }
        }
        return null;
    }

    public static void setValue(Element node, String value) {
        if (node != null) {
            while (node.hasChildNodes()) {
                node.removeChild(node.getFirstChild());
            }
            node.appendChild(node.getOwnerDocument().createTextNode(value));
        }
    }
}

