/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.maven.rcl;

import java.io.File;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.maven.plugin.MojoExecutionException;

public class RwmProperties {
    private static final String COB_INF_DIR = "src/main/resources/COB-INF";
    private static final String BLOCK_CONTEXT_URL_PARAM = "/contextPath";
    private static final String CLASSES_DIR = "%classes-dir";
    private static final String EXCLUDE_LIB = "%exclude-lib";
    private static final String TARGET_CLASSES_DIR = "target/classes";
    private Configuration props;
    private File basedir;

    public RwmProperties(File propsFile, File basedir) throws ConfigurationException {
        this.props = new PropertiesConfiguration(propsFile);
        this.basedir = basedir;
    }

    public Set getClassesDirs() throws MojoExecutionException {
        HashSet<String> returnSet = new HashSet<String>();
        Iterator rclIt = this.props.getKeys();
        while (rclIt.hasNext()) {
            String key = (String)rclIt.next();
            if (!key.endsWith(CLASSES_DIR)) continue;
            String[] values = this.props.getStringArray(key);
            for (int i = 0; i < values.length; ++i) {
                String path = values[i];
                String url = null;
                try {
                    url = this.getUrlAsString(path);
                }
                catch (MalformedURLException e) {
                    throw new MojoExecutionException("Can't create URL to  " + path, (Exception)e);
                }
                returnSet.add(url);
            }
        }
        return returnSet;
    }

    public Set getExcludedLibProps() throws MojoExecutionException {
        HashSet<String> returnSet = new HashSet<String>();
        Iterator rclIt = this.props.getKeys();
        while (rclIt.hasNext()) {
            String key = (String)rclIt.next();
            if (!key.endsWith(EXCLUDE_LIB)) continue;
            String[] values = this.props.getStringArray(key);
            for (int i = 0; i < values.length; ++i) {
                returnSet.add(values[i]);
            }
        }
        return returnSet;
    }

    public Properties getSpringProperties() throws MojoExecutionException {
        Properties springProps = new Properties();
        Iterator rclIt = this.props.getKeys();
        while (rclIt.hasNext()) {
            String path;
            String key = (String)rclIt.next();
            if (key.endsWith(BLOCK_CONTEXT_URL_PARAM)) {
                path = null;
                try {
                    path = this.getUrlAsString(this.props.getString(key));
                }
                catch (MalformedURLException e) {
                    throw new MojoExecutionException("Can't create URL to  " + path, (Exception)e);
                }
                springProps.put(key, path);
                continue;
            }
            if (key.endsWith(CLASSES_DIR) && !CLASSES_DIR.equals(key)) {
                path = null;
                try {
                    path = this.getUrlAsString(this.props.getString(key));
                }
                catch (MalformedURLException e) {
                    throw new MojoExecutionException("Can't create URL to  " + this.props.getString(key), (Exception)e);
                }
                if (path.endsWith(TARGET_CLASSES_DIR)) {
                    path = path + "/";
                }
                if (!path.endsWith("target/classes/")) {
                    throw new MojoExecutionException("A */%classes-dir property can only point to a directory that ends with target/classes.");
                }
                path = RwmProperties.calcRootDir(path);
                String newKey = key.substring(0, key.length() - CLASSES_DIR.length()) + BLOCK_CONTEXT_URL_PARAM;
                springProps.put(newKey, path + COB_INF_DIR);
                continue;
            }
            if (key.endsWith(CLASSES_DIR) || key.indexOf(47) <= -1) continue;
            springProps.put(key, this.props.getString(key));
        }
        return springProps;
    }

    public static String calcRootDir(String path) {
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        path = path.substring(0, path.length() - TARGET_CLASSES_DIR.length());
        return path;
    }

    public Properties getCocoonProperties() {
        Properties cocoonProps = new Properties();
        Iterator rclIt = this.props.getKeys();
        while (rclIt.hasNext()) {
            String key = (String)rclIt.next();
            if (key.indexOf(CLASSES_DIR) != -1 || key.indexOf(EXCLUDE_LIB) != -1 || key.indexOf(47) != -1) continue;
            cocoonProps.put(key, this.props.getString(key));
        }
        return cocoonProps;
    }

    private String getUrlAsString(String path) throws MalformedURLException {
        boolean absolute = false;
        if (path.indexOf(58) == 1 || path.startsWith("/")) {
            absolute = true;
        }
        File p = null;
        p = absolute ? new File(path) : new File(this.basedir, path);
        return p.toURI().toASCIIString();
    }
}

