/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.thrift;

import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.Transporter;
import org.apache.dubbo.remoting.exchange.ExchangeChannel;
import org.apache.dubbo.remoting.exchange.ExchangeClient;
import org.apache.dubbo.remoting.exchange.ExchangeHandler;
import org.apache.dubbo.remoting.exchange.ExchangeServer;
import org.apache.dubbo.remoting.exchange.Exchangers;
import org.apache.dubbo.remoting.exchange.support.ExchangeHandlerAdapter;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.protocol.AbstractProtocol;
import org.apache.dubbo.rpc.protocol.dubbo.DubboExporter;
import org.apache.dubbo.rpc.protocol.thrift.ThriftInvoker;

@Deprecated
public class ThriftProtocol
extends AbstractProtocol {
    public static final int DEFAULT_PORT = 40880;
    public static final String NAME = "thrift";
    private final ConcurrentMap<String, ExchangeServer> serverMap = new ConcurrentHashMap<String, ExchangeServer>();
    private ExchangeHandler handler = new ExchangeHandlerAdapter(){

        public CompletableFuture<Object> reply(ExchangeChannel channel, Object msg) throws RemotingException {
            if (msg instanceof Invocation) {
                Invocation inv = (Invocation)msg;
                String path = (String)inv.getAttachments().get("path");
                String serviceKey = ThriftProtocol.serviceKey((int)channel.getLocalAddress().getPort(), (String)path, (String)null, (String)null);
                DubboExporter exporter = (DubboExporter)ThriftProtocol.this.exporterMap.get(serviceKey);
                if (exporter == null) {
                    throw new RemotingException((Channel)channel, "Not found exported service: " + serviceKey + " in " + ThriftProtocol.this.exporterMap.keySet() + ", may be version or group mismatch , channel: consumer: " + channel.getRemoteAddress() + " --> provider: " + channel.getLocalAddress() + ", message:" + msg);
                }
                RpcContext.getContext().setRemoteAddress(channel.getRemoteAddress());
                Result result = exporter.getInvoker().invoke(inv);
                return result.completionFuture().thenApply(Function.identity());
            }
            throw new RemotingException((Channel)channel, "Unsupported request: " + msg.getClass().getName() + ": " + msg + ", channel: consumer: " + channel.getRemoteAddress() + " --> provider: " + channel.getLocalAddress());
        }

        public void received(Channel channel, Object message) throws RemotingException {
            if (message instanceof Invocation) {
                this.reply((ExchangeChannel)channel, message);
            } else {
                super.received(channel, message);
            }
        }
    };

    public int getDefaultPort() {
        return 40880;
    }

    public <T> Exporter<T> export(Invoker<T> invoker) throws RpcException {
        URL url = invoker.getUrl().addParameter("codec", NAME);
        String key = url.getAddress();
        boolean isServer = url.getParameter("isserver", true);
        if (isServer && !this.serverMap.containsKey(key)) {
            this.serverMap.put(key, this.getServer(url));
        }
        key = ThriftProtocol.serviceKey((URL)url);
        DubboExporter exporter = new DubboExporter(invoker, key, this.exporterMap);
        this.exporterMap.put(key, exporter);
        return exporter;
    }

    public void destroy() {
        super.destroy();
        for (String key : new ArrayList(this.serverMap.keySet())) {
            ExchangeServer server = (ExchangeServer)this.serverMap.remove(key);
            if (server == null) continue;
            try {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Close dubbo server: " + server.getLocalAddress());
                }
                server.close(ConfigurationUtils.getServerShutdownTimeout());
            }
            catch (Throwable t) {
                this.logger.warn(t.getMessage(), t);
            }
        }
    }

    protected <T> Invoker<T> protocolBindingRefer(Class<T> type, URL url) throws RpcException {
        ThriftInvoker<T> invoker = new ThriftInvoker<T>(type, url, this.getClients(url), this.invokers);
        this.invokers.add(invoker);
        return invoker;
    }

    private ExchangeClient[] getClients(URL url) {
        int connections = url.getParameter("connections", 1);
        ExchangeClient[] clients = new ExchangeClient[connections];
        for (int i = 0; i < clients.length; ++i) {
            clients[i] = this.initClient(url);
        }
        return clients;
    }

    private ExchangeClient initClient(URL url) {
        ExchangeClient client;
        url = url.addParameter("codec", NAME);
        try {
            client = Exchangers.connect((URL)url);
        }
        catch (RemotingException e) {
            throw new RpcException("Fail to create remoting client for service(" + url + "): " + e.getMessage(), (Throwable)e);
        }
        return client;
    }

    private ExchangeServer getServer(URL url) {
        Set supportedTypes;
        ExchangeServer server;
        String str = (url = url.addParameterIfAbsent("channel.readonly.sent", Boolean.TRUE.toString())).getParameter("server", "netty");
        if (str != null && str.length() > 0 && !ExtensionLoader.getExtensionLoader(Transporter.class).hasExtension(str)) {
            throw new RpcException("Unsupported server type: " + str + ", url: " + url);
        }
        try {
            server = Exchangers.bind((URL)url, (ExchangeHandler)this.handler);
        }
        catch (RemotingException e) {
            throw new RpcException("Fail to start server(url: " + url + ") " + e.getMessage(), (Throwable)e);
        }
        str = url.getParameter("client");
        if (str != null && str.length() > 0 && !(supportedTypes = ExtensionLoader.getExtensionLoader(Transporter.class).getSupportedExtensions()).contains(str)) {
            throw new RpcException("Unsupported client type: " + str);
        }
        return server;
    }
}

