/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.math;

import org.apache.flink.ml.math.SparseMatrix;
import org.apache.flink.ml.math.SparseMatrix$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Sorting$;

public final class SparseMatrix$
implements Serializable {
    public static final SparseMatrix$ MODULE$;

    static {
        new SparseMatrix$();
    }

    public SparseMatrix fromCOO(int numRows, int numCols, Seq<Tuple3<Object, Object, Object>> entries) {
        return this.fromCOO(numRows, numCols, (Iterable<Tuple3<Object, Object, Object>>)entries);
    }

    public SparseMatrix fromCOO(int numRows, int numCols, Iterable<Tuple3<Object, Object, Object>> entries) {
        Tuple3[] entryArray = (Tuple3[])entries.toArray(ClassTag$.MODULE$.apply(Tuple3.class));
        Predef$.MODULE$.refArrayOps((Object[])entryArray).foreach((Function1)new Serializable(numRows, numCols){
            public static final long serialVersionUID = 0L;
            public final int numRows$1;
            public final int numCols$1;

            public final void apply(Tuple3<Object, Object, Object> x0$1) {
                Tuple3<Object, Object, Object> tuple3 = x0$1;
                if (tuple3 != null) {
                    int row = BoxesRunTime.unboxToInt((Object)tuple3._1());
                    int col = BoxesRunTime.unboxToInt((Object)tuple3._2());
                    Predef$.MODULE$.require(0 <= row && row < this.numRows$1 && 0 <= col && col <= this.numCols$1, (Function0)new Serializable(this, row, col){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.fromCOO.1 $outer;
                        private final int row$2;
                        private final int col$2;

                        public final String apply() {
                            return new StringBuilder().append((Object)Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)new Tuple2.mcII.sp(this.row$2, this.col$2)), " not in [0, ")).append((Object)BoxesRunTime.boxToInteger((int)this.$outer.numRows$1)).append((Object)") x [0, ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.numCols$1)).append((Object)")").toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.row$2 = row$2;
                            this.col$2 = col$2;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple3);
            }
            {
                this.numRows$1 = numRows$1;
                this.numCols$1 = numCols$1;
            }
        });
        Ordering<Tuple3<Object, Object, Object>> COOOrdering = new Ordering<Tuple3<Object, Object, Object>>(){

            public Some tryCompare(Object x, Object y) {
                return Ordering.class.tryCompare((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lteq(Object x, Object y) {
                return Ordering.class.lteq((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gteq(Object x, Object y) {
                return Ordering.class.gteq((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lt(Object x, Object y) {
                return Ordering.class.lt((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gt(Object x, Object y) {
                return Ordering.class.gt((Ordering)this, (Object)x, (Object)y);
            }

            public boolean equiv(Object x, Object y) {
                return Ordering.class.equiv((Ordering)this, (Object)x, (Object)y);
            }

            public Object max(Object x, Object y) {
                return Ordering.class.max((Ordering)this, (Object)x, (Object)y);
            }

            public Object min(Object x, Object y) {
                return Ordering.class.min((Ordering)this, (Object)x, (Object)y);
            }

            public Ordering<Tuple3<Object, Object, Object>> reverse() {
                return Ordering.class.reverse((Ordering)this);
            }

            public <U> Ordering<U> on(Function1<U, Tuple3<Object, Object, Object>> f) {
                return Ordering.class.on((Ordering)this, f);
            }

            public Ordering.Ops mkOrderingOps(Object lhs) {
                return Ordering.class.mkOrderingOps((Ordering)this, (Object)lhs);
            }

            public int compare(Tuple3<Object, Object, Object> x, Tuple3<Object, Object, Object> y) {
                return BoxesRunTime.unboxToInt((Object)x._2()) < BoxesRunTime.unboxToInt((Object)y._2()) ? -1 : (BoxesRunTime.unboxToInt((Object)x._2()) > BoxesRunTime.unboxToInt((Object)y._2()) ? 1 : BoxesRunTime.unboxToInt((Object)x._1()) - BoxesRunTime.unboxToInt((Object)y._1()));
            }
            {
                PartialOrdering.class.$init$((PartialOrdering)this);
                Ordering.class.$init$((Ordering)this);
            }
        };
        Sorting$.MODULE$.quickSort((Object)entryArray, (Ordering)COOOrdering);
        int nnz = entryArray.length;
        double[] data = new double[nnz];
        int[] rowIndices = new int[nnz];
        int[] colPtrs = new int[numCols + 1];
        Tuple3 tuple3 = entryArray[0];
        if (tuple3 != null) {
            double[] dArray;
            int[] prunedRowIndices;
            int[] nArray;
            Tuple3 tuple32;
            int lastRow = BoxesRunTime.unboxToInt((Object)tuple3._1());
            int lastCol = BoxesRunTime.unboxToInt((Object)tuple3._2());
            double lastValue = BoxesRunTime.unboxToDouble((Object)tuple3._3());
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)lastRow), (Object)BoxesRunTime.boxToInteger((int)lastCol), (Object)BoxesRunTime.boxToDouble((double)lastValue));
            int lastRow2 = BoxesRunTime.unboxToInt((Object)tuple33._1());
            int lastCol2 = BoxesRunTime.unboxToInt((Object)tuple33._2());
            double lastValue2 = BoxesRunTime.unboxToDouble((Object)tuple33._3());
            rowIndices[0] = lastRow2;
            data[0] = lastValue2;
            int lastDataIndex = 0;
            for (int i = 1; i < nnz; ++i) {
                Tuple3 tuple34 = entryArray[i];
                if (tuple34 != null) {
                    Tuple3 tuple35;
                    int curRow = BoxesRunTime.unboxToInt((Object)tuple34._1());
                    int curCol = BoxesRunTime.unboxToInt((Object)tuple34._2());
                    double curValue = BoxesRunTime.unboxToDouble((Object)tuple34._3());
                    Tuple3 tuple36 = tuple35 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)curRow), (Object)BoxesRunTime.boxToInteger((int)curCol), (Object)BoxesRunTime.boxToDouble((double)curValue));
                    int curRow2 = BoxesRunTime.unboxToInt((Object)tuple36._1());
                    int curCol2 = BoxesRunTime.unboxToInt((Object)tuple36._2());
                    double curValue2 = BoxesRunTime.unboxToDouble((Object)tuple36._3());
                    if (lastRow2 == curRow2 && lastCol2 == curCol2) {
                        int n = lastDataIndex;
                        data[n] = data[n] + curValue2;
                    } else {
                        data[++lastDataIndex] = curValue2;
                        rowIndices[lastDataIndex] = curRow2;
                        lastRow2 = curRow2;
                    }
                    while (lastCol2 < curCol2) {
                        colPtrs[++lastCol2] = lastDataIndex;
                    }
                    continue;
                }
                throw new MatchError((Object)tuple34);
            }
            ++lastDataIndex;
            while (lastCol2 < numCols) {
                colPtrs[lastCol2 + 1] = lastDataIndex;
                ++lastCol2;
            }
            if (lastDataIndex < nnz) {
                int[] prunedArray = new int[lastDataIndex];
                Predef$.MODULE$.intArrayOps(rowIndices).copyToArray((Object)prunedArray);
                nArray = prunedArray;
            } else {
                nArray = prunedRowIndices = rowIndices;
            }
            if (lastDataIndex < nnz) {
                double[] prunedArray = new double[lastDataIndex];
                Predef$.MODULE$.doubleArrayOps(data).copyToArray((Object)prunedArray);
                dArray = prunedArray;
            } else {
                dArray = data;
            }
            double[] prunedData = dArray;
            return new SparseMatrix(numRows, numCols, prunedRowIndices, colPtrs, prunedData);
        }
        throw new MatchError((Object)tuple3);
    }

    public SparseMatrix fromCOO(int numRows, int numCols, Tuple3<Object, Object, Object> entry) {
        return this.fromCOO(numRows, numCols, (Seq<Tuple3<Object, Object, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3(entry._1(), entry._2(), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToInt((Object)entry._3())))}));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SparseMatrix$() {
        MODULE$ = this;
    }
}

