/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.math;

import java.util.Arrays;
import org.apache.flink.ml.math.DenseMatrix;
import org.apache.flink.ml.math.DenseMatrix$;
import org.apache.flink.ml.math.Matrix;
import org.apache.flink.ml.math.Matrix$class;
import org.apache.flink.ml.math.SparseMatrix$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001B\u0001\u0003\u00015\u0011Ab\u00159beN,W*\u0019;sSbT!a\u0001\u0003\u0002\t5\fG\u000f\u001b\u0006\u0003\u000b\u0019\t!!\u001c7\u000b\u0005\u001dA\u0011!\u00024mS:\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u001dQA\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u0016-5\t!!\u0003\u0002\u0018\u0005\t1Q*\u0019;sSb\u0004\"aD\r\n\u0005i\u0001\"\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002\u0003\u000f\u0001\u0005\u000b\u0007I\u0011A\u000f\u0002\u000f9,XNU8xgV\ta\u0004\u0005\u0002\u0010?%\u0011\u0001\u0005\u0005\u0002\u0004\u0013:$\b\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002\u00119,XNU8xg\u0002B\u0001\u0002\n\u0001\u0003\u0006\u0004%\t!H\u0001\b]Vl7i\u001c7t\u0011!1\u0003A!A!\u0002\u0013q\u0012\u0001\u00038v[\u000e{Gn\u001d\u0011\t\u0011!\u0002!Q1A\u0005\u0002%\n!B]8x\u0013:$\u0017nY3t+\u0005Q\u0003cA\b,=%\u0011A\u0006\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\t]\u0001\u0011\t\u0011)A\u0005U\u0005Y!o\\<J]\u0012L7-Z:!\u0011!\u0001\u0004A!b\u0001\n\u0003I\u0013aB2pYB#(o\u001d\u0005\te\u0001\u0011\t\u0011)A\u0005U\u0005A1m\u001c7QiJ\u001c\b\u0005\u0003\u00055\u0001\t\u0015\r\u0011\"\u00016\u0003\u0011!\u0017\r^1\u0016\u0003Y\u00022aD\u00168!\ty\u0001(\u0003\u0002:!\t1Ai\\;cY\u0016D\u0001b\u000f\u0001\u0003\u0002\u0003\u0006IAN\u0001\u0006I\u0006$\u0018\r\t\u0005\u0006{\u0001!\tAP\u0001\u0007y%t\u0017\u000e\u001e \u0015\r}\u0002\u0015IQ\"E!\t)\u0002\u0001C\u0003\u001dy\u0001\u0007a\u0004C\u0003%y\u0001\u0007a\u0004C\u0003)y\u0001\u0007!\u0006C\u00031y\u0001\u0007!\u0006C\u00035y\u0001\u0007a\u0007C\u0003G\u0001\u0011\u0005s)A\u0003baBd\u0017\u0010F\u00028\u0011*CQ!S#A\u0002y\t1A]8x\u0011\u0015YU\t1\u0001\u001f\u0003\r\u0019w\u000e\u001c\u0005\u0006\u001b\u0002!\tAT\u0001\u000ei>$UM\\:f\u001b\u0006$(/\u001b=\u0016\u0003=\u0003\"!\u0006)\n\u0005E\u0013!a\u0003#f]N,W*\u0019;sSbDQa\u0015\u0001\u0005BQ\u000ba!\u001e9eCR,G\u0003B+Y3j\u0003\"a\u0004,\n\u0005]\u0003\"\u0001B+oSRDQ!\u0013*A\u0002yAQa\u0013*A\u0002yAQa\u0017*A\u0002]\nQA^1mk\u0016DQ!\u0018\u0001\u0005By\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0002?B\u0011\u0001m\u0019\b\u0003\u001f\u0005L!A\u0019\t\u0002\rA\u0013X\rZ3g\u0013\t!WM\u0001\u0004TiJLgn\u001a\u0006\u0003EBAQa\u001a\u0001\u0005B!\fa!Z9vC2\u001cHCA5m!\ty!.\u0003\u0002l!\t9!i\\8mK\u0006t\u0007\"B7g\u0001\u0004q\u0017aA8cUB\u0011qb\\\u0005\u0003aB\u00111!\u00118z\u0011\u0015\u0011\b\u0001\"\u0011t\u0003!A\u0017m\u001d5D_\u0012,G#\u0001\u0010\t\u000bU\u0004A\u0011\u0002<\u0002\r1|7-\u0019;f)\rqr\u000f\u001f\u0005\u0006\u0013R\u0004\rA\b\u0005\u0006\u0017R\u0004\rA\b\u0005\u0006u\u0002!\te_\u0001\u0005G>\u0004\u00180F\u0001@\u000f\u0015i(\u0001#\u0001\u007f\u00031\u0019\u0006/\u0019:tK6\u000bGO]5y!\t)rP\u0002\u0004\u0002\u0005!\u0005\u0011\u0011A\n\u0004\u007f:A\u0002BB\u001f\u0000\t\u0003\t)\u0001F\u0001\u007f\u0011\u001d\tIa C\u0001\u0003\u0017\tqA\u001a:p[\u000e{u\nF\u0004@\u0003\u001b\ty!!\u0005\t\rq\t9\u00011\u0001\u001f\u0011\u0019!\u0013q\u0001a\u0001=!A\u00111CA\u0004\u0001\u0004\t)\"A\u0004f]R\u0014\u0018.Z:\u0011\u000b=\t9\"a\u0007\n\u0007\u0005e\u0001C\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u0002baDA\u000f=y9\u0014bAA\u0010!\t1A+\u001e9mKNBq!!\u0003\u0000\t\u0003\t\u0019\u0003F\u0004@\u0003K\t9#!\u000b\t\rq\t\t\u00031\u0001\u001f\u0011\u0019!\u0013\u0011\u0005a\u0001=!A\u00111CA\u0011\u0001\u0004\tY\u0003\u0005\u0004\u0002.\u0005u\u00121\u0004\b\u0005\u0003_\tID\u0004\u0003\u00022\u0005]RBAA\u001a\u0015\r\t)\u0004D\u0001\u0007yI|w\u000e\u001e \n\u0003EI1!a\u000f\u0011\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0010\u0002B\tA\u0011\n^3sC\ndWMC\u0002\u0002<AAq!!\u0003\u0000\t\u0003\t)\u0005F\u0004@\u0003\u000f\nI%a\u0013\t\rq\t\u0019\u00051\u0001\u001f\u0011\u0019!\u00131\ta\u0001=!A\u0011QJA\"\u0001\u0004\ty%A\u0003f]R\u0014\u0018\u0010\u0005\u0004\u0010\u0003;qbD\b\u0005\n\u0003'z\u0018\u0011!C\u0005\u0003+\n1B]3bIJ+7o\u001c7wKR\u0011\u0011q\u000b\t\u0005\u00033\n\u0019'\u0004\u0002\u0002\\)!\u0011QLA0\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0005\u0014\u0001\u00026bm\u0006LA!!\u001a\u0002\\\t1qJ\u00196fGR\u0004")
public class SparseMatrix
implements Matrix,
Serializable {
    private final int numRows;
    private final int numCols;
    private final int[] rowIndices;
    private final int[] colPtrs;
    private final double[] data;

    public static SparseMatrix fromCOO(int n, int n2, Tuple3<Object, Object, Object> tuple3) {
        return SparseMatrix$.MODULE$.fromCOO(n, n2, tuple3);
    }

    public static SparseMatrix fromCOO(int n, int n2, Iterable<Tuple3<Object, Object, Object>> iterable) {
        return SparseMatrix$.MODULE$.fromCOO(n, n2, iterable);
    }

    public static SparseMatrix fromCOO(int n, int n2, Seq<Tuple3<Object, Object, Object>> seq) {
        return SparseMatrix$.MODULE$.fromCOO(n, n2, seq);
    }

    @Override
    public boolean equalsMatrix(Matrix matrix) {
        return Matrix$class.equalsMatrix(this, matrix);
    }

    @Override
    public int numRows() {
        return this.numRows;
    }

    @Override
    public int numCols() {
        return this.numCols;
    }

    public int[] rowIndices() {
        return this.rowIndices;
    }

    public int[] colPtrs() {
        return this.colPtrs;
    }

    public double[] data() {
        return this.data;
    }

    @Override
    public double apply(int row, int col) {
        int index = this.locate(row, col);
        return index < 0 ? 0.0 : this.data()[index];
    }

    /*
     * WARNING - void declaration
     */
    public DenseMatrix toDenseMatrix() {
        void var1_1;
        DenseMatrix result = DenseMatrix$.MODULE$.zeros(this.numRows(), this.numCols());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numRows()).foreach$mVc$sp((Function1)new Serializable(this, result){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparseMatrix $outer;
            public final DenseMatrix result$1;

            public final void apply(int row) {
                this.apply$mcVI$sp(row);
            }

            public void apply$mcVI$sp(int row) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.numCols()).foreach$mVc$sp((Function1)new Serializable(this, row){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$toDenseMatrix$1 $outer;
                    private final int row$3;

                    public final void apply(int col) {
                        this.apply$mcVI$sp(col);
                    }

                    public void apply$mcVI$sp(int col) {
                        this.$outer.result$1.update(this.row$3, col, this.$outer.org$apache$flink$ml$math$SparseMatrix$$anonfun$$$outer().apply(this.row$3, col));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.row$3 = row$3;
                    }
                });
            }

            public /* synthetic */ SparseMatrix org$apache$flink$ml$math$SparseMatrix$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.result$1 = result$1;
            }
        });
        return var1_1;
    }

    @Override
    public void update(int row, int col, double value) {
        int index = this.locate(row, col);
        if (index < 0) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Cannot update zero value of sparse matrix at index ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)row), BoxesRunTime.boxToInteger((int)col)}))).toString());
        }
        this.data()[index] = value;
    }

    public String toString() {
        StringBuilder result = scala.package$.MODULE$.StringBuilder().newBuilder();
        result.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SparseMatrix(", ", ", ")\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numRows()), BoxesRunTime.boxToInteger((int)this.numCols())})));
        IntRef columnIndex = IntRef.create((int)0);
        int fieldWidth = ((Object)BoxesRunTime.boxToInteger((int)package$.MODULE$.max(this.numRows(), this.numCols()))).toString().length();
        int valueFieldWidth = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.doubleArrayOps(this.data()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(double x$1) {
                return this.apply$mcID$sp(x$1);
            }

            public int apply$mcID$sp(double x$1) {
                return ((Object)BoxesRunTime.boxToDouble((double)x$1)).toString().length();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).max((Ordering)Ordering.Int$.MODULE$)) + 2;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(this.colPtrs()).last())).foreach((Function1)new Serializable(this, result, columnIndex, fieldWidth, valueFieldWidth){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparseMatrix $outer;
            private final StringBuilder result$2;
            private final IntRef columnIndex$1;
            private final int fieldWidth$1;
            private final int valueFieldWidth$1;

            public final StringBuilder apply(int index) {
                while (this.$outer.colPtrs()[this.columnIndex$1.elem + 1] <= index) {
                    ++this.columnIndex$1.elem;
                }
                String rowStr = ((Object)BoxesRunTime.boxToInteger((int)this.$outer.rowIndices()[index])).toString();
                String columnStr = ((Object)BoxesRunTime.boxToInteger((int)this.columnIndex$1.elem)).toString();
                String valueStr = ((Object)BoxesRunTime.boxToDouble((double)this.$outer.data()[index])).toString();
                this.result$2.append(new StringBuilder().append((Object)"(").append((Object)new StringOps(Predef$.MODULE$.augmentString(" ")).$times(this.fieldWidth$1 - rowStr.length())).append((Object)rowStr).append((Object)",").append((Object)new StringOps(Predef$.MODULE$.augmentString(" ")).$times(this.fieldWidth$1 - columnStr.length())).append((Object)columnStr).append((Object)")").toString());
                this.result$2.append(new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString(" ")).$times(this.valueFieldWidth$1 - valueStr.length())).append((Object)valueStr).toString());
                return this.result$2.append("\n");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.result$2 = result$2;
                this.columnIndex$1 = columnIndex$1;
                this.fieldWidth$1 = fieldWidth$1;
                this.valueFieldWidth$1 = valueFieldWidth$1;
            }
        });
        return result.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof SparseMatrix)) return false;
        SparseMatrix sparseMatrix = (SparseMatrix)object;
        if (this.numRows() != sparseMatrix.numRows()) return false;
        if (this.numCols() != sparseMatrix.numCols()) return false;
        if (!Predef$.MODULE$.intArrayOps(this.rowIndices()).sameElements((GenIterable)Predef$.MODULE$.wrapIntArray(sparseMatrix.rowIndices()))) return false;
        if (!Predef$.MODULE$.intArrayOps(this.colPtrs()).sameElements((GenIterable)Predef$.MODULE$.wrapIntArray(sparseMatrix.colPtrs()))) return false;
        if (!Predef$.MODULE$.doubleArrayOps(this.data()).sameElements((GenIterable)Predef$.MODULE$.wrapDoubleArray(sparseMatrix.data()))) return false;
        return true;
    }

    public int hashCode() {
        List hashCodes = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((Object)BoxesRunTime.boxToInteger((int)this.numRows())).hashCode(), ((Object)BoxesRunTime.boxToInteger((int)this.numCols())).hashCode(), Arrays.hashCode(this.rowIndices()), Arrays.hashCode(this.colPtrs()), Arrays.hashCode(this.data())}));
        return BoxesRunTime.unboxToInt((Object)hashCodes.foldLeft((Object)BoxesRunTime.boxToInteger((int)5), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(int left, int right) {
                return this.apply$mcIII$sp(left, right);
            }

            public int apply$mcIII$sp(int left, int right) {
                return left * 41 + right;
            }
        }));
    }

    private int locate(int row, int col) {
        Predef$.MODULE$.require(0 <= row && row < this.numRows() && 0 <= col && col < this.numCols(), (Function0)new Serializable(this, row, col){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparseMatrix $outer;
            private final int row$1;
            private final int col$1;

            public final String apply() {
                return new StringBuilder().append((Object)Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)new Tuple2.mcII.sp(this.row$1, this.col$1)), " not in [0, ")).append((Object)BoxesRunTime.boxToInteger((int)this.$outer.numRows())).append((Object)") x [0, ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.numCols())).append((Object)")").toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.row$1 = row$1;
                this.col$1 = col$1;
            }
        });
        int startIndex = this.colPtrs()[col];
        int endIndex = this.colPtrs()[col + 1];
        return Arrays.binarySearch(this.rowIndices(), startIndex, endIndex, row);
    }

    @Override
    public SparseMatrix copy() {
        return new SparseMatrix(this.numRows(), this.numCols(), (int[])this.rowIndices().clone(), (int[])this.colPtrs().clone(), (double[])this.data().clone());
    }

    public SparseMatrix(int numRows, int numCols, int[] rowIndices, int[] colPtrs, double[] data) {
        this.numRows = numRows;
        this.numCols = numCols;
        this.rowIndices = rowIndices;
        this.colPtrs = colPtrs;
        this.data = data;
        Matrix$class.$init$(this);
    }
}

