/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.regression;

import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.ml.common.LabeledVector;
import org.apache.flink.ml.common.ParameterMap;
import org.apache.flink.ml.common.WeightVector;
import org.apache.flink.ml.common.WithParameters$class;
import org.apache.flink.ml.math.Vector;
import org.apache.flink.ml.optimization.GenericLossFunction;
import org.apache.flink.ml.optimization.LearningRateMethod;
import org.apache.flink.ml.package$;
import org.apache.flink.ml.pipeline.Estimator$class;
import org.apache.flink.ml.pipeline.EvaluateDataSetOperation;
import org.apache.flink.ml.pipeline.FitOperation;
import org.apache.flink.ml.pipeline.PredictDataSetOperation;
import org.apache.flink.ml.pipeline.Predictor;
import org.apache.flink.ml.pipeline.Predictor$class;
import org.apache.flink.ml.regression.MultipleLinearRegression$;
import org.apache.flink.ml.regression.MultipleLinearRegression$ConvergenceThreshold$;
import org.apache.flink.ml.regression.MultipleLinearRegression$Iterations$;
import org.apache.flink.ml.regression.MultipleLinearRegression$LearningRateMethodValue$;
import org.apache.flink.ml.regression.MultipleLinearRegression$Stepsize$;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u001de\u0001B\u0001\u0003\u00015\u0011\u0001$T;mi&\u0004H.\u001a'j]\u0016\f'OU3he\u0016\u001c8/[8o\u0015\t\u0019A!\u0001\u0006sK\u001e\u0014Xm]:j_:T!!\u0002\u0004\u0002\u00055d'BA\u0004\t\u0003\u00151G.\u001b8l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\r)\u0002DG\u0007\u0002-)\u0011q\u0003B\u0001\ta&\u0004X\r\\5oK&\u0011\u0011D\u0006\u0002\n!J,G-[2u_J\u0004\"a\u0007\u0001\u000e\u0003\tAQ!\b\u0001\u0005\u0002y\ta\u0001P5oSRtD#\u0001\u000e\t\u000f\u0001\u0002\u0001\u0019!C\u0001C\u0005iq/Z5hQR\u001cx\n\u001d;j_:,\u0012A\t\t\u0004\u001f\r*\u0013B\u0001\u0013\u0011\u0005\u0019y\u0005\u000f^5p]B\u0019aE\u000b\u0017\u000e\u0003\u001dR!!\u0005\u0015\u000b\u0005%2\u0011aA1qS&\u00111f\n\u0002\b\t\u0006$\u0018mU3u!\ti\u0003'D\u0001/\u0015\tyC!\u0001\u0004d_6lwN\\\u0005\u0003c9\u0012AbV3jO\"$h+Z2u_JDqa\r\u0001A\u0002\u0013\u0005A'A\txK&<\u0007\u000e^:PaRLwN\\0%KF$\"!\u000e\u001d\u0011\u0005=1\u0014BA\u001c\u0011\u0005\u0011)f.\u001b;\t\u000fe\u0012\u0014\u0011!a\u0001E\u0005\u0019\u0001\u0010J\u0019\t\rm\u0002\u0001\u0015)\u0003#\u000399X-[4iiN|\u0005\u000f^5p]\u0002BQ!\u0010\u0001\u0005\u0002y\nQb]3u\u0013R,'/\u0019;j_:\u001cHC\u0001\u000e@\u0011\u0015\u0001E\b1\u0001B\u0003)IG/\u001a:bi&|gn\u001d\t\u0003\u001f\tK!a\u0011\t\u0003\u0007%sG\u000fC\u0003F\u0001\u0011\u0005a)A\u0006tKR\u001cF/\u001a9tSj,GC\u0001\u000eH\u0011\u0015AE\t1\u0001J\u0003!\u0019H/\u001a9tSj,\u0007CA\bK\u0013\tY\u0005C\u0001\u0004E_V\u0014G.\u001a\u0005\u0006\u001b\u0002!\tAT\u0001\u0018g\u0016$8i\u001c8wKJ<WM\\2f)\"\u0014Xm\u001d5pY\u0012$\"AG(\t\u000bAc\u0005\u0019A%\u0002)\r|gN^3sO\u0016t7-\u001a+ie\u0016\u001c\bn\u001c7e\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0003U\u0019X\r\u001e'fCJt\u0017N\\4SCR,W*\u001a;i_\u0012$\"A\u0007+\t\u000bU\u000b\u0006\u0019\u0001,\u0002%1,\u0017M\u001d8j]\u001e\u0014\u0016\r^3NKRDw\u000e\u001a\t\u0003/&t!\u0001\u00174\u000f\u0005e#gB\u0001.d\u001d\tY&M\u0004\u0002]C:\u0011Q\fY\u0007\u0002=*\u0011q\fD\u0001\u0007yI|w\u000e\u001e \n\u0003-I!!\u0003\u0006\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\t)G!\u0001\u0007paRLW.\u001b>bi&|g.\u0003\u0002hQ\u0006\u0011B*Z1s]&twMU1uK6+G\u000f[8e\u0015\t)G!\u0003\u0002kW\n9B*Z1s]&twMU1uK6+G\u000f[8e)J\f\u0017\u000e\u001e\u0006\u0003O\"DQ!\u001c\u0001\u0005\u00029\f!c]9vCJ,GMU3tS\u0012,\u0018\r\\*v[R\u0011q\u000e\u001d\t\u0004M)J\u0005\"B9m\u0001\u0004\u0011\u0018!B5oaV$\bc\u0001\u0014+gB\u0011Q\u0006^\u0005\u0003k:\u0012Q\u0002T1cK2,GMV3di>\u0014x!B<\u0003\u0011\u0003A\u0018\u0001G'vYRL\u0007\u000f\\3MS:,\u0017M\u001d*fOJ,7o]5p]B\u00111$\u001f\u0004\u0006\u0003\tA\tA_\n\u0003s:AQ!H=\u0005\u0002q$\u0012\u0001\u001f\u0005\b}f\u0014\r\u0011\"\u0001\u0000\u0003Y9V)S$I)Z+5\tV(S?\n\u0013v*\u0011#D\u0003N#VCAA\u0001!\u0011\t\u0019!!\u0004\u000e\u0005\u0005\u0015!\u0002BA\u0004\u0003\u0013\tA\u0001\\1oO*\u0011\u00111B\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0010\u0005\u0015!AB*ue&tw\r\u0003\u0005\u0002\u0014e\u0004\u000b\u0011BA\u0001\u0003]9V)S$I)Z+5\tV(S?\n\u0013v*\u0011#D\u0003N#\u0006\u0005C\u0005\u0002\u0018e\u0014\r\u0011\"\u0001\u0002\u001a\u0005aAn\\:t\rVt7\r^5p]V\u0011\u00111\u0004\t\u0005\u0003;\ty\"D\u0001i\u0013\r\t\t\u0003\u001b\u0002\u0014\u000f\u0016tWM]5d\u0019>\u001c8OR;oGRLwN\u001c\u0005\t\u0003KI\b\u0015!\u0003\u0002\u001c\u0005iAn\\:t\rVt7\r^5p]\u0002:q!!\u000bz\u0011\u0003\u000bY#\u0001\u0005Ti\u0016\u00048/\u001b>f!\u0011\ti#a\f\u000e\u0003e4q!!\rz\u0011\u0003\u000b\u0019D\u0001\u0005Ti\u0016\u00048/\u001b>f'%\tyCDA\u001b\u0003w\t\t\u0005\u0005\u0003.\u0003oI\u0015bAA\u001d]\tI\u0001+\u0019:b[\u0016$XM\u001d\t\u0004\u001f\u0005u\u0012bAA !\t9\u0001K]8ek\u000e$\bcA\b\u0002D%\u0019\u0011Q\t\t\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000fu\ty\u0003\"\u0001\u0002JQ\u0011\u00111\u0006\u0005\u000b\u0003\u001b\nyC1A\u0005\u0002\u0005=\u0013\u0001\u00043fM\u0006,H\u000e\u001e,bYV,WCAA)!\u0011y\u00111K%\n\u0007\u0005U\u0003C\u0001\u0003T_6,\u0007\"CA-\u0003_\u0001\u000b\u0011BA)\u00035!WMZ1vYR4\u0016\r\\;fA!I\u0011QLA\u0018\u0003\u0003%\te`\u0001\u000eaJ|G-^2u!J,g-\u001b=\t\u0015\u0005\u0005\u0014qFA\u0001\n\u0003\t\u0019'\u0001\u0007qe>$Wo\u0019;Be&$\u00180F\u0001B\u0011)\t9'a\f\u0002\u0002\u0013\u0005\u0011\u0011N\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tY'!\u001d\u0011\u0007=\ti'C\u0002\u0002pA\u00111!\u00118z\u0011!I\u0014QMA\u0001\u0002\u0004\t\u0005BCA;\u0003_\t\t\u0011\"\u0011\u0002x\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002zA1\u00111PAA\u0003Wj!!! \u000b\u0007\u0005}\u0004#\u0001\u0006d_2dWm\u0019;j_:LA!a!\u0002~\tA\u0011\n^3sCR|'\u000f\u0003\u0006\u0002\b\u0006=\u0012\u0011!C\u0001\u0003\u0013\u000b\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u0017\u000b\t\nE\u0002\u0010\u0003\u001bK1!a$\u0011\u0005\u001d\u0011un\u001c7fC:D\u0011\"OAC\u0003\u0003\u0005\r!a\u001b\t\u0015\u0005U\u0015qFA\u0001\n\u0003\n9*\u0001\u0005iCND7i\u001c3f)\u0005\t\u0005BCAN\u0003_\t\t\u0011\"\u0011\u0002\u001e\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\u0002!Q\u0011\u0011UA\u0018\u0003\u0003%I!a)\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003K\u0003B!a\u0001\u0002(&!\u0011\u0011VA\u0003\u0005\u0019y%M[3di\u001e9\u0011QV=\t\u0002\u0006=\u0016AC%uKJ\fG/[8ogB!\u0011QFAY\r\u001d\t\u0019,\u001fEA\u0003k\u0013!\"\u0013;fe\u0006$\u0018n\u001c8t'%\t\tLDA\\\u0003w\t\t\u0005\u0005\u0003.\u0003o\t\u0005bB\u000f\u00022\u0012\u0005\u00111\u0018\u000b\u0003\u0003_C!\"!\u0014\u00022\n\u0007I\u0011AA`+\t\t\t\r\u0005\u0003\u0010\u0003'\n\u0005\"CA-\u0003c\u0003\u000b\u0011BAa\u0011%\ti&!-\u0002\u0002\u0013\u0005s\u0010\u0003\u0006\u0002b\u0005E\u0016\u0011!C\u0001\u0003GB!\"a\u001a\u00022\u0006\u0005I\u0011AAf)\u0011\tY'!4\t\u0011e\nI-!AA\u0002\u0005C!\"!\u001e\u00022\u0006\u0005I\u0011IA<\u0011)\t9)!-\u0002\u0002\u0013\u0005\u00111\u001b\u000b\u0005\u0003\u0017\u000b)\u000eC\u0005:\u0003#\f\t\u00111\u0001\u0002l!Q\u0011QSAY\u0003\u0003%\t%a&\t\u0015\u0005m\u0015\u0011WA\u0001\n\u0003\ni\n\u0003\u0006\u0002\"\u0006E\u0016\u0011!C\u0005\u0003G;q!a8z\u0011\u0003\u000b\t/\u0001\u000bD_:4XM]4f]\u000e,G\u000b\u001b:fg\"|G\u000e\u001a\t\u0005\u0003[\t\u0019OB\u0004\u0002ffD\t)a:\u0003)\r{gN^3sO\u0016t7-\u001a+ie\u0016\u001c\bn\u001c7e'%\t\u0019ODA\u001b\u0003w\t\t\u0005C\u0004\u001e\u0003G$\t!a;\u0015\u0005\u0005\u0005\bBCA'\u0003G\u0014\r\u0011\"\u0001\u0002pV\u0011\u0011\u0011\u001f\b\u0004\u001f\u0005M\u0018bAA{!\u0005!aj\u001c8f\u0011%\tI&a9!\u0002\u0013\t\t\u0010C\u0005\u0002^\u0005\r\u0018\u0011!C!\u007f\"Q\u0011\u0011MAr\u0003\u0003%\t!a\u0019\t\u0015\u0005\u001d\u00141]A\u0001\n\u0003\ty\u0010\u0006\u0003\u0002l\t\u0005\u0001\u0002C\u001d\u0002~\u0006\u0005\t\u0019A!\t\u0015\u0005U\u00141]A\u0001\n\u0003\n9\b\u0003\u0006\u0002\b\u0006\r\u0018\u0011!C\u0001\u0005\u000f!B!a#\u0003\n!I\u0011H!\u0002\u0002\u0002\u0003\u0007\u00111\u000e\u0005\u000b\u0003+\u000b\u0019/!A\u0005B\u0005]\u0005BCAN\u0003G\f\t\u0011\"\u0011\u0002\u001e\"Q\u0011\u0011UAr\u0003\u0003%I!a)\b\u000f\tM\u0011\u0010#!\u0003\u0016\u00059B*Z1s]&twMU1uK6+G\u000f[8e-\u0006dW/\u001a\t\u0005\u0003[\u00119BB\u0004\u0003\u001aeD\tIa\u0007\u0003/1+\u0017M\u001d8j]\u001e\u0014\u0016\r^3NKRDw\u000e\u001a,bYV,7#\u0003B\f\u001d\tu\u00111HA!!\u0011i\u0013q\u0007,\t\u000fu\u00119\u0002\"\u0001\u0003\"Q\u0011!Q\u0003\u0005\u000b\u0003\u001b\u00129B1A\u0005\u0002\u0005=\b\"CA-\u0005/\u0001\u000b\u0011BAy\u0011%\tiFa\u0006\u0002\u0002\u0013\u0005s\u0010\u0003\u0006\u0002b\t]\u0011\u0011!C\u0001\u0003GB!\"a\u001a\u0003\u0018\u0005\u0005I\u0011\u0001B\u0017)\u0011\tYGa\f\t\u0011e\u0012Y#!AA\u0002\u0005C!\"!\u001e\u0003\u0018\u0005\u0005I\u0011IA<\u0011)\t9Ia\u0006\u0002\u0002\u0013\u0005!Q\u0007\u000b\u0005\u0003\u0017\u00139\u0004C\u0005:\u0005g\t\t\u00111\u0001\u0002l!Q\u0011Q\u0013B\f\u0003\u0003%\t%a&\t\u0015\u0005m%qCA\u0001\n\u0003\ni\n\u0003\u0006\u0002\"\n]\u0011\u0011!C\u0005\u0003GCaA!\u0011z\t\u0003q\u0012!B1qa2L\b\"\u0003B#s\n\u0007I1\u0001B$\u0003\u00191\u0017\u000e^'M%V\u0011!\u0011\n\n\u0006\u0005\u0017r!1\u000b\u0004\b\u0005\u001b\u0012y\u0005\u0001B%\u00051a$/\u001a4j]\u0016lWM\u001c;?\u0011!\u0011\t&\u001fQ\u0001\n\t%\u0013a\u00024ji6c%\u000b\t\t\u0006+\tU#d]\u0005\u0004\u0005/2\"\u0001\u0004$ji>\u0003XM]1uS>t\u0007b\u0002B.s\u0012\r!QL\u0001\u000faJ,G-[2u-\u0016\u001cGo\u001c:t+\u0011\u0011yFa\u001c\u0016\u0005\t\u0005$#\u0002B2\u001d\t\u0015da\u0002B'\u00053\u0002!\u0011\r\t\t+\t\u001d$\u0004\fB6\u0013&\u0019!\u0011\u000e\f\u0003!A\u0013X\rZ5di>\u0003XM]1uS>t\u0007\u0003\u0002B7\u0005_b\u0001\u0001\u0002\u0005\u0003r\te#\u0019\u0001B:\u0005\u0005!\u0016\u0003\u0002B;\u0005w\u00022a\u0004B<\u0013\r\u0011I\b\u0005\u0002\b\u001d>$\b.\u001b8h!\u0011\u0011iHa!\u000e\u0005\t}$b\u0001BA\t\u0005!Q.\u0019;i\u0013\u0011\u0011)Ia \u0003\rY+7\r^8s\u0001")
public class MultipleLinearRegression
implements Predictor<MultipleLinearRegression> {
    private Option<DataSet<WeightVector>> weightsOption;
    private final ParameterMap parameters;

    public static <T extends Vector> Object predictVectors() {
        return MultipleLinearRegression$.MODULE$.predictVectors();
    }

    public static Object fitMLR() {
        return MultipleLinearRegression$.MODULE$.fitMLR();
    }

    public static MultipleLinearRegression apply() {
        return MultipleLinearRegression$.MODULE$.apply();
    }

    public static GenericLossFunction lossFunction() {
        return MultipleLinearRegression$.MODULE$.lossFunction();
    }

    public static String WEIGHTVECTOR_BROADCAST() {
        return MultipleLinearRegression$.MODULE$.WEIGHTVECTOR_BROADCAST();
    }

    @Override
    public <Testing, Prediction> DataSet<Prediction> predict(DataSet<Testing> testing, ParameterMap predictParameters, PredictDataSetOperation<MultipleLinearRegression, Testing, Prediction> predictor) {
        return Predictor$class.predict(this, testing, predictParameters, predictor);
    }

    @Override
    public <Testing, PredictionValue> DataSet<Tuple2<PredictionValue, PredictionValue>> evaluate(DataSet<Testing> testing, ParameterMap evaluateParameters, EvaluateDataSetOperation<MultipleLinearRegression, Testing, PredictionValue> evaluator) {
        return Predictor$class.evaluate(this, testing, evaluateParameters, evaluator);
    }

    @Override
    public <Testing, Prediction> ParameterMap predict$default$2() {
        return Predictor$class.predict$default$2(this);
    }

    @Override
    public <Testing, PredictionValue> ParameterMap evaluate$default$2() {
        return Predictor$class.evaluate$default$2(this);
    }

    @Override
    public <Training> void fit(DataSet<Training> training, ParameterMap fitParameters, FitOperation<MultipleLinearRegression, Training> fitOperation) {
        Estimator$class.fit(this, training, fitParameters, fitOperation);
    }

    @Override
    public <Training> ParameterMap fit$default$2() {
        return Estimator$class.fit$default$2(this);
    }

    @Override
    public ParameterMap parameters() {
        return this.parameters;
    }

    @Override
    public void org$apache$flink$ml$common$WithParameters$_setter_$parameters_$eq(ParameterMap x$1) {
        this.parameters = x$1;
    }

    public Option<DataSet<WeightVector>> weightsOption() {
        return this.weightsOption;
    }

    public void weightsOption_$eq(Option<DataSet<WeightVector>> x$1) {
        this.weightsOption = x$1;
    }

    public MultipleLinearRegression setIterations(int iterations) {
        this.parameters().add(MultipleLinearRegression$Iterations$.MODULE$, BoxesRunTime.boxToInteger((int)iterations));
        return this;
    }

    public MultipleLinearRegression setStepsize(double stepsize) {
        this.parameters().add(MultipleLinearRegression$Stepsize$.MODULE$, BoxesRunTime.boxToDouble((double)stepsize));
        return this;
    }

    public MultipleLinearRegression setConvergenceThreshold(double convergenceThreshold) {
        this.parameters().add(MultipleLinearRegression$ConvergenceThreshold$.MODULE$, BoxesRunTime.boxToDouble((double)convergenceThreshold));
        return this;
    }

    public MultipleLinearRegression setLearningRateMethod(LearningRateMethod.LearningRateMethodTrait learningRateMethod) {
        this.parameters().add(MultipleLinearRegression$LearningRateMethodValue$.MODULE$, learningRateMethod);
        return this;
    }

    public DataSet<Object> squaredResidualSum(DataSet<LabeledVector> input) {
        Option<DataSet<WeightVector>> option = this.weightsOption();
        if (option instanceof Some) {
            Some some = (Some)option;
            DataSet weights = (DataSet)some.x();
            DataSet dataSet = package$.MODULE$.RichDataSet(input).mapWithBcVariable(weights, new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(LabeledVector dataPoint, WeightVector weights) {
                    return MultipleLinearRegression$.MODULE$.lossFunction().loss(dataPoint, weights);
                }
            }, BasicTypeInfo.getInfoFor(Double.TYPE), ClassTag$.MODULE$.Double()).reduce((Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(double x$1, double x$2) {
                    return this.apply$mcDDD$sp(x$1, x$2);
                }

                public double apply$mcDDD$sp(double x$1, double x$2) {
                    return x$1 + x$2;
                }
            });
            return dataSet;
        }
        if (None$.MODULE$.equals(option)) {
            throw new RuntimeException("The MultipleLinearRegression has not been fitted to the data. This is necessary to learn the weight vector of the linear function.");
        }
        throw new MatchError(option);
    }

    public MultipleLinearRegression() {
        WithParameters$class.$init$(this);
        Estimator$class.$init$(this);
        Predictor$class.$init$(this);
        this.weightsOption = None$.MODULE$;
    }
}

