/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.NoTagsKeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.TagCompressionContext;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.encoding.EncoderBufferTooSmallException;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultEncodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockEncodingContext;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.util.LRUDictionary;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableUtils;

@InterfaceAudience.Private
abstract class BufferedDataBlockEncoder
implements DataBlockEncoder {
    private static int INITIAL_KEY_BUFFER_SIZE = 512;

    BufferedDataBlockEncoder() {
    }

    @Override
    public ByteBuffer decodeKeyValues(DataInputStream source, HFileBlockDecodingContext blkDecodingCtx) throws IOException {
        if (blkDecodingCtx.getClass() != HFileBlockDefaultDecodingContext.class) {
            throw new IOException(this.getClass().getName() + " only accepts " + HFileBlockDefaultDecodingContext.class.getName() + " as the decoding context.");
        }
        HFileBlockDefaultDecodingContext decodingCtx = (HFileBlockDefaultDecodingContext)blkDecodingCtx;
        if (decodingCtx.getHFileContext().isIncludesTags() && decodingCtx.getHFileContext().isCompressTags()) {
            if (decodingCtx.getTagCompressionContext() != null) {
                decodingCtx.getTagCompressionContext().clear();
            } else {
                try {
                    TagCompressionContext tagCompressionContext = new TagCompressionContext(LRUDictionary.class, 127);
                    decodingCtx.setTagCompressionContext(tagCompressionContext);
                }
                catch (Exception e) {
                    throw new IOException("Failed to initialize TagCompressionContext", e);
                }
            }
        }
        return this.internalDecodeKeyValues(source, 0, 0, decodingCtx);
    }

    protected final void afterEncodingKeyValue(ByteBuffer in, DataOutputStream out, HFileBlockDefaultEncodingContext encodingCtx) throws IOException {
        if (encodingCtx.getHFileContext().isIncludesTags()) {
            int tagsLength = (in.get() & 0xFF) << 8 ^ in.get() & 0xFF;
            ByteBufferUtils.putCompressedInt(out, tagsLength);
            if (tagsLength > 0) {
                TagCompressionContext tagCompressionContext = encodingCtx.getTagCompressionContext();
                if (tagCompressionContext != null) {
                    tagCompressionContext.compressTags(out, in, tagsLength);
                } else {
                    ByteBufferUtils.moveBufferToStream(out, in, tagsLength);
                }
            }
        }
        if (encodingCtx.getHFileContext().isIncludesMvcc()) {
            long memstoreTS = -1L;
            try {
                memstoreTS = ByteBufferUtils.readVLong(in);
                WritableUtils.writeVLong((DataOutput)out, (long)memstoreTS);
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to copy memstore timestamp " + memstoreTS + " after encoding a key/value");
            }
        }
    }

    protected final void afterDecodingKeyValue(DataInputStream source, ByteBuffer dest, HFileBlockDefaultDecodingContext decodingCtx) throws IOException {
        if (decodingCtx.getHFileContext().isIncludesTags()) {
            int tagsLength = ByteBufferUtils.readCompressedInt(source);
            dest.put((byte)(tagsLength >> 8 & 0xFF));
            dest.put((byte)(tagsLength & 0xFF));
            if (tagsLength > 0) {
                TagCompressionContext tagCompressionContext = decodingCtx.getTagCompressionContext();
                if (tagCompressionContext != null) {
                    tagCompressionContext.uncompressTags(source, dest, tagsLength);
                } else {
                    ByteBufferUtils.copyFromStreamToBuffer(dest, source, tagsLength);
                }
            }
        }
        if (decodingCtx.getHFileContext().isIncludesMvcc()) {
            long memstoreTS = -1L;
            try {
                memstoreTS = WritableUtils.readVLong((DataInput)source);
                ByteBufferUtils.writeVLong(dest, memstoreTS);
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to copy memstore timestamp " + memstoreTS + " after decoding a key/value");
            }
        }
    }

    @Override
    public HFileBlockEncodingContext newDataBlockEncodingContext(DataBlockEncoding encoding, byte[] header, HFileContext meta) {
        return new HFileBlockDefaultEncodingContext(encoding, header, meta);
    }

    @Override
    public HFileBlockDecodingContext newDataBlockDecodingContext(HFileContext meta) {
        return new HFileBlockDefaultDecodingContext(meta);
    }

    public abstract void internalEncodeKeyValues(DataOutputStream var1, ByteBuffer var2, HFileBlockDefaultEncodingContext var3) throws IOException;

    protected abstract ByteBuffer internalDecodeKeyValues(DataInputStream var1, int var2, int var3, HFileBlockDefaultDecodingContext var4) throws IOException;

    @Override
    public void encodeKeyValues(ByteBuffer in, HFileBlockEncodingContext blkEncodingCtx) throws IOException {
        if (blkEncodingCtx.getClass() != HFileBlockDefaultEncodingContext.class) {
            throw new IOException(this.getClass().getName() + " only accepts " + HFileBlockDefaultEncodingContext.class.getName() + " as the " + "encoding context.");
        }
        HFileBlockDefaultEncodingContext encodingCtx = (HFileBlockDefaultEncodingContext)blkEncodingCtx;
        encodingCtx.prepareEncoding();
        DataOutputStream dataOut = encodingCtx.getOutputStreamForEncoder();
        if (encodingCtx.getHFileContext().isIncludesTags() && encodingCtx.getHFileContext().isCompressTags()) {
            if (encodingCtx.getTagCompressionContext() != null) {
                encodingCtx.getTagCompressionContext().clear();
            } else {
                try {
                    TagCompressionContext tagCompressionContext = new TagCompressionContext(LRUDictionary.class, 127);
                    encodingCtx.setTagCompressionContext(tagCompressionContext);
                }
                catch (Exception e) {
                    throw new IOException("Failed to initialize TagCompressionContext", e);
                }
            }
        }
        this.internalEncodeKeyValues(dataOut, in, encodingCtx);
        if (encodingCtx.getDataBlockEncoding() != DataBlockEncoding.NONE) {
            encodingCtx.postEncoding(BlockType.ENCODED_DATA);
        } else {
            encodingCtx.postEncoding(BlockType.DATA);
        }
    }

    protected static void ensureSpace(ByteBuffer out, int length) throws EncoderBufferTooSmallException {
        if (out.position() + length > out.limit()) {
            throw new EncoderBufferTooSmallException("Buffer position=" + out.position() + ", buffer limit=" + out.limit() + ", length to be written=" + length);
        }
    }

    protected static abstract class BufferedEncodedSeeker<STATE extends SeekerState>
    implements DataBlockEncoder.EncodedSeeker {
        protected HFileBlockDecodingContext decodingCtx;
        protected final KeyValue.KVComparator comparator;
        protected final KeyValue.SamePrefixComparator<byte[]> samePrefixComparator;
        protected ByteBuffer currentBuffer;
        protected STATE current;
        protected STATE previous;
        protected TagCompressionContext tagCompressionContext = null;

        public BufferedEncodedSeeker(KeyValue.KVComparator comparator, HFileBlockDecodingContext decodingCtx) {
            this.comparator = comparator;
            this.samePrefixComparator = comparator;
            this.decodingCtx = decodingCtx;
            if (decodingCtx.getHFileContext().isCompressTags()) {
                try {
                    this.tagCompressionContext = new TagCompressionContext(LRUDictionary.class, 127);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to initialize TagCompressionContext", e);
                }
            }
            this.current = this.createSeekerState();
            this.previous = this.createSeekerState();
        }

        protected boolean includesMvcc() {
            return this.decodingCtx.getHFileContext().isIncludesMvcc();
        }

        protected boolean includesTags() {
            return this.decodingCtx.getHFileContext().isIncludesTags();
        }

        @Override
        public int compareKey(KeyValue.KVComparator comparator, byte[] key, int offset, int length) {
            return comparator.compareFlatKey(key, offset, length, ((SeekerState)this.current).keyBuffer, 0, ((SeekerState)this.current).keyLength);
        }

        @Override
        public void setCurrentBuffer(ByteBuffer buffer) {
            if (this.tagCompressionContext != null) {
                this.tagCompressionContext.clear();
            }
            this.currentBuffer = buffer;
            this.decodeFirst();
            ((SeekerState)this.previous).invalidate();
        }

        @Override
        public ByteBuffer getKeyDeepCopy() {
            ByteBuffer keyBuffer = ByteBuffer.allocate(((SeekerState)this.current).keyLength);
            keyBuffer.put(((SeekerState)this.current).keyBuffer, 0, ((SeekerState)this.current).keyLength);
            keyBuffer.rewind();
            return keyBuffer;
        }

        @Override
        public ByteBuffer getValueShallowCopy() {
            return ByteBuffer.wrap(this.currentBuffer.array(), this.currentBuffer.arrayOffset() + ((SeekerState)this.current).valueOffset, ((SeekerState)this.current).valueLength);
        }

        @Override
        public KeyValue getKeyValue() {
            byte[] kvBuf = new byte[(int)KeyValue.getKeyValueDataStructureSize(((SeekerState)this.current).keyLength, ((SeekerState)this.current).valueLength, ((SeekerState)this.current).tagsLength)];
            int offset = Bytes.putInt(kvBuf, 0, ((SeekerState)this.current).keyLength);
            offset = Bytes.putInt(kvBuf, offset, ((SeekerState)this.current).valueLength);
            System.arraycopy(((SeekerState)this.current).keyBuffer, 0, kvBuf, offset, ((SeekerState)this.current).keyLength);
            System.arraycopy(this.currentBuffer.array(), this.currentBuffer.arrayOffset() + ((SeekerState)this.current).valueOffset, kvBuf, offset += ((SeekerState)this.current).keyLength, ((SeekerState)this.current).valueLength);
            offset += ((SeekerState)this.current).valueLength;
            if (((SeekerState)this.current).tagsLength > 0) {
                offset = Bytes.putByte(kvBuf, offset, (byte)(((SeekerState)this.current).tagsLength >> 8 & 0xFF));
                offset = Bytes.putByte(kvBuf, offset, (byte)(((SeekerState)this.current).tagsLength & 0xFF));
                if (((SeekerState)this.current).tagsOffset != -1) {
                    System.arraycopy(this.currentBuffer.array(), this.currentBuffer.arrayOffset() + ((SeekerState)this.current).tagsOffset, kvBuf, offset, ((SeekerState)this.current).tagsLength);
                } else {
                    System.arraycopy(((SeekerState)this.current).tagsBuffer, 0, kvBuf, offset, ((SeekerState)this.current).tagsLength);
                }
            }
            KeyValue kv = ((SeekerState)this.current).tagsLength == 0 ? new NoTagsKeyValue(kvBuf, 0, kvBuf.length) : new KeyValue(kvBuf, 0, kvBuf.length);
            kv.setMvccVersion(((SeekerState)this.current).memstoreTS);
            return kv;
        }

        @Override
        public void rewind() {
            this.currentBuffer.rewind();
            if (this.tagCompressionContext != null) {
                this.tagCompressionContext.clear();
            }
            this.decodeFirst();
            ((SeekerState)this.previous).invalidate();
        }

        @Override
        public boolean next() {
            if (!this.currentBuffer.hasRemaining()) {
                return false;
            }
            this.decodeNext();
            ((SeekerState)this.previous).invalidate();
            return true;
        }

        protected void decodeTags() {
            ((SeekerState)this.current).tagsLength = ByteBufferUtils.readCompressedInt(this.currentBuffer);
            if (this.tagCompressionContext != null) {
                if (((SeekerState)this.current).uncompressTags) {
                    ((SeekerState)this.current).ensureSpaceForTags();
                    try {
                        ((SeekerState)this.current).tagsCompressedLength = this.tagCompressionContext.uncompressTags(this.currentBuffer, ((SeekerState)this.current).tagsBuffer, 0, ((SeekerState)this.current).tagsLength);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Exception while uncompressing tags", e);
                    }
                } else {
                    ByteBufferUtils.skip(this.currentBuffer, ((SeekerState)this.current).tagsCompressedLength);
                    ((SeekerState)this.current).uncompressTags = true;
                }
                ((SeekerState)this.current).tagsOffset = -1;
            } else {
                ((SeekerState)this.current).tagsOffset = this.currentBuffer.position();
                ByteBufferUtils.skip(this.currentBuffer, ((SeekerState)this.current).tagsLength);
            }
        }

        @Override
        public int seekToKeyInBlock(byte[] key, int offset, int length, boolean seekBefore) {
            int commonPrefix = 0;
            ((SeekerState)this.previous).invalidate();
            while (true) {
                int comp;
                if (this.samePrefixComparator != null) {
                    commonPrefix = Math.min(commonPrefix, ((SeekerState)this.current).lastCommonPrefix);
                    commonPrefix += ByteBufferUtils.findCommonPrefix(key, offset + commonPrefix, length - commonPrefix, ((SeekerState)this.current).keyBuffer, commonPrefix, ((SeekerState)this.current).keyLength - commonPrefix);
                    comp = this.samePrefixComparator.compareIgnoringPrefix(commonPrefix, key, offset, length, ((SeekerState)this.current).keyBuffer, 0, ((SeekerState)this.current).keyLength);
                } else {
                    comp = this.comparator.compareFlatKey(key, offset, length, ((SeekerState)this.current).keyBuffer, 0, ((SeekerState)this.current).keyLength);
                }
                if (comp == 0) {
                    if (seekBefore) {
                        if (!((SeekerState)this.previous).isValid()) {
                            throw new IllegalStateException("Cannot seekBefore if positioned at the first key in the block: key=" + Bytes.toStringBinary(key, offset, length));
                        }
                        this.moveToPrevious();
                        return 1;
                    }
                    return 0;
                }
                if (comp < 0) {
                    if (!((SeekerState)this.previous).isValid()) {
                        return -2;
                    }
                    this.moveToPrevious();
                    return 1;
                }
                if (!this.currentBuffer.hasRemaining()) break;
                ((SeekerState)this.previous).copyFromNext((SeekerState)this.current);
                this.decodeNext();
            }
            return 1;
        }

        private void moveToPrevious() {
            if (!((SeekerState)this.previous).isValid()) {
                throw new IllegalStateException("Can move back only once and not in first key in the block.");
            }
            STATE tmp = this.previous;
            this.previous = this.current;
            this.current = tmp;
            this.currentBuffer.position(((SeekerState)this.current).nextKvOffset);
            ((SeekerState)this.current).tagsBuffer = ((SeekerState)this.previous).tagsBuffer;
            ((SeekerState)this.current).tagsCompressedLength = ((SeekerState)this.previous).tagsCompressedLength;
            ((SeekerState)this.current).uncompressTags = false;
            ((SeekerState)this.previous).invalidate();
        }

        protected STATE createSeekerState() {
            return (STATE)new SeekerState();
        }

        protected abstract void decodeFirst();

        protected abstract void decodeNext();
    }

    protected static class SeekerState {
        protected int valueOffset = -1;
        protected int keyLength;
        protected int valueLength;
        protected int lastCommonPrefix;
        protected int tagsLength = 0;
        protected int tagsOffset = -1;
        protected int tagsCompressedLength = 0;
        protected boolean uncompressTags = true;
        protected byte[] keyBuffer = HConstants.EMPTY_BYTE_ARRAY;
        protected byte[] tagsBuffer = HConstants.EMPTY_BYTE_ARRAY;
        protected long memstoreTS;
        protected int nextKvOffset;

        protected boolean isValid() {
            return this.valueOffset != -1;
        }

        protected void invalidate() {
            this.valueOffset = -1;
            this.tagsCompressedLength = 0;
            this.uncompressTags = true;
        }

        protected void ensureSpaceForKey() {
            if (this.keyLength > this.keyBuffer.length) {
                int newKeyBufferLength = Integer.highestOneBit(Math.max(INITIAL_KEY_BUFFER_SIZE, this.keyLength) - 1) << 1;
                byte[] newKeyBuffer = new byte[newKeyBufferLength];
                System.arraycopy(this.keyBuffer, 0, newKeyBuffer, 0, this.keyBuffer.length);
                this.keyBuffer = newKeyBuffer;
            }
        }

        protected void ensureSpaceForTags() {
            if (this.tagsLength > this.tagsBuffer.length) {
                int newTagsBufferLength = Integer.highestOneBit(Math.max(INITIAL_KEY_BUFFER_SIZE, this.tagsLength) - 1) << 1;
                byte[] newTagsBuffer = new byte[newTagsBufferLength];
                System.arraycopy(this.tagsBuffer, 0, newTagsBuffer, 0, this.tagsBuffer.length);
                this.tagsBuffer = newTagsBuffer;
            }
        }

        protected void copyFromNext(SeekerState nextState) {
            if (this.keyBuffer.length != nextState.keyBuffer.length) {
                this.keyBuffer = (byte[])nextState.keyBuffer.clone();
            } else if (!this.isValid()) {
                System.arraycopy(nextState.keyBuffer, 0, this.keyBuffer, 0, nextState.keyLength);
            } else {
                System.arraycopy(nextState.keyBuffer, nextState.lastCommonPrefix, this.keyBuffer, nextState.lastCommonPrefix, nextState.keyLength - nextState.lastCommonPrefix);
            }
            this.valueOffset = nextState.valueOffset;
            this.keyLength = nextState.keyLength;
            this.valueLength = nextState.valueLength;
            this.lastCommonPrefix = nextState.lastCommonPrefix;
            this.nextKvOffset = nextState.nextKvOffset;
            this.memstoreTS = nextState.memstoreTS;
            this.tagsOffset = nextState.tagsOffset;
            this.tagsLength = nextState.tagsLength;
        }
    }
}

