/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceImpl;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceSource;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;

public class MetricsReplicationGlobalSourceSource
implements MetricsReplicationSourceSource {
    private final MetricsReplicationSourceImpl rms;
    private final MutableGaugeLong ageOfLastShippedOpGauge;
    private final MutableGaugeLong sizeOfLogQueueGauge;
    private final MutableCounterLong logReadInEditsCounter;
    private final MutableCounterLong logEditsFilteredCounter;
    private final MutableCounterLong shippedBatchesCounter;
    private final MutableCounterLong shippedOpsCounter;
    private final MutableCounterLong shippedKBsCounter;
    private final MutableCounterLong logReadInBytesCounter;
    private final MutableCounterLong unknownFileLengthForClosedWAL;
    private final MutableCounterLong uncleanlyClosedWAL;
    private final MutableCounterLong uncleanlyClosedSkippedBytes;
    private final MutableCounterLong restartWALReading;
    private final MutableCounterLong repeatedFileBytes;
    private final MutableCounterLong completedWAL;
    private final MutableCounterLong completedRecoveryQueue;

    public MetricsReplicationGlobalSourceSource(MetricsReplicationSourceImpl rms) {
        this.rms = rms;
        this.ageOfLastShippedOpGauge = rms.getMetricsRegistry().getLongGauge("source.ageOfLastShippedOp", 0L);
        this.sizeOfLogQueueGauge = rms.getMetricsRegistry().getLongGauge("source.sizeOfLogQueue", 0L);
        this.shippedBatchesCounter = rms.getMetricsRegistry().getLongCounter("source.shippedBatches", 0L);
        this.shippedOpsCounter = rms.getMetricsRegistry().getLongCounter("source.shippedOps", 0L);
        this.shippedKBsCounter = rms.getMetricsRegistry().getLongCounter("source.shippedKBs", 0L);
        this.logReadInBytesCounter = rms.getMetricsRegistry().getLongCounter("source.logReadInBytes", 0L);
        this.logReadInEditsCounter = rms.getMetricsRegistry().getLongCounter("source.logEditsRead", 0L);
        this.logEditsFilteredCounter = rms.getMetricsRegistry().getLongCounter("source.logEditsFiltered", 0L);
        this.unknownFileLengthForClosedWAL = rms.getMetricsRegistry().getLongCounter("source.closedLogsWithUnknownFileLength", 0L);
        this.uncleanlyClosedWAL = rms.getMetricsRegistry().getLongCounter("source.uncleanlyClosedLogs", 0L);
        this.uncleanlyClosedSkippedBytes = rms.getMetricsRegistry().getLongCounter("source.ignoredUncleanlyClosedLogContentsInBytes", 0L);
        this.restartWALReading = rms.getMetricsRegistry().getLongCounter("source.restartedLogReading", 0L);
        this.repeatedFileBytes = rms.getMetricsRegistry().getLongCounter("source.repeatedLogFileBytes", 0L);
        this.completedWAL = rms.getMetricsRegistry().getLongCounter("source.completedLogs", 0L);
        this.completedRecoveryQueue = rms.getMetricsRegistry().getLongCounter("source.completedRecoverQueues", 0L);
    }

    public void setLastShippedAge(long age) {
        this.ageOfLastShippedOpGauge.set(age);
    }

    public void setSizeOfLogQueue(int size) {
        this.sizeOfLogQueueGauge.set((long)size);
    }

    public void incrSizeOfLogQueue(int size) {
        this.sizeOfLogQueueGauge.incr((long)size);
    }

    public void decrSizeOfLogQueue(int size) {
        this.sizeOfLogQueueGauge.decr((long)size);
    }

    public void incrLogReadInEdits(long size) {
        this.logReadInEditsCounter.incr(size);
    }

    public void incrLogEditsFiltered(long size) {
        this.logEditsFilteredCounter.incr(size);
    }

    public void incrBatchesShipped(int batches) {
        this.shippedBatchesCounter.incr((long)batches);
    }

    public void incrOpsShipped(long ops) {
        this.shippedOpsCounter.incr(ops);
    }

    public void incrShippedKBs(long size) {
        this.shippedKBsCounter.incr(size);
    }

    public void incrLogReadInBytes(long size) {
        this.logReadInBytesCounter.incr(size);
    }

    public void clear() {
    }

    public long getLastShippedAge() {
        return this.ageOfLastShippedOpGauge.value();
    }

    public void incrUnknownFileLengthForClosedWAL() {
        this.unknownFileLengthForClosedWAL.incr(1L);
    }

    public void incrUncleanlyClosedWALs() {
        this.uncleanlyClosedWAL.incr(1L);
    }

    public void incrBytesSkippedInUncleanlyClosedWALs(long bytes) {
        this.uncleanlyClosedSkippedBytes.incr(bytes);
    }

    public void incrRestartedWALReading() {
        this.restartWALReading.incr(1L);
    }

    public void incrRepeatedFileBytes(long bytes) {
        this.repeatedFileBytes.incr(bytes);
    }

    public void incrCompletedWAL() {
        this.completedWAL.incr(1L);
    }

    public void incrCompletedRecoveryQueue() {
        this.completedRecoveryQueue.incr(1L);
    }
}

