/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.Closeable;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.util.Threads;

@InterfaceAudience.Private
public abstract class HBaseCluster
implements Closeable,
Configurable {
    static final Log LOG = LogFactory.getLog((String)HBaseCluster.class.getName());
    protected Configuration conf;
    protected ClusterStatus initialClusterStatus;

    public HBaseCluster(Configuration conf) {
        this.setConf(conf);
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public abstract ClusterStatus getClusterStatus() throws IOException;

    public ClusterStatus getInitialClusterStatus() throws IOException {
        return this.initialClusterStatus;
    }

    public abstract MasterProtos.MasterService.BlockingInterface getMaster() throws IOException;

    public abstract AdminProtos.AdminService.BlockingInterface getAdminProtocol(ServerName var1) throws IOException;

    public abstract ClientProtos.ClientService.BlockingInterface getClientProtocol(ServerName var1) throws IOException;

    public abstract void startRegionServer(String var1) throws IOException;

    public abstract void killRegionServer(ServerName var1) throws IOException;

    public abstract void stopRegionServer(ServerName var1) throws IOException;

    public void waitForRegionServerToStart(String hostname, long timeout) throws IOException {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < timeout) {
            for (ServerName server : this.getClusterStatus().getServers()) {
                if (!server.getHostname().equals(hostname)) continue;
                return;
            }
            Threads.sleep((long)100L);
        }
        throw new IOException("did timeout waiting for region server to start:" + hostname);
    }

    public abstract void waitForRegionServerToStop(ServerName var1, long var2) throws IOException;

    public abstract void startMaster(String var1) throws IOException;

    public abstract void killMaster(ServerName var1) throws IOException;

    public abstract void stopMaster(ServerName var1) throws IOException;

    public abstract void waitForMasterToStop(ServerName var1, long var2) throws IOException;

    public boolean waitForActiveAndReadyMaster() throws IOException {
        return this.waitForActiveAndReadyMaster(Long.MAX_VALUE);
    }

    public abstract boolean waitForActiveAndReadyMaster(long var1) throws IOException;

    public abstract void waitUntilShutDown() throws IOException;

    public abstract void shutdown() throws IOException;

    public boolean restoreInitialStatus() throws IOException {
        return this.restoreClusterStatus(this.getInitialClusterStatus());
    }

    public boolean restoreClusterStatus(ClusterStatus desiredStatus) throws IOException {
        return true;
    }

    public ServerName getServerHoldingMeta() throws IOException {
        return this.getServerHoldingRegion(HRegionInfo.FIRST_META_REGIONINFO.getRegionName());
    }

    public abstract ServerName getServerHoldingRegion(byte[] var1) throws IOException;

    public boolean isDistributedCluster() {
        return false;
    }

    @Override
    public abstract void close() throws IOException;

    public void waitForNamenodeAvailable() throws InterruptedException {
    }

    public void waitForDatanodesRegistered(int nbDN) throws Exception {
    }
}

