/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.zookeeper.KeeperException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestLocalHBaseCluster {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @Test
    public void testLocalHBaseCluster() throws Exception {
        int val;
        TEST_UTIL.startMiniCluster(1, 1, null, MyHMaster.class, MyHRegionServer.class);
        try {
            val = ((MyHMaster)TEST_UTIL.getHBaseCluster().getMaster(0)).echo(42);
            Assert.assertEquals((long)42L, (long)val);
        }
        catch (ClassCastException e) {
            Assert.fail((String)"Could not cast master to our class");
        }
        try {
            val = ((MyHRegionServer)TEST_UTIL.getHBaseCluster().getRegionServer(0)).echo(42);
            Assert.assertEquals((long)42L, (long)val);
        }
        catch (ClassCastException e) {
            Assert.fail((String)"Could not cast regionserver to our class");
        }
        TEST_UTIL.shutdownMiniCluster();
    }

    public static class MyHRegionServer
    extends MiniHBaseCluster.MiniHBaseClusterRegionServer {
        public MyHRegionServer(Configuration conf) throws IOException, InterruptedException {
            super(conf);
        }

        public int echo(int val) {
            return val;
        }
    }

    public static class MyHMaster
    extends HMaster {
        public MyHMaster(Configuration conf) throws IOException, KeeperException, InterruptedException {
            super(conf);
        }

        public int echo(int val) {
            return val;
        }
    }
}

