/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.HTestConst;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TestScannersFromClientSide;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestIntraRowPagination {
    private static HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanLimitAndOffset() throws Exception {
        byte[][] ROWS = HTestConst.makeNAscii(HTestConst.DEFAULT_ROW_BYTES, 2);
        byte[][] FAMILIES = HTestConst.makeNAscii(HTestConst.DEFAULT_CF_BYTES, 3);
        byte[][] QUALIFIERS = HTestConst.makeNAscii(HTestConst.DEFAULT_QUALIFIER_BYTES, 10);
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((byte[])HTestConst.DEFAULT_TABLE_BYTES));
        HRegionInfo info = new HRegionInfo(HTestConst.DEFAULT_TABLE, null, null, false);
        for (byte[] family : FAMILIES) {
            HColumnDescriptor hcd = new HColumnDescriptor(family);
            htd.addFamily(hcd);
        }
        HRegion region = HRegion.createHRegion((HRegionInfo)info, (Path)TEST_UTIL.getDataTestDir(), (Configuration)TEST_UTIL.getConfiguration(), (HTableDescriptor)htd);
        try {
            boolean toLog = true;
            ArrayList<Cell> kvListExp = new ArrayList<Cell>();
            int storeOffset = 1;
            int storeLimit = 3;
            for (int r = 0; r < ROWS.length; ++r) {
                Put put = new Put(ROWS[r]);
                for (int c = 0; c < FAMILIES.length; ++c) {
                    for (int q = 0; q < QUALIFIERS.length; ++q) {
                        KeyValue kv = new KeyValue(ROWS[r], FAMILIES[c], QUALIFIERS[q], 1L, HTestConst.DEFAULT_VALUE_BYTES);
                        put.add((Cell)kv);
                        if (storeOffset > q || q >= storeOffset + storeLimit) continue;
                        kvListExp.add((Cell)kv);
                    }
                }
                region.put(put);
            }
            Scan scan = new Scan();
            scan.setRowOffsetPerColumnFamily(storeOffset);
            scan.setMaxResultsPerColumnFamily(storeLimit);
            RegionScanner scanner = region.getScanner(scan);
            ArrayList kvListScan = new ArrayList();
            ArrayList results = new ArrayList();
            while (scanner.next(results) || !results.isEmpty()) {
                kvListScan.addAll(results);
                results.clear();
            }
            Result result = Result.create(kvListScan);
            TestScannersFromClientSide.verifyResult(result, kvListExp, toLog, "Testing scan with storeOffset and storeLimit");
        }
        finally {
            region.close();
        }
    }
}

