/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestCoprocessorStop {
    private static final Log LOG = LogFactory.getLog(TestCoprocessorStop.class);
    private static HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final String MASTER_FILE = "master" + System.currentTimeMillis();
    private static final String REGIONSERVER_FILE = "regionserver" + System.currentTimeMillis();

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.set("hbase.coprocessor.master.classes", FooCoprocessor.class.getName());
        conf.set("hbase.coprocessor.regionserver.classes", FooCoprocessor.class.getName());
        UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testStopped() throws Exception {
        MiniHBaseCluster cluster = UTIL.getHBaseCluster();
        LOG.info((Object)"shutdown hbase cluster...");
        cluster.shutdown();
        LOG.info((Object)"wait for the hbase cluster shutdown...");
        cluster.waitUntilShutDown();
        Configuration conf = UTIL.getConfiguration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path resultFile = new Path(UTIL.getDataTestDirOnTestFS(), MASTER_FILE);
        Assert.assertTrue((String)"Master flag file should have been created", (boolean)fs.exists(resultFile));
        resultFile = new Path(UTIL.getDataTestDirOnTestFS(), REGIONSERVER_FILE);
        Assert.assertTrue((String)"RegionServer flag file should have been created", (boolean)fs.exists(resultFile));
    }

    public static class FooCoprocessor
    implements Coprocessor {
        public void start(CoprocessorEnvironment env) throws IOException {
            String where = null;
            if (env instanceof MasterCoprocessorEnvironment) {
                where = "master";
            } else if (env instanceof RegionServerCoprocessorEnvironment) {
                where = "regionserver";
            } else if (env instanceof RegionCoprocessorEnvironment) {
                LOG.error((Object)"on RegionCoprocessorEnvironment!!");
            }
            LOG.info((Object)("start coprocessor on " + where));
        }

        public void stop(CoprocessorEnvironment env) throws IOException {
            String fileName = null;
            if (env instanceof MasterCoprocessorEnvironment) {
                fileName = MASTER_FILE;
            } else if (env instanceof RegionServerCoprocessorEnvironment) {
                fileName = REGIONSERVER_FILE;
            } else if (env instanceof RegionCoprocessorEnvironment) {
                LOG.error((Object)"on RegionCoprocessorEnvironment!!");
            }
            Configuration conf = UTIL.getConfiguration();
            Path resultFile = new Path(UTIL.getDataTestDirOnTestFS(), fileName);
            FileSystem fs = FileSystem.get((Configuration)conf);
            boolean result = fs.createNewFile(resultFile);
            LOG.info((Object)("create file " + resultFile + " return rc " + result));
        }
    }
}

