/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.DependentColumnFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestDependentColumnFilter {
    private final Log LOG = LogFactory.getLog(this.getClass());
    private static final byte[][] ROWS = new byte[][]{Bytes.toBytes((String)"test1"), Bytes.toBytes((String)"test2")};
    private static final byte[][] FAMILIES = new byte[][]{Bytes.toBytes((String)"familyOne"), Bytes.toBytes((String)"familyTwo")};
    private static final long STAMP_BASE = System.currentTimeMillis();
    private static final long[] STAMPS = new long[]{STAMP_BASE - 100L, STAMP_BASE - 200L, STAMP_BASE - 300L};
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"qualifier");
    private static final byte[][] BAD_VALS = new byte[][]{Bytes.toBytes((String)"bad1"), Bytes.toBytes((String)"bad2"), Bytes.toBytes((String)"bad3")};
    private static final byte[] MATCH_VAL = Bytes.toBytes((String)"match");
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    List<KeyValue> testVals;
    private HRegion region;

    @Before
    public void setUp() throws Exception {
        this.testVals = this.makeTestVals();
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)this.getClass().getSimpleName()));
        HColumnDescriptor hcd0 = new HColumnDescriptor(FAMILIES[0]);
        hcd0.setMaxVersions(3);
        htd.addFamily(hcd0);
        HColumnDescriptor hcd1 = new HColumnDescriptor(FAMILIES[1]);
        hcd1.setMaxVersions(3);
        htd.addFamily(hcd1);
        HRegionInfo info = new HRegionInfo(htd.getTableName(), null, null, false);
        this.region = HRegion.createHRegion((HRegionInfo)info, (Path)TEST_UTIL.getDataTestDir(), (Configuration)TEST_UTIL.getConfiguration(), (HTableDescriptor)htd);
        this.addData();
    }

    @After
    public void tearDown() throws Exception {
        HRegion.closeHRegion((HRegion)this.region);
    }

    private void addData() throws IOException {
        Put put = new Put(ROWS[0]);
        put.add(FAMILIES[0], QUALIFIER, STAMPS[0], BAD_VALS[0]);
        put.add(FAMILIES[0], QUALIFIER, STAMPS[1], BAD_VALS[1]);
        put.add(FAMILIES[0], QUALIFIER, STAMPS[2], MATCH_VAL);
        put.add(FAMILIES[1], QUALIFIER, STAMPS[0], BAD_VALS[0]);
        put.add(FAMILIES[1], QUALIFIER, STAMPS[2], BAD_VALS[2]);
        this.region.put(put);
        put = new Put(ROWS[1]);
        put.add(FAMILIES[0], QUALIFIER, STAMPS[0], BAD_VALS[0]);
        put.add(FAMILIES[0], QUALIFIER, STAMPS[2], MATCH_VAL);
        put.add(FAMILIES[1], QUALIFIER, STAMPS[0], MATCH_VAL);
        put.add(FAMILIES[1], QUALIFIER, STAMPS[1], BAD_VALS[2]);
        this.region.put(put);
    }

    private List<KeyValue> makeTestVals() {
        ArrayList<KeyValue> testVals = new ArrayList<KeyValue>();
        testVals.add(new KeyValue(ROWS[0], FAMILIES[0], QUALIFIER, STAMPS[0], BAD_VALS[0]));
        testVals.add(new KeyValue(ROWS[0], FAMILIES[0], QUALIFIER, STAMPS[1], BAD_VALS[1]));
        testVals.add(new KeyValue(ROWS[0], FAMILIES[1], QUALIFIER, STAMPS[1], BAD_VALS[2]));
        testVals.add(new KeyValue(ROWS[0], FAMILIES[1], QUALIFIER, STAMPS[0], MATCH_VAL));
        testVals.add(new KeyValue(ROWS[0], FAMILIES[1], QUALIFIER, STAMPS[2], BAD_VALS[2]));
        return testVals;
    }

    private void verifyScan(Scan s, long expectedRows, long expectedCells) throws IOException {
        RegionScanner scanner = this.region.getScanner(s);
        ArrayList results = new ArrayList();
        int i = 0;
        int cells = 0;
        boolean done = true;
        while (done) {
            done = scanner.next(results);
            Arrays.sort(results.toArray(new KeyValue[results.size()]), KeyValue.COMPARATOR);
            this.LOG.info((Object)("counter=" + i + ", " + results));
            if (results.isEmpty()) break;
            Assert.assertTrue((String)("Scanned too many rows! Only expected " + expectedRows + " total but already scanned " + (i + 1)), (expectedRows > (long)i ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expected " + expectedCells + " cells total but " + "already scanned " + (cells += results.size())), (expectedCells >= (long)cells ? 1 : 0) != 0);
            results.clear();
            ++i;
        }
        Assert.assertEquals((String)("Expected " + expectedRows + " rows but scanned " + i + " rows"), (long)expectedRows, (long)i);
        Assert.assertEquals((String)("Expected " + expectedCells + " cells but scanned " + cells + " cells"), (long)expectedCells, (long)cells);
    }

    @Test
    public void testScans() throws Exception {
        DependentColumnFilter filter = new DependentColumnFilter(FAMILIES[0], QUALIFIER);
        Scan scan = new Scan();
        scan.setFilter((Filter)filter);
        scan.setMaxVersions(Integer.MAX_VALUE);
        this.verifyScan(scan, 2L, 8L);
        filter = new DependentColumnFilter(FAMILIES[0], QUALIFIER, true);
        scan = new Scan();
        scan.setFilter((Filter)filter);
        scan.setMaxVersions(Integer.MAX_VALUE);
        this.verifyScan(scan, 2L, 3L);
        filter = new DependentColumnFilter(FAMILIES[0], QUALIFIER, false, CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(MATCH_VAL));
        scan = new Scan();
        scan.setFilter((Filter)filter);
        scan.setMaxVersions(Integer.MAX_VALUE);
        this.verifyScan(scan, 2L, 3L);
        filter = new DependentColumnFilter(FAMILIES[0], QUALIFIER, true, CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(MATCH_VAL));
        scan = new Scan();
        scan.setFilter((Filter)filter);
        scan.setMaxVersions(Integer.MAX_VALUE);
        this.verifyScan(scan, 1L, 1L);
    }

    @Test
    public void testFilterDropping() throws Exception {
        DependentColumnFilter filter = new DependentColumnFilter(FAMILIES[0], QUALIFIER);
        ArrayList<Object> accepted = new ArrayList<Object>();
        for (Cell cell : this.testVals) {
            if (filter.filterKeyValue(cell) != Filter.ReturnCode.INCLUDE) continue;
            accepted.add(cell);
        }
        Assert.assertEquals((String)"check all values accepted from filterKeyValue", (long)5L, (long)accepted.size());
        filter.filterRowCells(accepted);
        Assert.assertEquals((String)"check filterRow(List<KeyValue>) dropped cell without corresponding column entry", (long)4L, (long)accepted.size());
        filter = new DependentColumnFilter(FAMILIES[1], QUALIFIER, true);
        accepted.clear();
        for (KeyValue keyValue : this.testVals) {
            if (filter.filterKeyValue((Cell)keyValue) != Filter.ReturnCode.INCLUDE) continue;
            accepted.add(keyValue);
        }
        Assert.assertEquals((String)"check the filtering column cells got dropped", (long)2L, (long)accepted.size());
        filter.filterRowCells(accepted);
        Assert.assertEquals((String)"check cell retention", (long)2L, (long)accepted.size());
    }

    @Test
    public void testToStringWithNullComparator() {
        DependentColumnFilter filter = new DependentColumnFilter(FAMILIES[0], QUALIFIER);
        Assert.assertNotNull((Object)filter.toString());
        Assert.assertTrue((String)"check string contains 'null' as compatator is null", (boolean)filter.toString().contains("null"));
        filter = new DependentColumnFilter(FAMILIES[0], QUALIFIER, true, CompareFilter.CompareOp.EQUAL, null);
        Assert.assertNotNull((Object)filter.toString());
        Assert.assertTrue((String)"check string contains 'null' as compatator is null", (boolean)filter.toString().contains("null"));
    }

    @Test
    public void testToStringWithNonNullComparator() {
        DependentColumnFilter filter = new DependentColumnFilter(FAMILIES[0], QUALIFIER, true, CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(MATCH_VAL));
        Assert.assertNotNull((Object)filter.toString());
        Assert.assertTrue((String)"check string contains comparator value", (boolean)filter.toString().contains("match"));
    }
}

