/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.balancer.BalancerTestBase;
import org.apache.hadoop.hbase.master.balancer.BaseLoadBalancer;
import org.apache.hadoop.hbase.master.balancer.RegionLocationFinder;
import org.apache.hadoop.hbase.master.balancer.ServerAndLoad;
import org.apache.hadoop.hbase.master.balancer.TestStochasticLoadBalancer;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
public class TestBaseLoadBalancer
extends BalancerTestBase {
    private static LoadBalancer loadBalancer;
    private static final Log LOG;
    int[][] regionsAndServersMocks = new int[][]{{0, 0}, {0, 1}, {1, 1}, {2, 1}, {10, 1}, {1, 2}, {2, 2}, {3, 2}, {1, 3}, {2, 3}, {3, 3}, {25, 3}, {2, 10}, {2, 100}, {12, 10}, {12, 100}};

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        loadBalancer = new MockBalancer();
        loadBalancer.setConf(conf);
    }

    @Test
    public void testImmediateAssignment() throws Exception {
        for (int[] mock : this.regionsAndServersMocks) {
            LOG.debug((Object)("testImmediateAssignment with " + mock[0] + " regions and " + mock[1] + " servers"));
            List<HRegionInfo> regions = this.randomRegions(mock[0]);
            List<ServerAndLoad> servers = this.randomServers(mock[1], 0);
            List<ServerName> list = this.getListOfServerNames(servers);
            Map assignments = loadBalancer.immediateAssignment(regions, list);
            this.assertImmediateAssignment(regions, list, assignments);
            this.returnRegions(regions);
            this.returnServers(list);
        }
    }

    private void assertImmediateAssignment(List<HRegionInfo> regions, List<ServerName> servers, Map<HRegionInfo, ServerName> assignments) {
        for (HRegionInfo region : regions) {
            Assert.assertTrue((boolean)assignments.containsKey(region));
        }
    }

    @Test
    public void testBulkAssignment() throws Exception {
        for (int[] mock : this.regionsAndServersMocks) {
            LOG.debug((Object)("testBulkAssignment with " + mock[0] + " regions and " + mock[1] + " servers"));
            List<HRegionInfo> regions = this.randomRegions(mock[0]);
            List<ServerAndLoad> servers = this.randomServers(mock[1], 0);
            List<ServerName> list = this.getListOfServerNames(servers);
            Map assignments = loadBalancer.roundRobinAssignment(regions, list);
            float average = (float)regions.size() / (float)servers.size();
            int min = (int)Math.floor(average);
            int max = (int)Math.ceil(average);
            if (assignments != null && !assignments.isEmpty()) {
                for (List regionList : assignments.values()) {
                    Assert.assertTrue((regionList.size() == min || regionList.size() == max ? 1 : 0) != 0);
                }
            }
            this.returnRegions(regions);
            this.returnServers(list);
        }
    }

    @Test
    public void testRetainAssignment() throws Exception {
        List<ServerAndLoad> servers = this.randomServers(10, 10);
        List<HRegionInfo> regions = this.randomRegions(100);
        TreeMap<HRegionInfo, ServerName> existing = new TreeMap<HRegionInfo, ServerName>();
        for (int i = 0; i < regions.size(); ++i) {
            ServerName sn = servers.get(i % servers.size()).getServerName();
            ServerName snWithOldStartCode = ServerName.valueOf((String)sn.getHostname(), (int)sn.getPort(), (long)(sn.getStartcode() - 10L));
            existing.put(regions.get(i), snWithOldStartCode);
        }
        List<ServerName> listOfServerNames = this.getListOfServerNames(servers);
        Map assignment = loadBalancer.retainAssignment(existing, listOfServerNames);
        this.assertRetainedAssignment(existing, listOfServerNames, assignment);
        ArrayList<ServerAndLoad> servers2 = new ArrayList<ServerAndLoad>(servers);
        servers2.add(this.randomServer(10));
        servers2.add(this.randomServer(10));
        listOfServerNames = this.getListOfServerNames(servers2);
        assignment = loadBalancer.retainAssignment(existing, listOfServerNames);
        this.assertRetainedAssignment(existing, listOfServerNames, assignment);
        ArrayList<ServerAndLoad> servers3 = new ArrayList<ServerAndLoad>(servers);
        servers3.remove(0);
        servers3.remove(0);
        listOfServerNames = this.getListOfServerNames(servers3);
        assignment = loadBalancer.retainAssignment(existing, listOfServerNames);
        this.assertRetainedAssignment(existing, listOfServerNames, assignment);
    }

    private List<ServerName> getListOfServerNames(List<ServerAndLoad> sals) {
        ArrayList<ServerName> list = new ArrayList<ServerName>();
        for (ServerAndLoad e : sals) {
            list.add(e.getServerName());
        }
        return list;
    }

    private void assertRetainedAssignment(Map<HRegionInfo, ServerName> existing, List<ServerName> servers, Map<ServerName, List<HRegionInfo>> assignment) {
        TreeSet<ServerName> onlineServerSet = new TreeSet<ServerName>(servers);
        TreeSet<HRegionInfo> assignedRegions = new TreeSet<HRegionInfo>();
        for (Map.Entry<ServerName, List<HRegionInfo>> a : assignment.entrySet()) {
            Assert.assertTrue((String)"Region assigned to server that was not listed as online", (boolean)onlineServerSet.contains(a.getKey()));
            for (HRegionInfo r : a.getValue()) {
                assignedRegions.add(r);
            }
        }
        Assert.assertEquals((long)existing.size(), (long)assignedRegions.size());
        TreeSet<String> onlineHostNames = new TreeSet<String>();
        for (ServerName serverName : servers) {
            onlineHostNames.add(serverName.getHostname());
        }
        for (Map.Entry entry : assignment.entrySet()) {
            ServerName assignedTo = (ServerName)entry.getKey();
            for (HRegionInfo r : (List)entry.getValue()) {
                ServerName address = existing.get(r);
                if (address == null || !onlineHostNames.contains(address.getHostname())) continue;
                Assert.assertEquals((Object)address.getHostname(), (Object)assignedTo.getHostname());
            }
        }
    }

    @Test
    public void testClusterServersWithSameHostPort() {
        List<ServerName> servers = this.getListOfServerNames(this.randomServers(10, 10));
        List<HRegionInfo> regions = this.randomRegions(101);
        HashMap<ServerName, List<HRegionInfo>> clusterState = new HashMap<ServerName, List<HRegionInfo>>();
        this.assignRegions(regions, servers, clusterState);
        ArrayList<ServerName> oldServers = new ArrayList<ServerName>(servers.size());
        for (ServerName sn : servers) {
            oldServers.add(ServerName.valueOf((String)sn.getHostname(), (int)sn.getPort(), (long)(sn.getStartcode() - 10L)));
        }
        regions = this.randomRegions(9);
        this.assignRegions(regions, oldServers, clusterState);
        BaseLoadBalancer.Cluster cluster = new BaseLoadBalancer.Cluster(clusterState, null, null);
        Assert.assertEquals((long)110L, (long)cluster.numRegions);
        Assert.assertEquals((long)10L, (long)cluster.numServers);
    }

    private void assignRegions(List<HRegionInfo> regions, List<ServerName> servers, Map<ServerName, List<HRegionInfo>> clusterState) {
        for (int i = 0; i < regions.size(); ++i) {
            ServerName sn = servers.get(i % servers.size());
            List<HRegionInfo> regionsOfServer = clusterState.get(sn);
            if (regionsOfServer == null) {
                regionsOfServer = new ArrayList<HRegionInfo>(10);
                clusterState.put(sn, regionsOfServer);
            }
            regionsOfServer.add(regions.get(i));
        }
    }

    @Test
    public void testClusterRegionLocations() {
        List<ServerName> servers = this.getListOfServerNames(this.randomServers(10, 10));
        List<HRegionInfo> regions = this.randomRegions(101);
        HashMap<ServerName, List<HRegionInfo>> clusterState = new HashMap<ServerName, List<HRegionInfo>>();
        this.assignRegions(regions, servers, clusterState);
        RegionLocationFinder locationFinder = (RegionLocationFinder)Mockito.mock(RegionLocationFinder.class);
        Mockito.when((Object)locationFinder.getTopBlockLocations(regions.get(0))).thenReturn((Object)Lists.newArrayList((Object[])new ServerName[]{servers.get(0)}));
        Mockito.when((Object)locationFinder.getTopBlockLocations(regions.get(1))).thenReturn((Object)Lists.newArrayList((Object[])new ServerName[]{servers.get(0), servers.get(1)}));
        Mockito.when((Object)locationFinder.getTopBlockLocations(regions.get(42))).thenReturn((Object)Lists.newArrayList((Object[])new ServerName[]{servers.get(4), servers.get(9), servers.get(5)}));
        Mockito.when((Object)locationFinder.getTopBlockLocations(regions.get(43))).thenReturn((Object)Lists.newArrayList((Object[])new ServerName[]{ServerName.valueOf((String)"foo", (int)0, (long)0L)}));
        BaseLoadBalancer.Cluster cluster = new BaseLoadBalancer.Cluster(clusterState, null, locationFinder);
        int r0 = ArrayUtils.indexOf((Object[])cluster.regions, (Object)regions.get(0));
        int r1 = ArrayUtils.indexOf((Object[])cluster.regions, (Object)regions.get(1));
        int r10 = ArrayUtils.indexOf((Object[])cluster.regions, (Object)regions.get(10));
        int r42 = ArrayUtils.indexOf((Object[])cluster.regions, (Object)regions.get(42));
        int r43 = ArrayUtils.indexOf((Object[])cluster.regions, (Object)regions.get(43));
        int s0 = (Integer)cluster.serversToIndex.get(servers.get(0).getHostAndPort());
        int s1 = (Integer)cluster.serversToIndex.get(servers.get(1).getHostAndPort());
        int s4 = (Integer)cluster.serversToIndex.get(servers.get(4).getHostAndPort());
        int s5 = (Integer)cluster.serversToIndex.get(servers.get(5).getHostAndPort());
        int s9 = (Integer)cluster.serversToIndex.get(servers.get(9).getHostAndPort());
        Assert.assertEquals((long)1L, (long)cluster.regionLocations[r0].length);
        Assert.assertEquals((long)s0, (long)cluster.regionLocations[r0][0]);
        Assert.assertEquals((long)2L, (long)cluster.regionLocations[r1].length);
        Assert.assertEquals((long)s0, (long)cluster.regionLocations[r1][0]);
        Assert.assertEquals((long)s1, (long)cluster.regionLocations[r1][1]);
        Assert.assertEquals((long)0L, (long)cluster.regionLocations[r10].length);
        Assert.assertEquals((long)3L, (long)cluster.regionLocations[r42].length);
        Assert.assertEquals((long)s4, (long)cluster.regionLocations[r42][0]);
        Assert.assertEquals((long)s9, (long)cluster.regionLocations[r42][1]);
        Assert.assertEquals((long)s5, (long)cluster.regionLocations[r42][2]);
        Assert.assertEquals((long)1L, (long)cluster.regionLocations[r43].length);
        Assert.assertEquals((long)-1L, (long)cluster.regionLocations[r43][0]);
    }

    static {
        LOG = LogFactory.getLog(TestStochasticLoadBalancer.class);
    }

    public static class MockBalancer
    extends BaseLoadBalancer {
        public List<RegionPlan> balanceCluster(Map<ServerName, List<HRegionInfo>> clusterState) {
            return null;
        }
    }
}

