/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.io.util.LRUDictionary;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.WALCellCodec;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestWALCellCodecWithCompression {
    @Test
    public void testEncodeDecodeKVsWithTags() throws Exception {
        this.doTest(false);
    }

    @Test
    public void testEncodeDecodeKVsWithTagsWithTagsCompression() throws Exception {
        this.doTest(true);
    }

    private void doTest(boolean compressTags) throws Exception {
        Configuration conf = new Configuration(false);
        conf.setBoolean("hbase.regionserver.wal.tags.enablecompression", compressTags);
        WALCellCodec codec = new WALCellCodec(conf, new CompressionContext(LRUDictionary.class, false, compressTags));
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        Codec.Encoder encoder = codec.getEncoder((OutputStream)bos);
        encoder.write((Cell)this.createKV(1));
        encoder.write((Cell)this.createKV(0));
        encoder.write((Cell)this.createKV(2));
        ByteArrayInputStream is = new ByteArrayInputStream(bos.toByteArray());
        Codec.Decoder decoder = codec.getDecoder((InputStream)is);
        decoder.advance();
        KeyValue kv = (KeyValue)decoder.current();
        List tags = kv.getTags();
        Assert.assertEquals((long)1L, (long)tags.size());
        Assert.assertEquals((Object)"tagValue1", (Object)Bytes.toString((byte[])((Tag)tags.get(0)).getValue()));
        decoder.advance();
        kv = (KeyValue)decoder.current();
        tags = kv.getTags();
        Assert.assertEquals((long)0L, (long)tags.size());
        decoder.advance();
        kv = (KeyValue)decoder.current();
        tags = kv.getTags();
        Assert.assertEquals((long)2L, (long)tags.size());
        Assert.assertEquals((Object)"tagValue1", (Object)Bytes.toString((byte[])((Tag)tags.get(0)).getValue()));
        Assert.assertEquals((Object)"tagValue2", (Object)Bytes.toString((byte[])((Tag)tags.get(1)).getValue()));
    }

    private KeyValue createKV(int noOfTags) {
        byte[] row = Bytes.toBytes((String)"myRow");
        byte[] cf = Bytes.toBytes((String)"myCF");
        byte[] q = Bytes.toBytes((String)"myQualifier");
        byte[] value = Bytes.toBytes((String)"myValue");
        ArrayList<Tag> tags = new ArrayList<Tag>(noOfTags);
        for (int i = 1; i <= noOfTags; ++i) {
            tags.add(new Tag((byte)i, Bytes.toBytes((String)("tagValue" + i))));
        }
        return new KeyValue(row, cf, q, Long.MAX_VALUE, value, tags);
    }
}

