/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.client;

import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.rest.client.Client;
import org.apache.hadoop.hbase.rest.client.RemoteAdmin;
import org.apache.hadoop.hbase.rest.client.Response;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={SmallTests.class})
public class TestRemoteAdminRetries {
    private static final int SLEEP_TIME = 50;
    private static final int RETRIES = 3;
    private static final long MAX_TIME = 100L;
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private RemoteAdmin remoteAdmin;
    private Client client;

    @Before
    public void setup() throws Exception {
        this.client = (Client)Mockito.mock(Client.class);
        Response response = new Response(509);
        Mockito.when((Object)this.client.get(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)response);
        Mockito.when((Object)this.client.delete(Matchers.anyString())).thenReturn((Object)response);
        Mockito.when((Object)this.client.put(Matchers.anyString(), Matchers.anyString(), (byte[])Matchers.any(byte[].class))).thenReturn((Object)response);
        Mockito.when((Object)this.client.post(Matchers.anyString(), Matchers.anyString(), (byte[])Matchers.any(byte[].class))).thenReturn((Object)response);
        Configuration configuration = TEST_UTIL.getConfiguration();
        configuration.setInt("hbase.rest.client.max.retries", 3);
        configuration.setInt("hbase.rest.client.sleep", 50);
        this.remoteAdmin = new RemoteAdmin(this.client, TEST_UTIL.getConfiguration(), "MyTable");
    }

    @Test
    public void testFailingGetRestVersion() throws Exception {
        this.testTimedOutGetCall(new CallExecutor(){

            @Override
            public void run() throws Exception {
                TestRemoteAdminRetries.this.remoteAdmin.getRestVersion();
            }
        });
    }

    @Test
    public void testFailingGetClusterStatus() throws Exception {
        this.testTimedOutGetCall(new CallExecutor(){

            @Override
            public void run() throws Exception {
                TestRemoteAdminRetries.this.remoteAdmin.getClusterStatus();
            }
        });
    }

    @Test
    public void testFailingGetClusterVersion() throws Exception {
        this.testTimedOutGetCall(new CallExecutor(){

            @Override
            public void run() throws Exception {
                TestRemoteAdminRetries.this.remoteAdmin.getClusterVersion();
            }
        });
    }

    @Test
    public void testFailingGetTableAvailable() throws Exception {
        this.testTimedOutCall(new CallExecutor(){

            @Override
            public void run() throws Exception {
                TestRemoteAdminRetries.this.remoteAdmin.isTableAvailable(Bytes.toBytes((String)"TestTable"));
            }
        });
    }

    @Test
    public void testFailingCreateTable() throws Exception {
        this.testTimedOutCall(new CallExecutor(){

            @Override
            public void run() throws Exception {
                TestRemoteAdminRetries.this.remoteAdmin.createTable(new HTableDescriptor(Bytes.toBytes((String)"TestTable")));
            }
        });
        ((Client)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)3))).put(Matchers.anyString(), Matchers.anyString(), (byte[])Matchers.any(byte[].class));
    }

    @Test
    public void testFailingDeleteTable() throws Exception {
        this.testTimedOutCall(new CallExecutor(){

            @Override
            public void run() throws Exception {
                TestRemoteAdminRetries.this.remoteAdmin.deleteTable("TestTable");
            }
        });
        ((Client)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)3))).delete(Matchers.anyString());
    }

    @Test
    public void testFailingGetTableList() throws Exception {
        this.testTimedOutGetCall(new CallExecutor(){

            @Override
            public void run() throws Exception {
                TestRemoteAdminRetries.this.remoteAdmin.getTableList();
            }
        });
    }

    private void testTimedOutGetCall(CallExecutor callExecutor) throws Exception {
        this.testTimedOutCall(callExecutor);
        ((Client)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)3))).get(Matchers.anyString(), Matchers.anyString());
    }

    private void testTimedOutCall(CallExecutor callExecutor) throws Exception {
        long start = System.currentTimeMillis();
        try {
            callExecutor.run();
            Assert.fail((String)"should be timeout exception!");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)Pattern.matches(".*MyTable.*timed out", e.toString()));
        }
        Assert.assertTrue((System.currentTimeMillis() - start > 100L ? 1 : 0) != 0);
    }

    private static interface CallExecutor {
        public void run() throws Exception;
    }
}

