/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.util.List;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionServerCoprocessorHost;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlFilter;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.access.TableAuthManager;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.TestTableName;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestScanEarlyTermination
extends SecureTestUtil {
    private static final Log LOG = LogFactory.getLog(TestScanEarlyTermination.class);
    @Rule
    public TestTableName TEST_TABLE = new TestTableName();
    private static final HBaseTestingUtility TEST_UTIL;
    private static final byte[] TEST_FAMILY1;
    private static final byte[] TEST_FAMILY2;
    private static final byte[] TEST_ROW;
    private static final byte[] TEST_Q1;
    private static final byte[] TEST_Q2;
    private static final byte[] ZERO;
    private static Configuration conf;
    private static User USER_OWNER;
    private static User USER_OTHER;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        TestScanEarlyTermination.enableSecurity(conf);
        TestScanEarlyTermination.verifyConfiguration(conf);
        TEST_UTIL.startMiniCluster();
        MasterCoprocessorHost cpHost = TEST_UTIL.getMiniHBaseCluster().getMaster().getCoprocessorHost();
        cpHost.load(AccessController.class, 0, conf);
        AccessController ac = (AccessController)cpHost.findCoprocessor(AccessController.class.getName());
        cpHost.createEnvironment(AccessController.class, (Coprocessor)ac, 0, 1, conf);
        RegionServerCoprocessorHost rsHost = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0).getCoprocessorHost();
        rsHost.createEnvironment(AccessController.class, (Coprocessor)ac, 0, 1, conf);
        TEST_UTIL.waitTableEnabled(AccessControlLists.ACL_TABLE_NAME.getName());
        USER_OWNER = User.createUserForTesting((Configuration)conf, (String)"owner", (String[])new String[0]);
        USER_OTHER = User.createUserForTesting((Configuration)conf, (String)"other", (String[])new String[0]);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        HTableDescriptor htd = new HTableDescriptor(this.TEST_TABLE.getTableName());
        htd.setOwner(USER_OWNER);
        HColumnDescriptor hcd = new HColumnDescriptor(TEST_FAMILY1);
        hcd.setMaxVersions(10);
        htd.addFamily(hcd);
        hcd = new HColumnDescriptor(TEST_FAMILY2);
        hcd.setMaxVersions(10);
        htd.addFamily(hcd);
        htd.setConfiguration("hbase.security.access.early_out", "true");
        admin.createTable(htd);
        TEST_UTIL.waitTableEnabled(this.TEST_TABLE.getTableName().getName());
    }

    @After
    public void tearDown() throws Exception {
        try {
            TEST_UTIL.deleteTable(this.TEST_TABLE.getTableName());
        }
        catch (TableNotFoundException ex) {
            LOG.info((Object)("Test deleted table " + this.TEST_TABLE.getTableName()));
        }
        Assert.assertEquals((long)0L, (long)AccessControlLists.getTablePermissions((Configuration)conf, (TableName)this.TEST_TABLE.getTableName()).size());
    }

    @Test
    public void testEarlyScanTermination() throws Exception {
        TestScanEarlyTermination.grantOnTable(TEST_UTIL, USER_OTHER.getShortName(), this.TEST_TABLE.getTableName(), TEST_FAMILY1, null, Permission.Action.READ);
        TestScanEarlyTermination.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                conf.set("testkey", UUID.randomUUID().toString());
                HTable t = new HTable(conf, TestScanEarlyTermination.this.TEST_TABLE.getTableName());
                try {
                    Put put = new Put(TEST_ROW).add(TEST_FAMILY1, TEST_Q1, ZERO);
                    t.put(put);
                    put = new Put(TEST_ROW).add(TEST_FAMILY2, TEST_Q1, ZERO);
                    put.setACL(USER_OTHER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ}));
                    t.put(put);
                    put = new Put(TEST_ROW).add(TEST_FAMILY2, TEST_Q2, ZERO);
                    put.setACL(USER_OTHER.getShortName(), new Permission());
                    t.put(put);
                }
                finally {
                    t.close();
                }
                return null;
            }
        }, USER_OWNER);
        TestScanEarlyTermination.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                conf.set("testkey", UUID.randomUUID().toString());
                HTable t = new HTable(conf, TestScanEarlyTermination.this.TEST_TABLE.getTableName());
                try {
                    Scan scan = new Scan().addFamily(TEST_FAMILY1);
                    Result result = t.getScanner(scan).next();
                    if (result != null) {
                        Assert.assertTrue((String)"Improper exclusion", (boolean)result.containsColumn(TEST_FAMILY1, TEST_Q1));
                        Assert.assertFalse((String)"Improper inclusion", (boolean)result.containsColumn(TEST_FAMILY2, TEST_Q1));
                        List list = result.listCells();
                        return list;
                    }
                    Object var4_5 = null;
                    return var4_5;
                }
                finally {
                    t.close();
                }
            }
        }, USER_OTHER);
        TestScanEarlyTermination.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                conf.set("testkey", UUID.randomUUID().toString());
                HTable t = new HTable(conf, TestScanEarlyTermination.this.TEST_TABLE.getTableName());
                try {
                    Scan scan = new Scan();
                    Result result = t.getScanner(scan).next();
                    if (result != null) {
                        Assert.assertTrue((String)"Improper exclusion", (boolean)result.containsColumn(TEST_FAMILY1, TEST_Q1));
                        Assert.assertFalse((String)"Improper inclusion", (boolean)result.containsColumn(TEST_FAMILY2, TEST_Q1));
                        List list = result.listCells();
                        return list;
                    }
                    Object var4_5 = null;
                    return var4_5;
                }
                finally {
                    t.close();
                }
            }
        }, USER_OTHER);
        TestScanEarlyTermination.verifyDeniedWithException(new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                conf.set("testkey", UUID.randomUUID().toString());
                HTable t = new HTable(conf, TestScanEarlyTermination.this.TEST_TABLE.getTableName());
                try {
                    Scan scan = new Scan().addFamily(TEST_FAMILY2);
                    Result result = t.getScanner(scan).next();
                    if (result != null) {
                        List list = result.listCells();
                        return list;
                    }
                    Object var4_5 = null;
                    return var4_5;
                }
                finally {
                    t.close();
                }
            }
        }, USER_OTHER);
        TestScanEarlyTermination.grantOnTable(TEST_UTIL, USER_OTHER.getShortName(), this.TEST_TABLE.getTableName(), TEST_FAMILY2, TEST_Q2, Permission.Action.READ);
        TestScanEarlyTermination.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                conf.set("testkey", UUID.randomUUID().toString());
                HTable t = new HTable(conf, TestScanEarlyTermination.this.TEST_TABLE.getTableName());
                try {
                    Scan scan = new Scan();
                    Result result = t.getScanner(scan).next();
                    if (result != null) {
                        Assert.assertTrue((String)"Improper exclusion", (boolean)result.containsColumn(TEST_FAMILY1, TEST_Q1));
                        Assert.assertFalse((String)"Improper inclusion", (boolean)result.containsColumn(TEST_FAMILY2, TEST_Q1));
                        Assert.assertTrue((String)"Improper exclusion", (boolean)result.containsColumn(TEST_FAMILY2, TEST_Q2));
                        List list = result.listCells();
                        return list;
                    }
                    Object var4_5 = null;
                    return var4_5;
                }
                finally {
                    t.close();
                }
            }
        }, USER_OTHER);
    }

    static {
        Logger.getLogger(AccessController.class).setLevel(Level.TRACE);
        Logger.getLogger(AccessControlFilter.class).setLevel(Level.TRACE);
        Logger.getLogger(TableAuthManager.class).setLevel(Level.TRACE);
        TEST_UTIL = new HBaseTestingUtility();
        TEST_FAMILY1 = Bytes.toBytes((String)"f1");
        TEST_FAMILY2 = Bytes.toBytes((String)"f2");
        TEST_ROW = Bytes.toBytes((String)"testrow");
        TEST_Q1 = Bytes.toBytes((String)"q1");
        TEST_Q2 = Bytes.toBytes((String)"q2");
        ZERO = Bytes.toBytes((long)0L);
    }
}

