/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.visibility.ExpAsStringVisibilityLabelServiceImpl;
import org.apache.hadoop.hbase.security.visibility.ScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.SimpleScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.TestVisibilityLabels;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.security.visibility.VisibilityLabelService;
import org.apache.hadoop.hbase.security.visibility.VisibilityTestUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestVisibilityLabelsWithCustomVisLabService
extends TestVisibilityLabels {
    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.master.distributed.log.replay", false);
        VisibilityTestUtil.enableVisiblityLabels(conf);
        conf.setClass("hbase.regionserver.scan.visibility.label.generator.class", SimpleScanLabelGenerator.class, ScanLabelGenerator.class);
        conf.setClass("hbase.regionserver.visibility.label.service.class", ExpAsStringVisibilityLabelServiceImpl.class, VisibilityLabelService.class);
        conf.set("hbase.superuser", "admin");
        TEST_UTIL.startMiniCluster(2);
        SUPERUSER = User.createUserForTesting((Configuration)conf, (String)"admin", (String[])new String[]{"supergroup"});
        TEST_UTIL.waitTableEnabled(VisibilityConstants.LABELS_TABLE_NAME.getName(), 50000L);
        TestVisibilityLabelsWithCustomVisLabService.addLabels();
    }

    @Override
    @Test
    public void testVisibilityLabelsInPutsThatDoesNotMatchAnyDefinedLabels() throws Exception {
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        TestVisibilityLabelsWithCustomVisLabService.createTableAndWriteDataWithLabels(tableName, "SAMPLE_LABEL", "TEST");
    }

    @Override
    protected List<String> extractAuths(String user, List<Result> results) {
        ArrayList<String> auths = new ArrayList<String>();
        for (Result result : results) {
            if (!Bytes.equals((byte[])result.getRow(), (byte[])Bytes.toBytes((String)user))) continue;
            NavigableMap familyMap = result.getFamilyMap(VisibilityConstants.LABELS_TABLE_FAMILY);
            for (byte[] q : familyMap.keySet()) {
                auths.add(Bytes.toString((byte[])q, (int)0, (int)q.length));
            }
        }
        return auths;
    }
}

