/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultEncodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockEncodingContext;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;

@InterfaceAudience.Private
public class NoOpDataBlockEncoder
implements HFileDataBlockEncoder {
    public static final NoOpDataBlockEncoder INSTANCE = new NoOpDataBlockEncoder();

    private NoOpDataBlockEncoder() {
    }

    @Override
    public void beforeWriteToDisk(ByteBuffer in, HFileBlockEncodingContext encodeCtx, BlockType blockType) throws IOException {
        if (!encodeCtx.getClass().getName().equals(HFileBlockDefaultEncodingContext.class.getName())) {
            throw new IOException(this.getClass().getName() + " only accepts " + HFileBlockDefaultEncodingContext.class.getName() + ".");
        }
        HFileBlockDefaultEncodingContext defaultContext = (HFileBlockDefaultEncodingContext)encodeCtx;
        defaultContext.compressAfterEncodingWithBlockType(in.array(), blockType);
    }

    @Override
    public boolean useEncodedScanner() {
        return false;
    }

    @Override
    public void saveMetadata(HFile.Writer writer) {
    }

    @Override
    public DataBlockEncoding getDataBlockEncoding() {
        return DataBlockEncoding.NONE;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public HFileBlockEncodingContext newDataBlockEncodingContext(byte[] dummyHeader, HFileContext meta) {
        return new HFileBlockDefaultEncodingContext(null, dummyHeader, meta);
    }

    @Override
    public HFileBlockDecodingContext newDataBlockDecodingContext(HFileContext meta) {
        return new HFileBlockDefaultDecodingContext(meta);
    }
}

