/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NotAllMetaRegionsOnlineException;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.ipc.RequestContext;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.ModifyRegionUtils;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class CreateTableHandler
extends EventHandler {
    private static final Log LOG = LogFactory.getLog(CreateTableHandler.class);
    protected final MasterFileSystem fileSystemManager;
    protected final HTableDescriptor hTableDescriptor;
    protected final Configuration conf;
    private final AssignmentManager assignmentManager;
    private final CatalogTracker catalogTracker;
    private final TableLockManager tableLockManager;
    private final HRegionInfo[] newRegions;
    private final TableLockManager.TableLock tableLock;
    private User activeUser;

    public CreateTableHandler(Server server, MasterFileSystem fileSystemManager, HTableDescriptor hTableDescriptor, Configuration conf, HRegionInfo[] newRegions, MasterServices masterServices) {
        super(server, EventType.C_M_CREATE_TABLE);
        this.fileSystemManager = fileSystemManager;
        this.hTableDescriptor = hTableDescriptor;
        this.conf = conf;
        this.newRegions = newRegions;
        this.catalogTracker = masterServices.getCatalogTracker();
        this.assignmentManager = masterServices.getAssignmentManager();
        this.tableLockManager = masterServices.getTableLockManager();
        this.tableLock = this.tableLockManager.writeLock(this.hTableDescriptor.getTableName(), EventType.C_M_CREATE_TABLE.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTableHandler prepare() throws NotAllMetaRegionsOnlineException, TableExistsException, IOException {
        int timeout = this.conf.getInt("hbase.client.catalog.timeout", 10000);
        try {
            if (this.catalogTracker.waitForMeta((long)timeout) == null) {
                throw new NotAllMetaRegionsOnlineException();
            }
            this.activeUser = RequestContext.isInRequestContext() ? RequestContext.getRequestUser() : UserProvider.instantiate((Configuration)this.conf).getCurrent();
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"Interrupted waiting for meta availability", (Throwable)e);
            InterruptedIOException ie = new InterruptedIOException(e.getMessage());
            ie.initCause(e);
            throw ie;
        }
        this.tableLock.acquire();
        boolean success = false;
        try {
            TableName tableName = this.hTableDescriptor.getTableName();
            if (MetaReader.tableExists((CatalogTracker)this.catalogTracker, (TableName)tableName)) {
                throw new TableExistsException(tableName);
            }
            try {
                if (!this.assignmentManager.getZKTable().checkAndSetEnablingTable(tableName)) {
                    throw new TableExistsException(tableName);
                }
            }
            catch (KeeperException e) {
                throw new IOException("Unable to ensure that the table will be enabling because of a ZooKeeper issue", e);
            }
            success = true;
        }
        finally {
            if (!success) {
                this.releaseTableLock();
            }
        }
        return this;
    }

    @Override
    public String toString() {
        String name = "UnknownServerName";
        if (this.server != null && this.server.getServerName() != null) {
            name = this.server.getServerName().toString();
        }
        return this.getClass().getSimpleName() + "-" + name + "-" + this.getSeqid() + "-" + this.hTableDescriptor.getTableName();
    }

    @Override
    public void process() {
        TableName tableName = this.hTableDescriptor.getTableName();
        LOG.info((Object)("Create table " + tableName));
        try {
            final MasterCoprocessorHost cpHost = ((HMaster)this.server).getCoprocessorHost();
            if (cpHost != null) {
                cpHost.preCreateTableHandler(this.hTableDescriptor, this.newRegions);
            }
            this.handleCreateTable(tableName);
            this.completed(null);
            if (cpHost != null) {
                this.activeUser.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        cpHost.postCreateTableHandler(CreateTableHandler.this.hTableDescriptor, CreateTableHandler.this.newRegions);
                        return null;
                    }
                });
            }
        }
        catch (Throwable e) {
            LOG.error((Object)("Error trying to create the table " + tableName), e);
            this.completed(e);
        }
    }

    protected void completed(Throwable exception) {
        this.releaseTableLock();
        String msg = exception == null ? null : exception.getMessage();
        LOG.info((Object)("Table, " + this.hTableDescriptor.getTableName() + ", creation " + msg == null ? "successful" : "failed. " + msg));
        if (exception != null) {
            try {
                this.assignmentManager.getZKTable().removeEnablingTable(this.hTableDescriptor.getTableName(), false);
            }
            catch (KeeperException e) {
                LOG.error((Object)("Got a keeper exception while removing the ENABLING table znode " + this.hTableDescriptor.getTableName()), (Throwable)e);
            }
        }
    }

    private void handleCreateTable(TableName tableName) throws IOException, KeeperException {
        Path tempdir = this.fileSystemManager.getTempDir();
        FileSystem fs = this.fileSystemManager.getFileSystem();
        Path tempTableDir = FSUtils.getTableDir(tempdir, tableName);
        new FSTableDescriptors(this.conf).createTableDescriptorForTableDirectory(tempTableDir, this.hTableDescriptor, false);
        Path tableDir = FSUtils.getTableDir(this.fileSystemManager.getRootDir(), tableName);
        List<HRegionInfo> regionInfos = this.handleCreateHdfsRegions(tempdir, tableName);
        if (!fs.rename(tempTableDir, tableDir)) {
            throw new IOException("Unable to move table from temp=" + tempTableDir + " to hbase root=" + tableDir);
        }
        if (regionInfos != null && regionInfos.size() > 0) {
            this.addRegionsToMeta(this.catalogTracker, regionInfos);
            try {
                this.assignmentManager.getRegionStates().createRegionStates(regionInfos);
                this.assignmentManager.assign(regionInfos);
            }
            catch (InterruptedException e) {
                LOG.error((Object)("Caught " + e + " during round-robin assignment"));
                InterruptedIOException ie = new InterruptedIOException(e.getMessage());
                ie.initCause(e);
                throw ie;
            }
        }
        try {
            this.assignmentManager.getZKTable().setEnabledTable(tableName);
        }
        catch (KeeperException e) {
            throw new IOException("Unable to ensure that " + tableName + " will be" + " enabled because of a ZooKeeper issue", e);
        }
    }

    private void releaseTableLock() {
        if (this.tableLock != null) {
            try {
                this.tableLock.release();
            }
            catch (IOException ex) {
                LOG.warn((Object)"Could not release the table lock", (Throwable)ex);
            }
        }
    }

    protected List<HRegionInfo> handleCreateHdfsRegions(Path tableRootDir, TableName tableName) throws IOException {
        return ModifyRegionUtils.createRegions(this.conf, tableRootDir, this.hTableDescriptor, this.newRegions, null);
    }

    protected void addRegionsToMeta(CatalogTracker ct, List<HRegionInfo> regionInfos) throws IOException {
        MetaEditor.addRegionsToMeta(this.catalogTracker, regionInfos);
    }
}

