/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import com.google.common.annotations.VisibleForTesting;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Syncable;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogFactory;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.HLogPrettyPrinter;
import org.apache.hadoop.hbase.regionserver.wal.HLogSplitter;
import org.apache.hadoop.hbase.regionserver.wal.MetricsWAL;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.regionserver.wal.WALCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.DrainBarrier;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HasThread;
import org.apache.hadoop.util.StringUtils;
import org.cloudera.htrace.Trace;
import org.cloudera.htrace.TraceScope;

@InterfaceAudience.Private
class FSHLog
implements HLog,
Syncable {
    static final Log LOG = LogFactory.getLog(FSHLog.class);
    private final FileSystem fs;
    private final Path rootDir;
    private final Path dir;
    private final Configuration conf;
    private List<WALActionsListener> listeners = new CopyOnWriteArrayList<WALActionsListener>();
    private final long blocksize;
    private final String prefix;
    private final AtomicLong unflushedEntries = new AtomicLong(0L);
    private final AtomicLong syncedTillHere = new AtomicLong(0L);
    private long lastUnSyncedTxid;
    private final Path oldLogDir;
    private final AtomicLong failedTxid = new AtomicLong(-1L);
    private volatile IOException asyncIOE = null;
    private WALCoprocessorHost coprocessorHost;
    private FSDataOutputStream hdfs_out;
    private int minTolerableReplication;
    private Method getNumCurrentReplicas;
    static final Object[] NO_ARGS = new Object[0];
    private DrainBarrier closeBarrier = new DrainBarrier();
    HLog.Writer writer;
    private final Object oldestSeqNumsLock = new Object();
    private final ReentrantLock rollWriterLock = new ReentrantLock(true);
    private final ConcurrentSkipListMap<byte[], Long> oldestUnflushedSeqNums = new ConcurrentSkipListMap(Bytes.BYTES_COMPARATOR);
    private final Map<byte[], Long> oldestFlushingSeqNums = new TreeMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
    private volatile boolean closed = false;
    private boolean forMeta = false;
    private volatile long filenum = -1L;
    private final AtomicInteger numEntries = new AtomicInteger(0);
    private AtomicInteger consecutiveLogRolls = new AtomicInteger(0);
    private final int lowReplicationRollLimit;
    private volatile boolean lowReplicationRollEnabled = true;
    private final long logrollsize;
    private long curLogSize = 0L;
    private AtomicLong totalLogSize = new AtomicLong(0L);
    private final Object updateLock = new Object();
    private final Object pendingWritesLock = new Object();
    private final boolean enabled;
    private final int maxLogs;
    private List<HLog.Entry> pendingWrites = new LinkedList<HLog.Entry>();
    private final AsyncWriter asyncWriter;
    private final AsyncSyncer[] asyncSyncers;
    private final AsyncNotifier asyncNotifier;
    private final int closeErrorsTolerated;
    private final AtomicInteger closeErrorCount = new AtomicInteger();
    private final MetricsWAL metrics;
    private Map<byte[], Long> latestSequenceNums = new HashMap<byte[], Long>();
    public final Comparator<Path> LOG_NAME_COMPARATOR = new Comparator<Path>(){

        @Override
        public int compare(Path o1, Path o2) {
            long t2;
            long t1 = FSHLog.this.getFileNumFromFileName(o1);
            if (t1 == (t2 = FSHLog.this.getFileNumFromFileName(o2))) {
                return 0;
            }
            return t1 > t2 ? 1 : -1;
        }
    };
    private NavigableMap<Path, Map<byte[], Long>> hlogSequenceNums = new ConcurrentSkipListMap<Path, Map<byte[], Long>>(this.LOG_NAME_COMPARATOR);
    public static final long FIXED_OVERHEAD = ClassSize.align((int)(ClassSize.OBJECT + 5 * ClassSize.REFERENCE + ClassSize.ATOMIC_INTEGER + 4 + 24));

    public FSHLog(FileSystem fs, Path root, String logDir, Configuration conf) throws IOException {
        this(fs, root, logDir, "oldWALs", conf, null, true, null, false);
    }

    public FSHLog(FileSystem fs, Path root, String logDir, String oldLogDir, Configuration conf) throws IOException {
        this(fs, root, logDir, oldLogDir, conf, null, true, null, false);
    }

    public FSHLog(FileSystem fs, Path root, String logDir, Configuration conf, List<WALActionsListener> listeners, String prefix) throws IOException {
        this(fs, root, logDir, "oldWALs", conf, listeners, true, prefix, false);
    }

    public FSHLog(FileSystem fs, Path root, String logDir, String oldLogDir, Configuration conf, List<WALActionsListener> listeners, boolean failIfLogDirExists, String prefix, boolean forMeta) throws IOException {
        this.fs = fs;
        this.rootDir = root;
        this.dir = new Path(this.rootDir, logDir);
        this.oldLogDir = new Path(this.rootDir, oldLogDir);
        this.forMeta = forMeta;
        this.conf = conf;
        if (listeners != null) {
            for (WALActionsListener i : listeners) {
                this.registerWALActionsListener(i);
            }
        }
        this.blocksize = this.conf.getLong("hbase.regionserver.hlog.blocksize", FSUtils.getDefaultBlockSize(this.fs, this.dir));
        float multi = conf.getFloat("hbase.regionserver.logroll.multiplier", 0.95f);
        this.logrollsize = (long)((float)this.blocksize * multi);
        this.maxLogs = conf.getInt("hbase.regionserver.maxlogs", 32);
        this.minTolerableReplication = conf.getInt("hbase.regionserver.hlog.tolerable.lowreplication", (int)FSUtils.getDefaultReplication(fs, this.dir));
        this.lowReplicationRollLimit = conf.getInt("hbase.regionserver.hlog.lowreplication.rolllimit", 5);
        this.enabled = conf.getBoolean("hbase.regionserver.hlog.enabled", true);
        this.closeErrorsTolerated = conf.getInt("hbase.regionserver.logroll.errors.tolerated", 0);
        LOG.info((Object)("WAL/HLog configuration: blocksize=" + StringUtils.byteDesc((long)this.blocksize) + ", rollsize=" + StringUtils.byteDesc((long)this.logrollsize) + ", enabled=" + this.enabled));
        this.prefix = prefix == null || prefix.isEmpty() ? "hlog" : URLEncoder.encode(prefix, "UTF8");
        boolean dirExists = false;
        if (failIfLogDirExists && (dirExists = this.fs.exists(this.dir))) {
            throw new IOException("Target HLog directory already exists: " + this.dir);
        }
        if (!dirExists && !fs.mkdirs(this.dir)) {
            throw new IOException("Unable to mkdir " + this.dir);
        }
        if (!fs.exists(this.oldLogDir) && !fs.mkdirs(this.oldLogDir)) {
            throw new IOException("Unable to mkdir " + this.oldLogDir);
        }
        this.rollWriter();
        this.getNumCurrentReplicas = this.getGetNumCurrentReplicas(this.hdfs_out);
        String n = Thread.currentThread().getName();
        this.asyncWriter = new AsyncWriter(n + "-WAL.AsyncWriter");
        this.asyncWriter.start();
        int syncerNums = conf.getInt("hbase.hlog.asyncer.number", 5);
        this.asyncSyncers = new AsyncSyncer[syncerNums];
        for (int i = 0; i < this.asyncSyncers.length; ++i) {
            this.asyncSyncers[i] = new AsyncSyncer(n + "-WAL.AsyncSyncer" + i);
            this.asyncSyncers[i].start();
        }
        this.asyncNotifier = new AsyncNotifier(n + "-WAL.AsyncNotifier");
        this.asyncNotifier.start();
        this.coprocessorHost = new WALCoprocessorHost(this, conf);
        this.metrics = new MetricsWAL();
    }

    private Method getGetNumCurrentReplicas(FSDataOutputStream os) {
        Method m = null;
        if (os != null) {
            Class<?> wrappedStreamClass = os.getWrappedStream().getClass();
            try {
                m = wrappedStreamClass.getDeclaredMethod("getNumCurrentReplicas", new Class[0]);
                m.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                LOG.info((Object)("FileSystem's output stream doesn't support getNumCurrentReplicas; --HDFS-826 not available; fsOut=" + wrappedStreamClass.getName()));
            }
            catch (SecurityException e) {
                LOG.info((Object)("Doesn't have access to getNumCurrentReplicas on FileSystems's output stream --HDFS-826 not available; fsOut=" + wrappedStreamClass.getName()), (Throwable)e);
                m = null;
            }
        }
        if (m != null && LOG.isTraceEnabled()) {
            LOG.trace((Object)"Using getNumCurrentReplicas--HDFS-826");
        }
        return m;
    }

    @Override
    public void registerWALActionsListener(WALActionsListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean unregisterWALActionsListener(WALActionsListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public long getFilenum() {
        return this.filenum;
    }

    OutputStream getOutputStream() {
        return this.hdfs_out.getWrappedStream();
    }

    @Override
    public byte[][] rollWriter() throws FailedLogCloseException, IOException {
        return this.rollWriter(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[][] rollWriter(boolean force) throws FailedLogCloseException, IOException {
        this.rollWriterLock.lock();
        try {
            if (!force && this.writer != null && this.numEntries.get() <= 0) {
                byte[][] byArray = null;
                return byArray;
            }
            byte[][] regionsToFlush = null;
            if (this.closed) {
                LOG.debug((Object)"HLog closed. Skipping rolling of writer");
                byte[][] byArray = null;
                return byArray;
            }
            try {
                if (!this.closeBarrier.beginOp()) {
                    LOG.debug((Object)"HLog closing. Skipping rolling of writer");
                    byte[][] byArray = regionsToFlush;
                    return byArray;
                }
                long currentFilenum = this.filenum;
                Path oldPath = null;
                if (currentFilenum > 0L) {
                    oldPath = this.computeFilename(currentFilenum);
                }
                this.filenum = System.currentTimeMillis();
                Path newPath = this.computeFilename();
                while (this.fs.exists(newPath)) {
                    ++this.filenum;
                    newPath = this.computeFilename();
                }
                if (!this.listeners.isEmpty()) {
                    for (WALActionsListener i : this.listeners) {
                        i.preLogRoll(oldPath, newPath);
                    }
                }
                HLog.Writer nextWriter = this.createWriterInstance(this.fs, newPath, this.conf);
                FSDataOutputStream nextHdfsOut = null;
                if (nextWriter instanceof ProtobufLogWriter) {
                    nextHdfsOut = ((ProtobufLogWriter)nextWriter).getStream();
                    try {
                        nextWriter.sync();
                    }
                    catch (IOException e) {
                        LOG.warn((Object)"pre-sync failed", (Throwable)e);
                    }
                }
                Path oldFile = null;
                int oldNumEntries = 0;
                Object object = this.updateLock;
                synchronized (object) {
                    oldNumEntries = this.numEntries.get();
                    oldFile = this.cleanupCurrentWriter(currentFilenum);
                    this.writer = nextWriter;
                    this.hdfs_out = nextHdfsOut;
                    this.numEntries.set(0);
                    if (oldFile != null) {
                        this.hlogSequenceNums.put(oldFile, this.latestSequenceNums);
                        this.latestSequenceNums = new HashMap<byte[], Long>();
                    }
                }
                if (oldFile == null) {
                    LOG.info((Object)("New WAL " + FSUtils.getPath(newPath)));
                } else {
                    long oldFileLen = this.fs.getFileStatus(oldFile).getLen();
                    this.totalLogSize.addAndGet(oldFileLen);
                    LOG.info((Object)("Rolled WAL " + FSUtils.getPath(oldFile) + " with entries=" + oldNumEntries + ", filesize=" + StringUtils.humanReadableInt((long)oldFileLen) + "; new WAL " + FSUtils.getPath(newPath)));
                }
                if (!this.listeners.isEmpty()) {
                    for (WALActionsListener i : this.listeners) {
                        i.postLogRoll(oldPath, newPath);
                    }
                }
                if (this.getNumRolledLogFiles() > 0) {
                    this.cleanOldLogs();
                    regionsToFlush = this.findRegionsToForceFlush();
                }
            }
            finally {
                this.closeBarrier.endOp();
            }
            byte[][] byArray = regionsToFlush;
            return byArray;
        }
        finally {
            this.rollWriterLock.unlock();
        }
    }

    protected HLog.Writer createWriterInstance(FileSystem fs, Path path, Configuration conf) throws IOException {
        if (this.forMeta) {
            // empty if block
        }
        return HLogFactory.createWALWriter(fs, path, conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanOldLogs() throws IOException {
        HashMap<byte[], Long> oldestFlushingSeqNumsLocal = null;
        HashMap<byte[], Long> oldestUnflushedSeqNumsLocal = null;
        ArrayList<Path> logsToArchive = new ArrayList<Path>();
        Object object = this.oldestSeqNumsLock;
        synchronized (object) {
            oldestFlushingSeqNumsLocal = new HashMap<byte[], Long>(this.oldestFlushingSeqNums);
            oldestUnflushedSeqNumsLocal = new HashMap<byte[], Long>(this.oldestUnflushedSeqNums);
        }
        for (Map.Entry e : this.hlogSequenceNums.entrySet()) {
            Path log = (Path)e.getKey();
            Map sequenceNums = (Map)e.getValue();
            if (!FSHLog.areAllRegionsFlushed(sequenceNums, oldestFlushingSeqNumsLocal, oldestUnflushedSeqNumsLocal)) continue;
            logsToArchive.add(log);
            LOG.debug((Object)("log file is ready for archiving " + log));
        }
        for (Path p : logsToArchive) {
            this.totalLogSize.addAndGet(-this.fs.getFileStatus(p).getLen());
            this.archiveLogFile(p);
            this.hlogSequenceNums.remove(p);
        }
    }

    static boolean areAllRegionsFlushed(Map<byte[], Long> sequenceNums, Map<byte[], Long> oldestFlushingMap, Map<byte[], Long> oldestUnflushedMap) {
        for (Map.Entry<byte[], Long> regionSeqIdEntry : sequenceNums.entrySet()) {
            long oldestUnFlushed;
            long oldestFlushing = oldestFlushingMap.containsKey(regionSeqIdEntry.getKey()) ? oldestFlushingMap.get(regionSeqIdEntry.getKey()) : Long.MAX_VALUE;
            long minSeqNum = Math.min(oldestFlushing, oldestUnFlushed = oldestUnflushedMap.containsKey(regionSeqIdEntry.getKey()) ? oldestUnflushedMap.get(regionSeqIdEntry.getKey()) : Long.MAX_VALUE);
            if (minSeqNum > regionSeqIdEntry.getValue()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[][] findEligibleMemstoresToFlush(Map<byte[], Long> regionsSequenceNums) {
        ArrayList<byte[]> regionsToFlush = null;
        Object object = this.oldestSeqNumsLock;
        synchronized (object) {
            for (Map.Entry<byte[], Long> e : regionsSequenceNums.entrySet()) {
                Long unFlushedVal = this.oldestUnflushedSeqNums.get(e.getKey());
                if (unFlushedVal == null || unFlushedVal > e.getValue()) continue;
                if (regionsToFlush == null) {
                    regionsToFlush = new ArrayList<byte[]>();
                }
                regionsToFlush.add(e.getKey());
            }
        }
        return regionsToFlush == null ? (byte[][])null : (byte[][])regionsToFlush.toArray((T[])new byte[][]{HConstants.EMPTY_BYTE_ARRAY});
    }

    byte[][] findRegionsToForceFlush() throws IOException {
        byte[][] regions = null;
        int logCount = this.getNumRolledLogFiles();
        if (logCount > this.maxLogs && logCount > 0) {
            Map.Entry<Path, Map<byte[], Long>> firstWALEntry = this.hlogSequenceNums.firstEntry();
            regions = this.findEligibleMemstoresToFlush(firstWALEntry.getValue());
        }
        if (regions != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < regions.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(Bytes.toStringBinary((byte[])regions[i]));
            }
            LOG.info((Object)("Too many hlogs: logs=" + logCount + ", maxlogs=" + this.maxLogs + "; forcing flush of " + regions.length + " regions(s): " + sb.toString()));
        }
        return regions;
    }

    Path cleanupCurrentWriter(long currentfilenum) throws IOException {
        Path oldFile = null;
        if (this.writer != null) {
            try {
                if (this.unflushedEntries.get() != this.syncedTillHere.get()) {
                    LOG.debug((Object)("cleanupCurrentWriter  waiting for transactions to get synced  total " + this.unflushedEntries.get() + " synced till here " + this.syncedTillHere.get()));
                    this.sync();
                }
                this.writer.close();
                this.writer = null;
                this.closeErrorCount.set(0);
            }
            catch (IOException e) {
                LOG.error((Object)"Failed close of HLog writer", (Throwable)e);
                int errors = this.closeErrorCount.incrementAndGet();
                if (errors <= this.closeErrorsTolerated && !this.hasUnSyncedEntries()) {
                    LOG.warn((Object)("Riding over HLog close failure! error count=" + errors));
                }
                if (this.hasUnSyncedEntries()) {
                    LOG.error((Object)"Aborting due to unflushed edits in HLog");
                }
                FailedLogCloseException flce = new FailedLogCloseException("#" + currentfilenum);
                flce.initCause((Throwable)e);
                throw flce;
            }
            if (currentfilenum >= 0L) {
                oldFile = this.computeFilename(currentfilenum);
            }
        }
        return oldFile;
    }

    private void archiveLogFile(Path p) throws IOException {
        Path newPath = FSHLog.getHLogArchivePath(this.oldLogDir, p);
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener i : this.listeners) {
                i.preLogArchive(p, newPath);
            }
        }
        if (!FSUtils.renameAndSetModifyTime(this.fs, p, newPath)) {
            throw new IOException("Unable to rename " + p + " to " + newPath);
        }
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener i : this.listeners) {
                i.postLogArchive(p, newPath);
            }
        }
    }

    protected Path computeFilename() {
        return this.computeFilename(this.filenum);
    }

    protected Path computeFilename(long filenum) {
        if (filenum < 0L) {
            throw new RuntimeException("hlog file number can't be < 0");
        }
        String child = this.prefix + "." + filenum;
        if (this.forMeta) {
            child = child + ".meta";
        }
        return new Path(this.dir, child);
    }

    protected long getFileNumFromFileName(Path fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("file name can't be null");
        }
        String prefixPathStr = new Path(this.dir, this.prefix + ".").toString();
        if (!fileName.toString().startsWith(prefixPathStr)) {
            throw new IllegalArgumentException("The log file " + fileName + " doesn't belong to" + " this regionserver " + prefixPathStr);
        }
        String chompedPath = fileName.toString().substring(prefixPathStr.length());
        if (this.forMeta) {
            chompedPath = chompedPath.substring(0, chompedPath.indexOf(".meta"));
        }
        return Long.parseLong(chompedPath);
    }

    @Override
    public void closeAndDelete() throws IOException {
        this.close();
        if (!this.fs.exists(this.dir)) {
            return;
        }
        FileStatus[] files = this.fs.listStatus(this.dir);
        if (files != null) {
            for (FileStatus file : files) {
                Path p = FSHLog.getHLogArchivePath(this.oldLogDir, file.getPath());
                if (!this.listeners.isEmpty()) {
                    for (WALActionsListener i : this.listeners) {
                        i.preLogArchive(file.getPath(), p);
                    }
                }
                if (!FSUtils.renameAndSetModifyTime(this.fs, file.getPath(), p)) {
                    throw new IOException("Unable to rename " + file.getPath() + " to " + p);
                }
                if (this.listeners.isEmpty()) continue;
                for (WALActionsListener i : this.listeners) {
                    i.postLogArchive(file.getPath(), p);
                }
            }
            LOG.debug((Object)("Moved " + files.length + " WAL file(s) to " + FSUtils.getPath(this.oldLogDir)));
        }
        if (!this.fs.delete(this.dir, true)) {
            LOG.info((Object)("Unable to delete " + this.dir));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            this.asyncNotifier.interrupt();
            this.asyncNotifier.join();
        }
        catch (InterruptedException e) {
            LOG.error((Object)("Exception while waiting for " + this.asyncNotifier.getName() + " threads to die"), (Throwable)e);
        }
        for (int i = 0; i < this.asyncSyncers.length; ++i) {
            try {
                this.asyncSyncers[i].interrupt();
                this.asyncSyncers[i].join();
                continue;
            }
            catch (InterruptedException e) {
                LOG.error((Object)("Exception while waiting for " + this.asyncSyncers[i].getName() + " threads to die"), (Throwable)e);
            }
        }
        try {
            this.asyncWriter.interrupt();
            this.asyncWriter.join();
        }
        catch (InterruptedException e) {
            LOG.error((Object)("Exception while waiting for " + this.asyncWriter.getName() + " thread to die"), (Throwable)e);
        }
        try {
            this.closeBarrier.stopAndDrainOps();
        }
        catch (InterruptedException e) {
            LOG.error((Object)"Exception while waiting for cache flushes and log rolls", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener i : this.listeners) {
                i.logCloseRequested();
            }
        }
        Object object = this.updateLock;
        synchronized (object) {
            this.closed = true;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Closing WAL writer in " + this.dir.toString()));
            }
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
        }
    }

    protected HLogKey makeKey(byte[] encodedRegionName, TableName tableName, long seqnum, long now, List<UUID> clusterIds, long nonceGroup, long nonce) {
        return new HLogKey(encodedRegionName, tableName, seqnum, now, clusterIds, nonceGroup, nonce);
    }

    @Override
    @VisibleForTesting
    public void append(HRegionInfo info, TableName tableName, WALEdit edits, long now, HTableDescriptor htd, AtomicLong sequenceId) throws IOException {
        this.append(info, tableName, edits, new ArrayList<UUID>(), now, htd, true, true, sequenceId, 0L, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long append(HRegionInfo info, TableName tableName, WALEdit edits, List<UUID> clusterIds, long now, HTableDescriptor htd, boolean doSync, boolean isInMemstore, AtomicLong sequenceId, long nonceGroup, long nonce) throws IOException {
        if (edits.isEmpty()) {
            return this.unflushedEntries.get();
        }
        if (this.closed) {
            throw new IOException("Cannot append; log is closed");
        }
        TraceScope traceScope = Trace.startSpan((String)"FSHlog.append");
        try {
            long txid = 0L;
            Object object = this.updateLock;
            synchronized (object) {
                long seqNum = sequenceId.incrementAndGet();
                byte[] encodedRegionName = info.getEncodedNameAsBytes();
                if (isInMemstore) {
                    this.oldestUnflushedSeqNums.putIfAbsent(encodedRegionName, seqNum);
                }
                HLogKey logKey = this.makeKey(encodedRegionName, tableName, seqNum, now, clusterIds, nonceGroup, nonce);
                Object object2 = this.pendingWritesLock;
                synchronized (object2) {
                    this.doWrite(info, logKey, edits, htd);
                    txid = this.unflushedEntries.incrementAndGet();
                }
                this.numEntries.incrementAndGet();
                this.asyncWriter.setPendingTxid(txid);
                if (htd.isDeferredLogFlush()) {
                    this.lastUnSyncedTxid = txid;
                }
                this.latestSequenceNums.put(encodedRegionName, seqNum);
            }
            if (doSync && (info.isMetaRegion() || !htd.isDeferredLogFlush())) {
                this.sync(txid);
            }
            long l = txid;
            return l;
        }
        finally {
            traceScope.close();
        }
    }

    @Override
    public long appendNoSync(HRegionInfo info, TableName tableName, WALEdit edits, List<UUID> clusterIds, long now, HTableDescriptor htd, AtomicLong sequenceId, boolean isInMemstore, long nonceGroup, long nonce) throws IOException {
        return this.append(info, tableName, edits, clusterIds, now, htd, false, isInMemstore, sequenceId, nonceGroup, nonce);
    }

    private void syncer() throws IOException {
        this.syncer(this.unflushedEntries.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncer(long txid) throws IOException {
        AtomicLong atomicLong = this.syncedTillHere;
        synchronized (atomicLong) {
            while (this.syncedTillHere.get() < txid) {
                try {
                    this.syncedTillHere.wait();
                }
                catch (InterruptedException e) {
                    LOG.debug((Object)"interrupted while waiting for notification from AsyncNotifier");
                }
            }
        }
        if (txid <= this.failedTxid.get()) {
            assert (this.asyncIOE != null) : "current txid is among(under) failed txids, but asyncIOE is null!";
            throw this.asyncIOE;
        }
    }

    @Override
    public void postSync() {
    }

    @Override
    public void postAppend(List<HLog.Entry> entries) {
    }

    private boolean checkLowReplication() {
        boolean logRollNeeded = false;
        try {
            int numCurrentReplicas = this.getLogReplication();
            if (numCurrentReplicas != 0 && numCurrentReplicas < this.minTolerableReplication) {
                if (this.lowReplicationRollEnabled) {
                    if (this.consecutiveLogRolls.get() < this.lowReplicationRollLimit) {
                        LOG.warn((Object)("HDFS pipeline error detected. Found " + numCurrentReplicas + " replicas but expecting no less than " + this.minTolerableReplication + " replicas. " + " Requesting close of hlog."));
                        logRollNeeded = true;
                        this.consecutiveLogRolls.getAndIncrement();
                    } else {
                        LOG.warn((Object)"Too many consecutive RollWriter requests, it's a sign of the total number of live datanodes is lower than the tolerable replicas.");
                        this.consecutiveLogRolls.set(0);
                        this.lowReplicationRollEnabled = false;
                    }
                }
            } else if (numCurrentReplicas >= this.minTolerableReplication && !this.lowReplicationRollEnabled) {
                if (this.numEntries.get() <= 1) {
                    return logRollNeeded;
                }
                this.lowReplicationRollEnabled = true;
                LOG.info((Object)"LowReplication-Roller was enabled.");
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to invoke DFSOutputStream.getNumCurrentReplicas" + e + " still proceeding ahead..."));
        }
        return logRollNeeded;
    }

    int getLogReplication() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object repl;
        if (this.getNumCurrentReplicas != null && this.hdfs_out != null && (repl = this.getNumCurrentReplicas.invoke((Object)this.getOutputStream(), NO_ARGS)) instanceof Integer) {
            return (Integer)repl;
        }
        return 0;
    }

    boolean canGetCurReplicas() {
        return this.getNumCurrentReplicas != null;
    }

    @Override
    public void hsync() throws IOException {
        this.syncer();
    }

    @Override
    public void hflush() throws IOException {
        this.syncer();
    }

    @Override
    public void sync() throws IOException {
        this.syncer();
    }

    @Override
    public void sync(long txid) throws IOException {
        this.syncer(txid);
    }

    private void requestLogRoll() {
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener i : this.listeners) {
                i.logRollRequested();
            }
        }
    }

    protected void doWrite(HRegionInfo info, HLogKey logKey, WALEdit logEdit, HTableDescriptor htd) throws IOException {
        if (!this.enabled) {
            return;
        }
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener i : this.listeners) {
                i.visitLogEntryBeforeWrite(htd, logKey, logEdit);
            }
        }
        try {
            long now = EnvironmentEdgeManager.currentTimeMillis();
            if (!this.coprocessorHost.preWALWrite(info, logKey, logEdit)) {
                if (logEdit.isReplay()) {
                    logKey.setScopes(null);
                }
                this.pendingWrites.add(new HLog.Entry(logKey, logEdit));
            }
            long took = EnvironmentEdgeManager.currentTimeMillis() - now;
            this.coprocessorHost.postWALWrite(info, logKey, logEdit);
            long len = 0L;
            for (KeyValue kv : logEdit.getKeyValues()) {
                len += (long)kv.getLength();
            }
            this.metrics.finishAppend(took, len);
        }
        catch (IOException e) {
            LOG.fatal((Object)"Could not append. Requesting close of hlog", (Throwable)e);
            this.requestLogRoll();
            throw e;
        }
    }

    int getNumEntries() {
        return this.numEntries.get();
    }

    public int getNumRolledLogFiles() {
        return this.hlogSequenceNums.size();
    }

    @Override
    public int getNumLogFiles() {
        return this.getNumRolledLogFiles() + 1;
    }

    @Override
    public long getLogFileSize() {
        return this.totalLogSize.get() + this.curLogSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startCacheFlush(byte[] encodedRegionName) {
        Long oldRegionSeqNum = null;
        if (!this.closeBarrier.beginOp()) {
            LOG.info((Object)("Flush will not be started for " + Bytes.toString((byte[])encodedRegionName) + " - because the server is closing."));
            return false;
        }
        Object object = this.oldestSeqNumsLock;
        synchronized (object) {
            oldRegionSeqNum = this.oldestUnflushedSeqNums.remove(encodedRegionName);
            if (oldRegionSeqNum != null) {
                Long oldValue = this.oldestFlushingSeqNums.put(encodedRegionName, oldRegionSeqNum);
                assert (oldValue == null) : "Flushing map not cleaned up for " + Bytes.toString((byte[])encodedRegionName);
            }
        }
        if (oldRegionSeqNum == null) {
            LOG.warn((Object)("Couldn't find oldest seqNum for the region we are about to flush: [" + Bytes.toString((byte[])encodedRegionName) + "]"));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completeCacheFlush(byte[] encodedRegionName) {
        Object object = this.oldestSeqNumsLock;
        synchronized (object) {
            this.oldestFlushingSeqNums.remove(encodedRegionName);
        }
        this.closeBarrier.endOp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortCacheFlush(byte[] encodedRegionName) {
        Long currentSeqNum = null;
        Long seqNumBeforeFlushStarts = null;
        Object object = this.oldestSeqNumsLock;
        synchronized (object) {
            seqNumBeforeFlushStarts = this.oldestFlushingSeqNums.remove(encodedRegionName);
            if (seqNumBeforeFlushStarts != null) {
                currentSeqNum = this.oldestUnflushedSeqNums.put(encodedRegionName, seqNumBeforeFlushStarts);
            }
        }
        this.closeBarrier.endOp();
        if (currentSeqNum != null && currentSeqNum <= seqNumBeforeFlushStarts) {
            String errorStr = "Region " + Bytes.toString((byte[])encodedRegionName) + "acquired edits out of order current memstore seq=" + currentSeqNum + ", previous oldest unflushed id=" + seqNumBeforeFlushStarts;
            LOG.error((Object)errorStr);
            assert (false) : errorStr;
            Runtime.getRuntime().halt(1);
        }
    }

    @Override
    public boolean isLowReplicationRollEnabled() {
        return this.lowReplicationRollEnabled;
    }

    protected Path getDir() {
        return this.dir;
    }

    static Path getHLogArchivePath(Path oldLogDir, Path p) {
        return new Path(oldLogDir, p.getName());
    }

    static String formatRecoveredEditsFileName(long seqid) {
        return String.format("%019d", seqid);
    }

    private static void usage() {
        System.err.println("Usage: HLog <ARGS>");
        System.err.println("Arguments:");
        System.err.println(" --dump  Dump textual representation of passed one or more files");
        System.err.println("         For example: HLog --dump hdfs://example.com:9000/hbase/.logs/MACHINE/LOGFILE");
        System.err.println(" --split Split the passed directory of WAL logs");
        System.err.println("         For example: HLog --split hdfs://example.com:9000/hbase/.logs/DIR");
    }

    private static void split(Configuration conf, Path p) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (!fs.exists(p)) {
            throw new FileNotFoundException(p.toString());
        }
        if (!fs.getFileStatus(p).isDir()) {
            throw new IOException(p + " is not a directory");
        }
        Path baseDir = FSUtils.getRootDir(conf);
        Path oldLogDir = new Path(baseDir, "oldWALs");
        HLogSplitter.split(baseDir, p, oldLogDir, fs, conf);
    }

    @Override
    public WALCoprocessorHost getCoprocessorHost() {
        return this.coprocessorHost;
    }

    boolean hasUnSyncedEntries() {
        return this.lastUnSyncedTxid > this.syncedTillHere.get();
    }

    @Override
    public long getEarliestMemstoreSeqNum(byte[] encodedRegionName) {
        Long result = this.oldestUnflushedSeqNums.get(encodedRegionName);
        return result == null ? -1L : result;
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            FSHLog.usage();
            System.exit(-1);
        }
        if (args[0].compareTo("--dump") == 0) {
            HLogPrettyPrinter.run(Arrays.copyOfRange(args, 1, args.length));
        } else if (args[0].compareTo("--split") == 0) {
            Configuration conf = HBaseConfiguration.create();
            for (int i = 1; i < args.length; ++i) {
                try {
                    Path logPath = new Path(args[i]);
                    FSUtils.setFsDefault(conf, logPath);
                    FSHLog.split(conf, logPath);
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                    System.exit(-1);
                }
            }
        } else {
            FSHLog.usage();
            System.exit(-1);
        }
    }

    private class AsyncNotifier
    extends HasThread {
        private long flushedTxid;
        private long lastNotifiedTxid;
        private Object notifyLock;

        public AsyncNotifier(String name) {
            super(name);
            this.flushedTxid = 0L;
            this.lastNotifiedTxid = 0L;
            this.notifyLock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setFlushedTxid(long txid) {
            Object object = this.notifyLock;
            synchronized (object) {
                if (txid <= this.flushedTxid) {
                    return;
                }
                this.flushedTxid = txid;
                this.notifyLock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (!this.isInterrupted()) {
                    Object object = this.notifyLock;
                    synchronized (object) {
                        while (this.flushedTxid <= this.lastNotifiedTxid) {
                            this.notifyLock.wait();
                        }
                        this.lastNotifiedTxid = this.flushedTxid;
                    }
                    object = FSHLog.this.syncedTillHere;
                    synchronized (object) {
                        FSHLog.this.syncedTillHere.set(this.lastNotifiedTxid);
                        FSHLog.this.syncedTillHere.notifyAll();
                    }
                }
                return;
            }
            catch (InterruptedException e) {
                LOG.debug((Object)(this.getName() + " interrupted while waiting for " + " notification from AsyncSyncer thread"));
                return;
            }
            catch (Exception e) {
                LOG.error((Object)"UNEXPECTED", (Throwable)e);
                return;
            }
            finally {
                LOG.info((Object)(this.getName() + " exiting"));
            }
        }
    }

    private class AsyncSyncer
    extends HasThread {
        private long writtenTxid;
        private long txidToSync;
        private long lastSyncedTxid;
        private volatile boolean isSyncing;
        private Object syncLock;

        public AsyncSyncer(String name) {
            super(name);
            this.writtenTxid = 0L;
            this.txidToSync = 0L;
            this.lastSyncedTxid = 0L;
            this.isSyncing = false;
            this.syncLock = new Object();
        }

        public boolean isSyncing() {
            return this.isSyncing;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setWrittenTxid(long txid) {
            Object object = this.syncLock;
            synchronized (object) {
                if (txid <= this.writtenTxid) {
                    return;
                }
                this.writtenTxid = txid;
                this.syncLock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block24: {
                block17: while (true) {
                    try {
                        while (!this.isInterrupted()) {
                            Object object = this.syncLock;
                            synchronized (object) {
                                while (this.writtenTxid <= this.lastSyncedTxid) {
                                    this.syncLock.wait();
                                }
                                this.txidToSync = this.writtenTxid;
                            }
                            if (this.txidToSync <= FSHLog.this.syncedTillHere.get()) {
                                this.lastSyncedTxid = this.txidToSync;
                                continue;
                            }
                            long now = EnvironmentEdgeManager.currentTimeMillis();
                            try {
                                if (FSHLog.this.writer == null) {
                                    LOG.fatal((Object)"should never happen: has unsynced writes but writer is null!");
                                    FSHLog.this.asyncIOE = new IOException("has unsynced writes but writer is null!");
                                    FSHLog.this.failedTxid.set(this.txidToSync);
                                } else {
                                    this.isSyncing = true;
                                    FSHLog.this.writer.sync();
                                    this.isSyncing = false;
                                }
                                FSHLog.this.postSync();
                            }
                            catch (IOException e) {
                                LOG.fatal((Object)"Error while AsyncSyncer sync, request close of hlog ", (Throwable)e);
                                FSHLog.this.requestLogRoll();
                                FSHLog.this.asyncIOE = e;
                                FSHLog.this.failedTxid.set(this.txidToSync);
                                this.isSyncing = false;
                            }
                            FSHLog.this.metrics.finishSync(EnvironmentEdgeManager.currentTimeMillis() - now);
                            this.lastSyncedTxid = this.txidToSync;
                            FSHLog.this.asyncNotifier.setFlushedTxid(this.lastSyncedTxid);
                            boolean logRollNeeded = false;
                            if (!FSHLog.this.rollWriterLock.tryLock()) continue;
                            try {
                                logRollNeeded = FSHLog.this.checkLowReplication();
                            }
                            finally {
                                FSHLog.this.rollWriterLock.unlock();
                            }
                            try {
                                if (!logRollNeeded && (FSHLog.this.writer == null || FSHLog.this.writer.getLength() <= FSHLog.this.logrollsize)) continue block17;
                                FSHLog.this.requestLogRoll();
                                continue block17;
                            }
                            catch (IOException e) {
                                LOG.warn((Object)"writer.getLength() failed,this failure won't block here");
                            }
                        }
                        break block24;
                    }
                    catch (InterruptedException e) {
                        LOG.debug((Object)(this.getName() + " interrupted while waiting for " + "notification from AsyncWriter thread"));
                        break block24;
                    }
                    catch (Exception e) {
                        LOG.error((Object)"UNEXPECTED", (Throwable)e);
                        break block24;
                    }
                }
                finally {
                    LOG.info((Object)(this.getName() + " exiting"));
                }
            }
        }
    }

    private class AsyncWriter
    extends HasThread {
        private long pendingTxid;
        private long txidToWrite;
        private long lastWrittenTxid;
        private Object writeLock;

        public AsyncWriter(String name) {
            super(name);
            this.pendingTxid = 0L;
            this.txidToWrite = 0L;
            this.lastWrittenTxid = 0L;
            this.writeLock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPendingTxid(long txid) {
            Object object = this.writeLock;
            synchronized (object) {
                if (txid <= this.pendingTxid) {
                    return;
                }
                this.pendingTxid = txid;
                this.writeLock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (!this.isInterrupted()) {
                    Object object = this.writeLock;
                    synchronized (object) {
                        while (this.pendingTxid <= this.lastWrittenTxid) {
                            this.writeLock.wait();
                        }
                    }
                    List pendWrites = null;
                    Object object2 = FSHLog.this.pendingWritesLock;
                    synchronized (object2) {
                        this.txidToWrite = FSHLog.this.unflushedEntries.get();
                        pendWrites = FSHLog.this.pendingWrites;
                        FSHLog.this.pendingWrites = new LinkedList();
                    }
                    try {
                        for (HLog.Entry e : pendWrites) {
                            FSHLog.this.writer.append(e);
                        }
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Error while AsyncWriter write, request close of hlog ", (Throwable)e);
                        FSHLog.this.requestLogRoll();
                        FSHLog.this.asyncIOE = e;
                        FSHLog.this.failedTxid.set(this.txidToWrite);
                    }
                    this.lastWrittenTxid = this.txidToWrite;
                    boolean hasIdleSyncer = false;
                    for (int i = 0; i < FSHLog.this.asyncSyncers.length; ++i) {
                        if (FSHLog.this.asyncSyncers[i].isSyncing()) continue;
                        hasIdleSyncer = true;
                        FSHLog.this.asyncSyncers[i].setWrittenTxid(this.lastWrittenTxid);
                        break;
                    }
                    if (hasIdleSyncer) continue;
                    int idx = (int)(this.lastWrittenTxid % (long)FSHLog.this.asyncSyncers.length);
                    FSHLog.this.asyncSyncers[idx].setWrittenTxid(this.lastWrittenTxid);
                }
            }
            catch (InterruptedException e) {
                LOG.debug((Object)(this.getName() + " interrupted while waiting for " + "newer writes added to local buffer"));
            }
            catch (Exception e) {
                LOG.error((Object)"UNEXPECTED", (Throwable)e);
            }
            finally {
                LOG.info((Object)(this.getName() + " exiting"));
            }
        }
    }
}

