/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.io.IOException;
import java.io.Serializable;
import javax.servlet.ServletContext;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.rest.ProtobufMessageHandler;
import org.apache.hadoop.hbase.rest.protobuf.generated.VersionMessage;

@XmlRootElement(name="Version")
@InterfaceAudience.Private
public class VersionModel
implements Serializable,
ProtobufMessageHandler {
    private static final long serialVersionUID = 1L;
    private String restVersion;
    private String jvmVersion;
    private String osVersion;
    private String serverVersion;
    private String jerseyVersion;

    public VersionModel() {
    }

    public VersionModel(ServletContext context) {
        this.restVersion = "0.0.3";
        this.jvmVersion = System.getProperty("java.vm.vendor") + ' ' + System.getProperty("java.version") + '-' + System.getProperty("java.vm.version");
        this.osVersion = System.getProperty("os.name") + ' ' + System.getProperty("os.version") + ' ' + System.getProperty("os.arch");
        this.serverVersion = context.getServerInfo();
        this.jerseyVersion = ServletContainer.class.getPackage().getImplementationVersion();
    }

    @XmlAttribute(name="REST")
    public String getRESTVersion() {
        return this.restVersion;
    }

    @XmlAttribute(name="JVM")
    public String getJVMVersion() {
        return this.jvmVersion;
    }

    @XmlAttribute(name="OS")
    public String getOSVersion() {
        return this.osVersion;
    }

    @XmlAttribute(name="Server")
    public String getServerVersion() {
        return this.serverVersion;
    }

    @XmlAttribute(name="Jersey")
    public String getJerseyVersion() {
        return this.jerseyVersion;
    }

    public void setRESTVersion(String version) {
        this.restVersion = version;
    }

    public void setOSVersion(String version) {
        this.osVersion = version;
    }

    public void setJVMVersion(String version) {
        this.jvmVersion = version;
    }

    public void setServerVersion(String version) {
        this.serverVersion = version;
    }

    public void setJerseyVersion(String version) {
        this.jerseyVersion = version;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("rest ");
        sb.append(this.restVersion);
        sb.append(" [JVM: ");
        sb.append(this.jvmVersion);
        sb.append("] [OS: ");
        sb.append(this.osVersion);
        sb.append("] [Server: ");
        sb.append(this.serverVersion);
        sb.append("] [Jersey: ");
        sb.append(this.jerseyVersion);
        sb.append("]\n");
        return sb.toString();
    }

    @Override
    public byte[] createProtobufOutput() {
        VersionMessage.Version.Builder builder = VersionMessage.Version.newBuilder();
        builder.setRestVersion(this.restVersion);
        builder.setJvmVersion(this.jvmVersion);
        builder.setOsVersion(this.osVersion);
        builder.setServerVersion(this.serverVersion);
        builder.setJerseyVersion(this.jerseyVersion);
        return builder.build().toByteArray();
    }

    @Override
    public ProtobufMessageHandler getObjectFromMessage(byte[] message) throws IOException {
        VersionMessage.Version.Builder builder = VersionMessage.Version.newBuilder();
        builder.mergeFrom(message);
        if (builder.hasRestVersion()) {
            this.restVersion = builder.getRestVersion();
        }
        if (builder.hasJvmVersion()) {
            this.jvmVersion = builder.getJvmVersion();
        }
        if (builder.hasOsVersion()) {
            this.osVersion = builder.getOsVersion();
        }
        if (builder.hasServerVersion()) {
            this.serverVersion = builder.getServerVersion();
        }
        if (builder.hasJerseyVersion()) {
            this.jerseyVersion = builder.getJerseyVersion();
        }
        return this;
    }
}

