/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.rss;

import java.util.List;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.engine.Initializable;
import org.apache.wiki.rss.Feed;
import org.apache.wiki.util.TextUtil;

public interface RSSGenerator
extends Initializable {
    public static final String RSS10 = "rss10";
    public static final String RSS20 = "rss20";
    public static final String ATOM = "atom";
    public static final String MODE_BLOG = "blog";
    public static final String MODE_WIKI = "wiki";
    public static final String MODE_FULL = "full";
    public static final String PROP_CHANNEL_DESCRIPTION = "jspwiki.rss.channelDescription";
    public static final String PROP_CHANNEL_LANGUAGE = "jspwiki.rss.channelLanguage";
    public static final String PROP_CHANNEL_TITLE = "jspwiki.rss.channelTitle";
    public static final String PROP_GENERATE_RSS = "jspwiki.rss.generate";
    public static final String PROP_RSSFILE = "jspwiki.rss.fileName";
    public static final String PROP_INTERVAL = "jspwiki.rss.interval";
    public static final String PROP_RSS_AUTHOR = "jspwiki.rss.author";
    public static final String PROP_RSS_AUTHOREMAIL = "jspwiki.rss.author.email";

    public String generate();

    public String generateFeed(Context var1, List<Page> var2, String var3, String var4) throws IllegalArgumentException;

    public boolean isEnabled();

    public void setEnabled(boolean var1);

    public String getRssFile();

    public String generateFullWikiRSS(Context var1, Feed var2);

    public String generateWikiPageRSS(Context var1, List<Page> var2, Feed var3);

    public String generateBlogRSS(Context var1, List<Page> var2, Feed var3);

    public static String format(String s) {
        s = TextUtil.replaceString((String)s, (String)"&", (String)"&amp;");
        s = TextUtil.replaceString((String)s, (String)"<", (String)"&lt;");
        s = TextUtil.replaceString((String)s, (String)"]]>", (String)"]]&gt;");
        return s.trim();
    }

    public static String getContentType(String mode) {
        if (mode.equals(RSS10) || mode.equals(RSS20)) {
            return "application/rss+xml";
        }
        if (mode.equals(ATOM)) {
            return "application/atom+xml";
        }
        return "application/octet-stream";
    }
}

