/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.tck;

import java.util.List;
import org.apache.juddi.jaxb.EntityCreator;
import org.apache.juddi.v3.tck.TckValidator;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.uddi.api_v3.BindingDetail;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.DeleteBinding;
import org.uddi.api_v3.GetBindingDetail;
import org.uddi.api_v3.SaveBinding;
import org.uddi.v3_service.UDDIInquiryPortType;
import org.uddi.v3_service.UDDIPublicationPortType;

public class TckBindingTemplate {
    static final String JOE_BINDING_XML = "uddi_data/joepublisher/bindingTemplate.xml";
    static final String JOE_BINDING_KEY = "uddi:uddi.joepublisher.com:bindingtwo";
    private Logger logger = Logger.getLogger(this.getClass());
    private UDDIPublicationPortType publication = null;
    private UDDIInquiryPortType inquiry = null;

    public TckBindingTemplate(UDDIPublicationPortType publication, UDDIInquiryPortType inquiry) {
        this.publication = publication;
        this.inquiry = inquiry;
    }

    public void saveJoePublisherBinding(String authInfoJoe) {
        this.saveBinding(authInfoJoe, JOE_BINDING_XML, JOE_BINDING_KEY);
    }

    public void deleteJoePublisherBinding(String authInfoJoe) {
        this.deleteBinding(authInfoJoe, JOE_BINDING_KEY);
    }

    private void saveBinding(String authInfo, String bindingXML, String bindingKey) {
        try {
            SaveBinding sb = new SaveBinding();
            sb.setAuthInfo(authInfo);
            BindingTemplate btIn = (BindingTemplate)EntityCreator.buildFromDoc((String)bindingXML, (String)"org.uddi.api_v3");
            sb.getBindingTemplate().add(btIn);
            this.publication.saveBinding(sb);
            GetBindingDetail gb = new GetBindingDetail();
            gb.getBindingKey().add(bindingKey);
            BindingDetail bd = this.inquiry.getBindingDetail(gb);
            List btOutList = bd.getBindingTemplate();
            BindingTemplate btOut = (BindingTemplate)btOutList.get(0);
            junit.framework.Assert.assertEquals((String)btIn.getServiceKey(), (String)btOut.getServiceKey());
            junit.framework.Assert.assertEquals((String)btIn.getBindingKey(), (String)btOut.getBindingKey());
            TckValidator.checkDescriptions(btIn.getDescription(), btOut.getDescription());
            TckValidator.checkCategories(btIn.getCategoryBag(), btOut.getCategoryBag());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)("No exception should be thrown: " + e.getMessage()));
        }
    }

    private void deleteBinding(String authInfo, String bindingKey) {
        try {
            DeleteBinding db = new DeleteBinding();
            db.setAuthInfo(authInfo);
            db.getBindingKey().add(bindingKey);
            this.publication.deleteBinding(db);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown.");
        }
    }
}

