/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.tck;

import java.util.List;
import org.apache.juddi.jaxb.EntityCreator;
import org.apache.juddi.v3.tck.TckValidator;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.DeleteBusiness;
import org.uddi.api_v3.GetBusinessDetail;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.SaveBusiness;
import org.uddi.v3_service.UDDIInquiryPortType;
import org.uddi.v3_service.UDDIPublicationPortType;

public class TckBusiness {
    static final String JOE_BUSINESS_XML = "uddi_data/joepublisher/businessEntity.xml";
    static final String JOE_BUSINESS_KEY = "uddi:uddi.joepublisher.com:businessone";
    static final String SAM_BUSINESS_XML = "uddi_data/samsyndicator/businessEntity.xml";
    static final String SAM_BUSINESS_WITHPROJECTION_XML = "uddi_data/samsyndicator/businessEntity_withProjection.xml";
    static final String SAM_BUSINESS_KEY = "uddi:www.samco.com:samco";
    private Logger logger = Logger.getLogger(this.getClass());
    private UDDIPublicationPortType publication = null;
    private UDDIInquiryPortType inquiry = null;

    public TckBusiness(UDDIPublicationPortType publication, UDDIInquiryPortType inquiry) {
        this.publication = publication;
        this.inquiry = inquiry;
    }

    public void saveSamSyndicatorBusiness(String authInfoSam) {
        this.saveBusiness(authInfoSam, SAM_BUSINESS_XML, SAM_BUSINESS_KEY);
    }

    public void saveSamSyndicatorBusinesses(String authInfoSam, int numberOfCopies) {
        this.saveBusinesses(authInfoSam, SAM_BUSINESS_XML, SAM_BUSINESS_KEY, numberOfCopies);
    }

    public void saveSamSyndicatorBusinessWithProjection(String authInfoSam) {
        this.saveBusiness(authInfoSam, SAM_BUSINESS_WITHPROJECTION_XML, SAM_BUSINESS_KEY);
    }

    public void deleteSamSyndicatorBusiness(String authInfoSam) {
        this.deleteBusiness(authInfoSam, SAM_BUSINESS_XML, SAM_BUSINESS_KEY);
    }

    public void deleteSamSyndicatorBusinesses(String authInfoSam, int numberOfCopies) {
        this.deleteBusinesses(authInfoSam, SAM_BUSINESS_XML, SAM_BUSINESS_KEY, numberOfCopies);
    }

    public void saveJoePublisherBusiness(String authInfoJoe) {
        this.saveBusiness(authInfoJoe, JOE_BUSINESS_XML, JOE_BUSINESS_KEY);
    }

    public void saveJoePublisherBusinesses(String authInfoJoe, int numberOfCopies) {
        this.saveBusinesses(authInfoJoe, JOE_BUSINESS_XML, JOE_BUSINESS_KEY, numberOfCopies);
    }

    public void deleteJoePublisherBusiness(String authInfoJoe) {
        this.deleteBusiness(authInfoJoe, JOE_BUSINESS_XML, JOE_BUSINESS_KEY);
    }

    public void deleteJoePublisherBusinesses(String authInfoJoe, int numberOfCopies) {
        this.deleteBusinesses(authInfoJoe, JOE_BUSINESS_XML, JOE_BUSINESS_KEY, numberOfCopies);
    }

    private void saveBusinesses(String authInfo, String businessXML, String businessKey, int numberOfCopies) {
        try {
            BusinessEntity beIn = (BusinessEntity)EntityCreator.buildFromDoc((String)businessXML, (String)"org.uddi.api_v3");
            String businessName = ((Name)beIn.getName().get(0)).getValue();
            for (int i = 0; i < numberOfCopies; ++i) {
                SaveBusiness sb = new SaveBusiness();
                sb.setAuthInfo(authInfo);
                ((Name)beIn.getName().get(0)).setValue(businessName + "-" + i);
                beIn.setBusinessKey(businessKey + "-" + i);
                sb.getBusinessEntity().add(beIn);
                this.publication.saveBusiness(sb);
                this.logger.debug((Object)("Saved business with key " + businessName + "-" + i));
            }
        }
        catch (Throwable e) {
            this.logger.error((Object)e.getMessage(), e);
            Assert.fail((String)"No exception should be thrown");
        }
    }

    private void saveBusiness(String authInfo, String businessXML, String businessKey) {
        try {
            SaveBusiness sb = new SaveBusiness();
            sb.setAuthInfo(authInfo);
            BusinessEntity beIn = (BusinessEntity)EntityCreator.buildFromDoc((String)businessXML, (String)"org.uddi.api_v3");
            sb.getBusinessEntity().add(beIn);
            this.publication.saveBusiness(sb);
            GetBusinessDetail gb = new GetBusinessDetail();
            gb.getBusinessKey().add(businessKey);
            BusinessDetail bd = this.inquiry.getBusinessDetail(gb);
            List beOutList = bd.getBusinessEntity();
            BusinessEntity beOut = (BusinessEntity)beOutList.get(0);
            junit.framework.Assert.assertEquals((String)beIn.getBusinessKey(), (String)beOut.getBusinessKey());
            TckValidator.checkNames(beIn.getName(), beOut.getName());
            TckValidator.checkDescriptions(beIn.getDescription(), beOut.getDescription());
            TckValidator.checkDiscoveryUrls(beIn.getDiscoveryURLs(), beOut.getDiscoveryURLs());
            TckValidator.checkContacts(beIn.getContacts(), beOut.getContacts());
            TckValidator.checkCategories(beIn.getCategoryBag(), beOut.getCategoryBag());
        }
        catch (Throwable e) {
            this.logger.error((Object)e.getMessage(), e);
            Assert.fail((String)"No exception should be thrown");
        }
    }

    private void deleteBusinesses(String authInfo, String businessXML, String businessKey, int numberOfCopies) {
        try {
            for (int i = 0; i < numberOfCopies; ++i) {
                String key = businessKey + "-" + i;
                DeleteBusiness db = new DeleteBusiness();
                db.setAuthInfo(authInfo);
                db.getBusinessKey().add(key);
                this.publication.deleteBusiness(db);
                this.logger.debug((Object)("Deleted business with key " + key));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown");
        }
    }

    private void deleteBusiness(String authInfo, String businessXML, String businessKey) {
        try {
            DeleteBusiness db = new DeleteBusiness();
            db.setAuthInfo(authInfo);
            db.getBusinessKey().add(businessKey);
            this.publication.deleteBusiness(db);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown");
        }
    }
}

