/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.tck;

import java.util.List;
import org.apache.juddi.jaxb.EntityCreator;
import org.apache.juddi.v3.tck.TckValidator;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.DeleteService;
import org.uddi.api_v3.GetServiceDetail;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.SaveService;
import org.uddi.api_v3.ServiceDetail;
import org.uddi.v3_service.UDDIInquiryPortType;
import org.uddi.v3_service.UDDIPublicationPortType;

public class TckBusinessService {
    public static final String NOTIFIER_SERVICE_XML = "uddi_data/subscriptionnotifier/businessService.xml";
    public static final String NOTIFIER_SERVICE_KEY = "uddi:uddi.joepublisher.com:notifierone";
    static final String JOE_SERVICE_XML = "uddi_data/joepublisher/businessService.xml";
    static final String JOE_SERVICE_KEY = "uddi:uddi.joepublisher.com:serviceone";
    static final String SAM_SERVICE_XML = "uddi_data/samsyndicator/businessService.xml";
    static final String SAM_SERVICE_KEY = "uddi:www.samco.com:listingservice";
    private Logger logger = Logger.getLogger(this.getClass());
    private UDDIPublicationPortType publication = null;
    private UDDIInquiryPortType inquiry = null;

    public TckBusinessService(UDDIPublicationPortType publication, UDDIInquiryPortType inquiry) {
        this.publication = publication;
        this.inquiry = inquiry;
    }

    public void saveJoePublisherService(String authInfoJoe) {
        this.saveService(authInfoJoe, JOE_SERVICE_XML, JOE_SERVICE_KEY);
    }

    public void saveJoePublisherServices(String authInfoJoe, int numberOfCopies) {
        this.saveServices(authInfoJoe, JOE_SERVICE_XML, JOE_SERVICE_KEY, numberOfCopies);
    }

    public void deleteJoePublisherService(String authInfoJoe) {
        this.deleteService(authInfoJoe, JOE_SERVICE_KEY);
    }

    public void saveNotifierService(String authInfoJoe) {
        this.saveService(authInfoJoe, NOTIFIER_SERVICE_XML, NOTIFIER_SERVICE_KEY);
    }

    public void deleteNotifierService(String authInfoJoe) {
        this.deleteService(authInfoJoe, NOTIFIER_SERVICE_KEY);
    }

    public void deleteJoePublisherServices(String authInfoJoe, int numberOfCopies) {
        this.deleteServices(authInfoJoe, JOE_SERVICE_KEY, numberOfCopies);
    }

    public void saveSamSyndicatorService(String authInfoSam) {
        this.saveService(authInfoSam, SAM_SERVICE_XML, SAM_SERVICE_KEY);
    }

    public void saveSamSyndicatorServices(String authInfoSam, int numberOfCopies) {
        this.saveServices(authInfoSam, SAM_SERVICE_XML, SAM_SERVICE_KEY, numberOfCopies);
    }

    public void deleteSamSyndicatorService(String authInfoSam) {
        this.deleteService(authInfoSam, SAM_SERVICE_KEY);
    }

    public void deleteSamSyndicatorServices(String authInfoSam, int numberOfCopies) {
        this.deleteServices(authInfoSam, SAM_SERVICE_KEY, numberOfCopies);
    }

    private void saveServices(String authInfo, String serviceXML, String serviceKey, int numberOfCopies) {
        try {
            BusinessService bsIn = (BusinessService)EntityCreator.buildFromDoc((String)serviceXML, (String)"org.uddi.api_v3");
            String serviceName = ((Name)bsIn.getName().get(0)).getValue();
            String bindingKey = ((BindingTemplate)bsIn.getBindingTemplates().getBindingTemplate().get(0)).getBindingKey();
            for (int i = 0; i < numberOfCopies; ++i) {
                SaveService ss = new SaveService();
                ss.setAuthInfo(authInfo);
                ((Name)bsIn.getName().get(0)).setValue(serviceName + "-" + i);
                bsIn.setServiceKey(serviceKey + "-" + i);
                ((BindingTemplate)bsIn.getBindingTemplates().getBindingTemplate().get(0)).setBindingKey(bindingKey + "-" + i);
                ss.getBusinessService().add(bsIn);
                this.publication.saveService(ss);
                this.logger.debug((Object)("Add service with key " + bsIn.getServiceKey()));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown.");
        }
    }

    private void saveService(String authInfo, String serviceXML, String serviceKey) {
        try {
            SaveService ss = new SaveService();
            ss.setAuthInfo(authInfo);
            BusinessService bsIn = (BusinessService)EntityCreator.buildFromDoc((String)serviceXML, (String)"org.uddi.api_v3");
            ss.getBusinessService().add(bsIn);
            this.publication.saveService(ss);
            GetServiceDetail gs = new GetServiceDetail();
            gs.getServiceKey().add(serviceKey);
            ServiceDetail sd = this.inquiry.getServiceDetail(gs);
            List bsOutList = sd.getBusinessService();
            BusinessService bsOut = (BusinessService)bsOutList.get(0);
            junit.framework.Assert.assertEquals((String)bsIn.getServiceKey(), (String)bsOut.getServiceKey());
            TckValidator.checkNames(bsIn.getName(), bsOut.getName());
            TckValidator.checkDescriptions(bsIn.getDescription(), bsOut.getDescription());
            TckValidator.checkBindingTemplates(bsIn.getBindingTemplates(), bsOut.getBindingTemplates());
            TckValidator.checkCategories(bsIn.getCategoryBag(), bsOut.getCategoryBag());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown.");
        }
    }

    private void deleteService(String authInfo, String serviceKey) {
        try {
            DeleteService ds = new DeleteService();
            ds.setAuthInfo(authInfo);
            ds.getServiceKey().add(serviceKey);
            this.publication.deleteService(ds);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown.");
        }
    }

    private void deleteServices(String authInfo, String serviceKey, int numberOfCopies) {
        try {
            for (int i = 0; i < numberOfCopies; ++i) {
                DeleteService ds = new DeleteService();
                ds.setAuthInfo(authInfo);
                ds.getServiceKey().add(serviceKey + "-" + i);
                this.publication.deleteService(ds);
                this.logger.debug((Object)("Deleted Service with key " + serviceKey + "-" + i));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown.");
        }
    }
}

