/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.tck;

import java.util.List;
import org.apache.juddi.jaxb.EntityCreator;
import org.apache.juddi.v3.tck.TckValidator;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.uddi.api_v3.BindingDetail;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.BusinessInfo;
import org.uddi.api_v3.BusinessInfos;
import org.uddi.api_v3.BusinessList;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.FindBinding;
import org.uddi.api_v3.FindBusiness;
import org.uddi.api_v3.FindService;
import org.uddi.api_v3.FindTModel;
import org.uddi.api_v3.ServiceInfo;
import org.uddi.api_v3.ServiceInfos;
import org.uddi.api_v3.ServiceList;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3.TModelInfo;
import org.uddi.api_v3.TModelInfos;
import org.uddi.api_v3.TModelList;
import org.uddi.v3_service.UDDIInquiryPortType;

public class TckFindEntity {
    static final String FIND_BUSINESS_XML = "uddi_data/find/findBusiness1.xml";
    static final String FIND_ALL_BUSINESSES_XML = "uddi_data/find/findAllBusinesses.xml";
    static final String FIND_SERVICE_XML = "uddi_data/find/findService1.xml";
    static final String FIND_BINDING_XML = "uddi_data/find/findBinding1.xml";
    static final String FIND_TMODEL_XML = "uddi_data/find/findTModel1.xml";
    private Logger logger = Logger.getLogger(this.getClass());
    UDDIInquiryPortType inquiry = null;

    public TckFindEntity(UDDIInquiryPortType inquiry) {
        this.inquiry = inquiry;
    }

    public void findBusiness() {
        try {
            List biList;
            BusinessInfos bInfos;
            FindBusiness body = (FindBusiness)EntityCreator.buildFromDoc((String)FIND_BUSINESS_XML, (String)"org.uddi.api_v3");
            BusinessList result = this.inquiry.findBusiness(body);
            if (result == null) {
                Assert.fail((String)"Null result from find business operation");
            }
            if ((bInfos = result.getBusinessInfos()) == null) {
                Assert.fail((String)"No result from find business operation");
            }
            if ((biList = bInfos.getBusinessInfo()) == null || biList.size() == 0) {
                Assert.fail((String)"No result from find business operation");
            }
            BusinessInfo biOut = (BusinessInfo)biList.get(0);
            BusinessEntity beIn = (BusinessEntity)EntityCreator.buildFromDoc((String)"uddi_data/joepublisher/businessEntity.xml", (String)"org.uddi.api_v3");
            junit.framework.Assert.assertEquals((String)beIn.getBusinessKey(), (String)biOut.getBusinessKey());
            TckValidator.checkNames(beIn.getName(), biOut.getName());
            TckValidator.checkDescriptions(beIn.getDescription(), biOut.getDescription());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown.");
        }
    }

    public void findAllBusiness() {
        try {
            List biList;
            BusinessInfos bInfos;
            FindBusiness body = (FindBusiness)EntityCreator.buildFromDoc((String)FIND_ALL_BUSINESSES_XML, (String)"org.uddi.api_v3");
            BusinessList result = this.inquiry.findBusiness(body);
            if (result == null) {
                Assert.fail((String)"Null result from find business operation");
            }
            if ((bInfos = result.getBusinessInfos()) == null) {
                Assert.fail((String)"No result from find business operation");
            }
            if ((biList = bInfos.getBusinessInfo()) == null || biList.size() == 0) {
                Assert.fail((String)"No result from find business operation");
            }
            Assert.assertTrue((biList.size() > 1 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown.");
        }
    }

    public void findService() {
        try {
            List siList;
            ServiceInfos sInfos;
            FindService body = (FindService)EntityCreator.buildFromDoc((String)FIND_SERVICE_XML, (String)"org.uddi.api_v3");
            ServiceList result = this.inquiry.findService(body);
            if (result == null) {
                Assert.fail((String)"Null result from find service operation");
            }
            if ((sInfos = result.getServiceInfos()) == null) {
                Assert.fail((String)"No result from find service operation");
            }
            if ((siList = sInfos.getServiceInfo()) == null || siList.size() == 0) {
                Assert.fail((String)"No result from find service operation");
            }
            ServiceInfo siOut = (ServiceInfo)siList.get(0);
            BusinessService bsIn = (BusinessService)EntityCreator.buildFromDoc((String)"uddi_data/joepublisher/businessService.xml", (String)"org.uddi.api_v3");
            junit.framework.Assert.assertEquals((String)bsIn.getServiceKey(), (String)siOut.getServiceKey());
            TckValidator.checkNames(bsIn.getName(), siOut.getName());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown.");
        }
    }

    public void findBinding() {
        try {
            List btList;
            FindBinding body = (FindBinding)EntityCreator.buildFromDoc((String)FIND_BINDING_XML, (String)"org.uddi.api_v3");
            BindingDetail result = this.inquiry.findBinding(body);
            if (result == null) {
                Assert.fail((String)"Null result from find binding operation");
            }
            if ((btList = result.getBindingTemplate()) == null || btList.size() == 0) {
                Assert.fail((String)"No result from find binding operation");
            }
            BindingTemplate btOut = (BindingTemplate)btList.get(0);
            BindingTemplate btIn = (BindingTemplate)EntityCreator.buildFromDoc((String)"uddi_data/joepublisher/bindingTemplate.xml", (String)"org.uddi.api_v3");
            junit.framework.Assert.assertEquals((String)btIn.getServiceKey(), (String)btOut.getServiceKey());
            junit.framework.Assert.assertEquals((String)btIn.getBindingKey(), (String)btOut.getBindingKey());
            TckValidator.checkDescriptions(btIn.getDescription(), btOut.getDescription());
            TckValidator.checkCategories(btIn.getCategoryBag(), btOut.getCategoryBag());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)("No exception should be thrown:  " + e.getMessage()));
        }
    }

    public void findTModel() {
        try {
            List tiList;
            TModelInfos tInfos;
            FindTModel body = (FindTModel)EntityCreator.buildFromDoc((String)FIND_TMODEL_XML, (String)"org.uddi.api_v3");
            TModelList result = this.inquiry.findTModel(body);
            if (result == null) {
                Assert.fail((String)"Null result from find tModel operation");
            }
            if ((tInfos = result.getTModelInfos()) == null) {
                Assert.fail((String)"No result from find tModel operation");
            }
            if ((tiList = tInfos.getTModelInfo()) == null || tiList.size() == 0) {
                Assert.fail((String)"No result from find tModel operation");
            }
            TModelInfo tiOut = (TModelInfo)tiList.get(0);
            TModel tmIn = (TModel)EntityCreator.buildFromDoc((String)"uddi_data/joepublisher/tModelKeyGen.xml", (String)"org.uddi.api_v3");
            junit.framework.Assert.assertEquals((String)tmIn.getTModelKey(), (String)tiOut.getTModelKey());
            junit.framework.Assert.assertEquals((String)tmIn.getName().getLang(), (String)tiOut.getName().getLang());
            junit.framework.Assert.assertEquals((String)tmIn.getName().getValue(), (String)tiOut.getName().getValue());
            TckValidator.checkDescriptions(tmIn.getDescription(), tiOut.getDescription());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown.");
        }
    }
}

