/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.tck;

import java.util.List;
import org.apache.juddi.jaxb.EntityCreator;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.uddi.api_v3.AddPublisherAssertions;
import org.uddi.api_v3.DeletePublisherAssertions;
import org.uddi.api_v3.KeyedReference;
import org.uddi.api_v3.PublisherAssertion;
import org.uddi.v3_service.UDDIPublicationPortType;

public class TckPublisherAssertion {
    static final String JOE_ASSERT_XML = "uddi_data/joepublisher/publisherAssertion.xml";
    private Logger logger = Logger.getLogger(this.getClass());
    private UDDIPublicationPortType publication = null;

    public TckPublisherAssertion(UDDIPublicationPortType publication) {
        this.publication = publication;
    }

    public void saveJoePublisherPublisherAssertion(String authInfoJoe) {
        this.addPublisherAssertion(authInfoJoe, JOE_ASSERT_XML);
    }

    public void deleteJoePublisherPublisherAssertion(String authInfoJoe) {
        this.deletePublisherAssertion(authInfoJoe, JOE_ASSERT_XML);
    }

    private void addPublisherAssertion(String authInfo, String pubassertXML) {
        try {
            AddPublisherAssertions ap = new AddPublisherAssertions();
            ap.setAuthInfo(authInfo);
            PublisherAssertion paIn = (PublisherAssertion)EntityCreator.buildFromDoc((String)pubassertXML, (String)"org.uddi.api_v3");
            ap.getPublisherAssertion().add(paIn);
            this.publication.addPublisherAssertions(ap);
            List paOutList = this.publication.getPublisherAssertions(authInfo);
            PublisherAssertion paOut = (PublisherAssertion)paOutList.get(0);
            junit.framework.Assert.assertEquals((String)paIn.getFromKey(), (String)paOut.getFromKey());
            junit.framework.Assert.assertEquals((String)paIn.getToKey(), (String)paOut.getToKey());
            KeyedReference keyRefIn = paIn.getKeyedReference();
            KeyedReference keyRefOut = paOut.getKeyedReference();
            junit.framework.Assert.assertEquals((String)keyRefIn.getTModelKey(), (String)keyRefOut.getTModelKey());
            junit.framework.Assert.assertEquals((String)keyRefIn.getKeyName(), (String)keyRefOut.getKeyName());
            junit.framework.Assert.assertEquals((String)keyRefIn.getKeyValue(), (String)keyRefOut.getKeyValue());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown");
        }
    }

    private void deletePublisherAssertion(String authInfo, String pubassertXML) {
        try {
            DeletePublisherAssertions dp = new DeletePublisherAssertions();
            dp.setAuthInfo(authInfo);
            PublisherAssertion paIn = (PublisherAssertion)EntityCreator.buildFromDoc((String)pubassertXML, (String)"org.uddi.api_v3");
            dp.getPublisherAssertion().add(paIn);
            this.publication.deletePublisherAssertions(dp);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown");
        }
    }
}

