/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.tck;

import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.Holder;
import org.apache.juddi.jaxb.EntityCreator;
import org.apache.juddi.v3.tck.TckValidator;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.ServiceInfo;
import org.uddi.api_v3.ServiceInfos;
import org.uddi.api_v3.TModelDetail;
import org.uddi.api_v3.TModelList;
import org.uddi.sub_v3.DeleteSubscription;
import org.uddi.sub_v3.GetSubscriptionResults;
import org.uddi.sub_v3.KeyBag;
import org.uddi.sub_v3.Subscription;
import org.uddi.sub_v3.SubscriptionResultsList;
import org.uddi.v3_service.UDDISecurityPortType;
import org.uddi.v3_service.UDDISubscriptionPortType;

public class TckSubscription {
    static final String JOE_SUBSCRIPTION_XML = "uddi_data/subscription/subscription1.xml";
    static final String JOE_SUBSCRIPTION_KEY = "uddi:uddi.joepublisher.com:subscriptionone";
    static final String JOE_SUBSCRIPTIONRESULTS_XML = "uddi_data/subscription/subscriptionresults1.xml";
    static final String SAM_SUBSCRIPTION_XML = "uddi_data/subscription/subscription2.xml";
    static final String SAM_SUBSCRIPTION_KEY = "uddi:www.samco.com:subscriptionone";
    static final String SAM_SUBSCRIPTIONRESULTS_XML = "uddi_data/subscription/subscriptionresults2.xml";
    static final String SAM_DUMMYBUSINESSKEY = "uddi:www.this.key.doesnot.exist";
    static final String SAM_SUBSCRIPTION2_XML = "uddi_data/subscription/subscription3.xml";
    static final String SAM_SUBSCRIPTION2_KEY = "uddi:www.samco.com:subscriptiontwo";
    static final String SAM_SUBSCRIPTIONRESULTS2_XML = "uddi_data/subscription/subscriptionresults3.xml";
    static final int FINDQUALIFIER_TMODEL_TOTAL = 22;
    static final String SAM_SUBSCRIPTION3_XML = "uddi_data/subscription/subscription4.xml";
    static final String SAM_SUBSCRIPTION3_KEY = "uddi:www.samco.com:subscriptionthree";
    static final String SAM_SUBSCRIPTIONRESULTS3_XML = "uddi_data/subscription/subscriptionresults4.xml";
    private Logger logger = Logger.getLogger(this.getClass());
    UDDISubscriptionPortType subscription = null;
    UDDISecurityPortType security = null;

    public TckSubscription(UDDISubscriptionPortType subscription, UDDISecurityPortType security) {
        this.subscription = subscription;
        this.security = security;
    }

    public void saveJoePublisherSubscription(String authInfoJoe, String subscriptionXML, String subscriptionKey) {
        this.saveSubscription(authInfoJoe, subscriptionXML, subscriptionKey);
    }

    public void saveJoePublisherSubscription(String authInfoJoe) {
        this.saveSubscription(authInfoJoe, JOE_SUBSCRIPTION_XML, JOE_SUBSCRIPTION_KEY);
    }

    public void deleteJoePublisherSubscription(String authInfoJoe) {
        this.deleteSubscription(authInfoJoe, JOE_SUBSCRIPTION_KEY);
    }

    public void getJoePublisherSubscriptionResults(String authInfoJoe) {
        try {
            List siList;
            ServiceInfos sInfos;
            GetSubscriptionResults getSubResultsIn = (GetSubscriptionResults)EntityCreator.buildFromDoc((String)JOE_SUBSCRIPTIONRESULTS_XML, (String)"org.uddi.sub_v3");
            getSubResultsIn.setAuthInfo(authInfoJoe);
            SubscriptionResultsList result = this.subscription.getSubscriptionResults(getSubResultsIn);
            if (result == null) {
                Assert.fail((String)"Null result from getSubscriptionResults operation");
            }
            if ((sInfos = result.getServiceList().getServiceInfos()) == null) {
                Assert.fail((String)"No result from getSubscriptionResults operation");
            }
            if ((siList = sInfos.getServiceInfo()) == null || siList.size() == 0) {
                Assert.fail((String)"No result from getSubscriptionResults operation");
            }
            ServiceInfo siOut = (ServiceInfo)siList.get(0);
            BusinessService bsIn = (BusinessService)EntityCreator.buildFromDoc((String)"uddi_data/joepublisher/businessService.xml", (String)"org.uddi.api_v3");
            junit.framework.Assert.assertEquals((String)bsIn.getServiceKey(), (String)siOut.getServiceKey());
            TckValidator.checkNames(bsIn.getName(), siOut.getName());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown");
        }
    }

    public void saveSamSyndicatorSubscription(String authInfoSam) {
        this.saveSubscription(authInfoSam, SAM_SUBSCRIPTION_XML, SAM_SUBSCRIPTION_KEY);
    }

    public void saveSamSyndicatorSubscriptionWithChunkingOnFind(String authInfoSam) {
        this.saveSubscription(authInfoSam, SAM_SUBSCRIPTION2_XML, SAM_SUBSCRIPTION2_KEY);
    }

    public void saveSamSyndicatorSubscriptionWithChunkingOnGet(String authInfoSam) {
        this.saveSubscription(authInfoSam, SAM_SUBSCRIPTION3_XML, SAM_SUBSCRIPTION3_KEY);
    }

    public void deleteSamSyndicatorSubscription(String authInfoSam) {
        this.deleteSubscription(authInfoSam, SAM_SUBSCRIPTION_KEY);
    }

    public void deleteSamSyndicatorSubscriptionWithChunkingOnFind(String authInfoSam) {
        this.deleteSubscription(authInfoSam, SAM_SUBSCRIPTION2_KEY);
    }

    public void deleteSamSyndicatorSubscriptionWithChunkingOnGet(String authInfoSam) {
        this.deleteSubscription(authInfoSam, SAM_SUBSCRIPTION3_KEY);
    }

    public void getSamSyndicatorSubscriptionResults(String authInfoSam) {
        try {
            List beList;
            BusinessDetail busDetail;
            GetSubscriptionResults getSubResultsIn = (GetSubscriptionResults)EntityCreator.buildFromDoc((String)SAM_SUBSCRIPTIONRESULTS_XML, (String)"org.uddi.sub_v3");
            getSubResultsIn.setAuthInfo(authInfoSam);
            SubscriptionResultsList result = this.subscription.getSubscriptionResults(getSubResultsIn);
            if (result == null) {
                Assert.fail((String)"Null result from getSubscriptionResults operation");
            }
            if ((busDetail = result.getBusinessDetail()) == null) {
                Assert.fail((String)"No result from getSubscriptionResults operation");
            }
            if ((beList = busDetail.getBusinessEntity()) == null || beList.size() == 0) {
                Assert.fail((String)"No result from getSubscriptionResults operation");
            }
            BusinessEntity beOut = (BusinessEntity)beList.get(0);
            BusinessEntity beIn = (BusinessEntity)EntityCreator.buildFromDoc((String)"uddi_data/samsyndicator/businessEntity.xml", (String)"org.uddi.api_v3");
            junit.framework.Assert.assertEquals((String)beIn.getBusinessKey(), (String)beOut.getBusinessKey());
            TckValidator.checkNames(beIn.getName(), beOut.getName());
            TckValidator.checkDescriptions(beIn.getDescription(), beOut.getDescription());
            TckValidator.checkDiscoveryUrls(beIn.getDiscoveryURLs(), beOut.getDiscoveryURLs());
            TckValidator.checkContacts(beIn.getContacts(), beOut.getContacts());
            TckValidator.checkCategories(beIn.getCategoryBag(), beOut.getCategoryBag());
            List keyBagList = result.getKeyBag();
            if (keyBagList == null || keyBagList.size() == 0) {
                Assert.fail((String)"No keyBag from SamSyndicator getSubscriptionResults operation");
            }
            KeyBag keyBag = (KeyBag)keyBagList.get(0);
            junit.framework.Assert.assertEquals((String)SAM_DUMMYBUSINESSKEY, (String)((String)keyBag.getBusinessKey().get(0)));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown");
        }
    }

    public void getSamSyndicatorSubscriptionResultsWithChunkingOnFind(String authInfoSam) {
        try {
            GetSubscriptionResults getSubResultsIn = (GetSubscriptionResults)EntityCreator.buildFromDoc((String)SAM_SUBSCRIPTIONRESULTS2_XML, (String)"org.uddi.sub_v3");
            getSubResultsIn.setAuthInfo(authInfoSam);
            Subscription subIn = (Subscription)EntityCreator.buildFromDoc((String)SAM_SUBSCRIPTION2_XML, (String)"org.uddi.sub_v3");
            int expectedIterations = 22 / subIn.getMaxEntities();
            if (22 % subIn.getMaxEntities() > 0) {
                ++expectedIterations;
            }
            String chunkToken = "";
            int iterations = 0;
            while (chunkToken != null) {
                TModelList tmodelList;
                ++iterations;
                getSubResultsIn.setChunkToken(chunkToken);
                SubscriptionResultsList result = this.subscription.getSubscriptionResults(getSubResultsIn);
                if (result == null) {
                    Assert.fail((String)"Null result from getSubscriptionResults operation");
                }
                if ((tmodelList = result.getTModelList()) == null) {
                    Assert.fail((String)("No result from getSubscriptionResults operation on chunk attempt " + iterations));
                }
                int resultSize = tmodelList.getTModelInfos().getTModelInfo().size();
                if (iterations < expectedIterations) {
                    junit.framework.Assert.assertEquals((int)resultSize, (int)subIn.getMaxEntities());
                } else if (22 % subIn.getMaxEntities() > 0) {
                    junit.framework.Assert.assertEquals((int)resultSize, (int)(22 % subIn.getMaxEntities()));
                } else {
                    junit.framework.Assert.assertEquals((int)resultSize, (int)subIn.getMaxEntities());
                }
                chunkToken = result.getChunkToken();
            }
            junit.framework.Assert.assertEquals((int)iterations, (int)expectedIterations);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown");
        }
    }

    public void getSamSyndicatorSubscriptionResultsWithChunkingOnGet(String authInfoSam) {
        try {
            GetSubscriptionResults getSubResultsIn = (GetSubscriptionResults)EntityCreator.buildFromDoc((String)SAM_SUBSCRIPTIONRESULTS3_XML, (String)"org.uddi.sub_v3");
            getSubResultsIn.setAuthInfo(authInfoSam);
            Subscription subIn = (Subscription)EntityCreator.buildFromDoc((String)SAM_SUBSCRIPTION3_XML, (String)"org.uddi.sub_v3");
            int expectedIterations = 22 / subIn.getMaxEntities();
            if (22 % subIn.getMaxEntities() > 0) {
                ++expectedIterations;
            }
            String chunkToken = "";
            int iterations = 0;
            while (chunkToken != null) {
                TModelDetail tmodelDetail;
                ++iterations;
                getSubResultsIn.setChunkToken(chunkToken);
                SubscriptionResultsList result = this.subscription.getSubscriptionResults(getSubResultsIn);
                if (result == null) {
                    Assert.fail((String)"Null result from getSubscriptionResults operation");
                }
                if ((tmodelDetail = result.getTModelDetail()) == null) {
                    Assert.fail((String)("No result from getSubscriptionResults operation on chunk attempt " + iterations));
                }
                int resultSize = tmodelDetail.getTModel().size();
                if (iterations < expectedIterations) {
                    junit.framework.Assert.assertEquals((int)resultSize, (int)subIn.getMaxEntities());
                } else if (22 % subIn.getMaxEntities() > 0) {
                    junit.framework.Assert.assertEquals((int)resultSize, (int)(22 % subIn.getMaxEntities()));
                } else {
                    junit.framework.Assert.assertEquals((int)resultSize, (int)subIn.getMaxEntities());
                }
                chunkToken = result.getChunkToken();
            }
            junit.framework.Assert.assertEquals((int)iterations, (int)expectedIterations);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown");
        }
    }

    private void saveSubscription(String authInfo, String subscriptionXML, String subscriptionKey) {
        try {
            Subscription subIn = (Subscription)EntityCreator.buildFromDoc((String)subscriptionXML, (String)"org.uddi.sub_v3");
            ArrayList<Subscription> subscriptionList = new ArrayList<Subscription>();
            subscriptionList.add(subIn);
            Holder subscriptionHolder = new Holder();
            subscriptionHolder.value = subscriptionList;
            this.subscription.saveSubscription(authInfo, subscriptionHolder);
            Subscription subDirectOut = (Subscription)((List)subscriptionHolder.value).get(0);
            junit.framework.Assert.assertEquals((String)subIn.getSubscriptionKey(), (String)subDirectOut.getSubscriptionKey());
            List outSubscriptionList = this.subscription.getSubscriptions(authInfo);
            Assert.assertNotNull((Object)outSubscriptionList);
            Subscription subOut = (Subscription)outSubscriptionList.get(0);
            junit.framework.Assert.assertEquals((String)subIn.getSubscriptionKey(), (String)subOut.getSubscriptionKey());
            junit.framework.Assert.assertEquals((int)subDirectOut.getExpiresAfter().getMonth(), (int)subOut.getExpiresAfter().getMonth());
            junit.framework.Assert.assertEquals((int)subDirectOut.getExpiresAfter().getDay(), (int)subOut.getExpiresAfter().getDay());
            junit.framework.Assert.assertEquals((int)subDirectOut.getExpiresAfter().getYear(), (int)subOut.getExpiresAfter().getYear());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown");
        }
    }

    private void deleteSubscription(String authInfo, String subscriptionKey) {
        try {
            DeleteSubscription ds = new DeleteSubscription();
            ds.setAuthInfo(authInfo);
            ds.getSubscriptionKey().add(subscriptionKey);
            this.subscription.deleteSubscription(ds);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown.");
        }
    }
}

