/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.tck;

import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.Holder;
import org.apache.juddi.jaxb.EntityCreator;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.DeleteBinding;
import org.uddi.api_v3.Description;
import org.uddi.api_v3.SaveBinding;
import org.uddi.api_v3.SaveService;
import org.uddi.sub_v3.DeleteSubscription;
import org.uddi.sub_v3.Subscription;
import org.uddi.v3_service.UDDIPublicationPortType;
import org.uddi.v3_service.UDDISubscriptionPortType;

public class TckSubscriptionListener {
    public static final String SUBSCRIBED_SERVICE_XML = "uddi_data/subscriptionnotifier/businessService.xml";
    public static final String SUBSCRIBED_SERVICE_KEY = "uddi:uddi.joepublisher.com:notifierone";
    static final String JOE_SERVICE_XML = "uddi_data/joepublisher/businessService.xml";
    static final String JOE_SERVICE_KEY = "uddi:uddi.joepublisher.com:serviceone";
    static final String SAM_SERVICE_XML = "uddi_data/samsyndicator/businessService.xml";
    static final String SAM_SERVICE_KEY = "uddi:www.samco.com:listingservice";
    static final String JOE_SUBSCRIPTION_XML = "uddi_data/subscription/subscription1.xml";
    static final String JOE_SUBSCRIPTION_KEY = "uddi:uddi.joepublisher.com:subscriptionone";
    static final String JOE_SUBSCRIPTIONRESULTS_XML = "uddi_data/subscription/subscriptionresults1.xml";
    public static final String NOTIFIER_BINDING_XML = "uddi_data/subscriptionnotifier/bindingTemplate.xml";
    public static final String NOTIFIER_BINDING_KEY = "uddi:uddi.joepublisher.com:bindingnotifier";
    public static final String SUBSCRIPTION_XML = "uddi_data/subscriptionnotifier/subscription1.xml";
    public static final String SUBSCRIPTION_KEY = "uddi:uddi.joepublisher.com:subscriptionone";
    private Logger logger = Logger.getLogger(this.getClass());
    private UDDIPublicationPortType publication = null;
    private UDDISubscriptionPortType subscription = null;
    private SaveService ss = null;

    public TckSubscriptionListener(UDDISubscriptionPortType subscription, UDDIPublicationPortType publication) {
        this.subscription = subscription;
        this.publication = publication;
    }

    public void saveNotifierBinding(String authInfo, String bindingXML, String bindingKey) {
        try {
            SaveBinding sb = new SaveBinding();
            sb.setAuthInfo(authInfo);
            BindingTemplate btIn = (BindingTemplate)EntityCreator.buildFromDoc((String)bindingXML, (String)"org.uddi.api_v3");
            sb.getBindingTemplate().add(btIn);
            this.publication.saveBinding(sb);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)("No exception should be thrown: " + e.getMessage()));
        }
    }

    public void deleteBinding(String authInfo, String bindingKey) {
        try {
            DeleteBinding db = new DeleteBinding();
            db.setAuthInfo(authInfo);
            db.getBindingKey().add(bindingKey);
            this.publication.deleteBinding(db);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown.");
        }
    }

    public void saveService(String authInfo) {
        try {
            this.ss = new SaveService();
            this.ss.setAuthInfo(authInfo);
            BusinessService bsIn = (BusinessService)EntityCreator.buildFromDoc((String)SUBSCRIBED_SERVICE_XML, (String)"org.uddi.api_v3");
            this.ss.getBusinessService().add(bsIn);
            this.publication.saveService(this.ss);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown.");
        }
    }

    public void changeSubscribedObject(String authInfo) {
        try {
            ((Description)((BusinessService)this.ss.getBusinessService().get(0)).getDescription().get(0)).setValue("foo");
            this.publication.saveService(this.ss);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)("No exception should be thrown. " + e.getMessage()));
        }
    }

    public void saveNotifierSubscription(String authInfo) {
        this.saveSubscription(authInfo, SUBSCRIPTION_XML, "uddi:uddi.joepublisher.com:subscriptionone");
    }

    public void deleteNotifierSubscription(String authInfo) {
        this.deleteSubscription(authInfo, "uddi:uddi.joepublisher.com:subscriptionone");
    }

    private void saveSubscription(String authInfo, String subscriptionXML, String subscriptionKey) {
        try {
            Subscription subIn = (Subscription)EntityCreator.buildFromDoc((String)subscriptionXML, (String)"org.uddi.sub_v3");
            ArrayList<Subscription> subscriptionList = new ArrayList<Subscription>();
            subscriptionList.add(subIn);
            Holder subscriptionHolder = new Holder();
            subscriptionHolder.value = subscriptionList;
            this.subscription.saveSubscription(authInfo, subscriptionHolder);
            Subscription subDirectOut = (Subscription)((List)subscriptionHolder.value).get(0);
            junit.framework.Assert.assertEquals((String)subIn.getSubscriptionKey(), (String)subDirectOut.getSubscriptionKey());
            List outSubscriptionList = this.subscription.getSubscriptions(authInfo);
            Assert.assertNotNull((Object)outSubscriptionList);
            Subscription subOut = (Subscription)outSubscriptionList.get(0);
            junit.framework.Assert.assertEquals((String)subIn.getSubscriptionKey(), (String)subOut.getSubscriptionKey());
            junit.framework.Assert.assertEquals((int)subDirectOut.getExpiresAfter().getMonth(), (int)subOut.getExpiresAfter().getMonth());
            junit.framework.Assert.assertEquals((int)subDirectOut.getExpiresAfter().getDay(), (int)subOut.getExpiresAfter().getDay());
            junit.framework.Assert.assertEquals((int)subDirectOut.getExpiresAfter().getYear(), (int)subOut.getExpiresAfter().getYear());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown");
        }
    }

    private void deleteSubscription(String authInfo, String subscriptionKey) {
        try {
            DeleteSubscription ds = new DeleteSubscription();
            ds.setAuthInfo(authInfo);
            ds.getSubscriptionKey().add(subscriptionKey);
            this.subscription.deleteSubscription(ds);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown.");
        }
    }
}

