/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.tck;

import java.util.List;
import org.apache.juddi.jaxb.EntityCreator;
import org.apache.juddi.v3.tck.TckValidator;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.uddi.api_v3.DeleteTModel;
import org.uddi.api_v3.GetTModelDetail;
import org.uddi.api_v3.OverviewDoc;
import org.uddi.api_v3.SaveTModel;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3.TModelDetail;
import org.uddi.v3_service.UDDIInquiryPortType;
import org.uddi.v3_service.UDDIPublicationPortType;

public class TckTModel {
    static final String JOE_PUBLISHER_TMODEL_XML = "uddi_data/joepublisher/tModelKeyGen.xml";
    static final String JOE_PUBLISHER_TMODEL_KEY = "uddi:uddi.joepublisher.com:keygenerator";
    static final String SAM_SYNDICATOR_TMODEL_XML = "uddi_data/samsyndicator/tModelKeyGen.xml";
    static final String SAM_SYNDICATOR_TMODEL_KEY = "uddi:www.samco.com:keygenerator";
    private Logger logger = Logger.getLogger(this.getClass());
    private UDDIPublicationPortType publication = null;
    private UDDIInquiryPortType inquiry = null;

    public TckTModel(UDDIPublicationPortType publication, UDDIInquiryPortType inquiry) {
        this.publication = publication;
        this.inquiry = inquiry;
    }

    public void saveTModel(String authInfo, String tModelXml, String tModelKey) {
        try {
            SaveTModel st = new SaveTModel();
            st.setAuthInfo(authInfo);
            TModel tmIn = (TModel)EntityCreator.buildFromDoc((String)tModelXml, (String)"org.uddi.api_v3");
            st.getTModel().add(tmIn);
            this.publication.saveTModel(st);
            GetTModelDetail gt = new GetTModelDetail();
            gt.getTModelKey().add(tModelKey);
            TModelDetail td = this.inquiry.getTModelDetail(gt);
            List tmOutList = td.getTModel();
            TModel tmOut = (TModel)tmOutList.get(0);
            junit.framework.Assert.assertEquals((String)tmIn.getTModelKey(), (String)tmOut.getTModelKey());
            junit.framework.Assert.assertEquals((String)tmIn.getName().getLang(), (String)tmOut.getName().getLang());
            junit.framework.Assert.assertEquals((String)tmIn.getName().getValue(), (String)tmOut.getName().getValue());
            TckValidator.checkDescriptions(tmIn.getDescription(), tmOut.getDescription());
            TckValidator.checkCategories(tmIn.getCategoryBag(), tmOut.getCategoryBag());
            for (OverviewDoc overviewDoc : tmIn.getOverviewDoc()) {
                TckValidator.checkOverviewDocs(overviewDoc, tmOut.getOverviewDoc());
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown");
        }
    }

    public void deleteTModel(String authInfo, String tModelXml, String tModelKey) {
        try {
            DeleteTModel dt = new DeleteTModel();
            dt.setAuthInfo(authInfo);
            dt.getTModelKey().add(tModelKey);
            this.publication.deleteTModel(dt);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown");
        }
    }

    public void saveJoePublisherTmodel(String authInfoJoe) {
        this.saveTModel(authInfoJoe, JOE_PUBLISHER_TMODEL_XML, JOE_PUBLISHER_TMODEL_KEY);
    }

    public void deleteJoePublisherTmodel(String authInfoJoe) {
        this.deleteTModel(authInfoJoe, JOE_PUBLISHER_TMODEL_XML, JOE_PUBLISHER_TMODEL_KEY);
    }

    public void saveSamSyndicatorTmodel(String authInfoSam) {
        this.saveTModel(authInfoSam, SAM_SYNDICATOR_TMODEL_XML, SAM_SYNDICATOR_TMODEL_KEY);
    }

    public void deleteSamSyndicatorTmodel(String authInfoSam) {
        this.deleteTModel(authInfoSam, SAM_SYNDICATOR_TMODEL_XML, SAM_SYNDICATOR_TMODEL_KEY);
    }
}

