/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.tck;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BindingTemplates;
import org.uddi.api_v3.CategoryBag;
import org.uddi.api_v3.Contact;
import org.uddi.api_v3.Contacts;
import org.uddi.api_v3.Description;
import org.uddi.api_v3.DiscoveryURL;
import org.uddi.api_v3.DiscoveryURLs;
import org.uddi.api_v3.HostingRedirector;
import org.uddi.api_v3.InstanceDetails;
import org.uddi.api_v3.KeyedReference;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.OverviewDoc;
import org.uddi.api_v3.OverviewURL;
import org.uddi.api_v3.PersonName;
import org.uddi.api_v3.TModelInstanceDetails;
import org.uddi.api_v3.TModelInstanceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TckValidator {
    public static void checkNames(List<Name> names1, List<Name> names2) {
        if (names1 == null || names2 == null) {
            Assert.assertEquals(names1, names2);
            return;
        }
        Assert.assertEquals((int)names1.size(), (int)names2.size());
        Iterator<Name> names1Itr = names1.iterator();
        Iterator<Name> names2Itr = names2.iterator();
        while (names1Itr.hasNext()) {
            Name name1 = names1Itr.next();
            Name name2 = names2Itr.next();
            Assert.assertEquals((String)name1.getLang(), (String)name2.getLang());
            Assert.assertEquals((String)name1.getValue(), (String)name2.getValue());
        }
    }

    public static void checkDescriptions(List<Description> descriptions1, List<Description> descriptions2) {
        if (descriptions1 == null || descriptions2 == null) {
            Assert.assertEquals(descriptions1, descriptions2);
            return;
        }
        Assert.assertEquals((int)descriptions1.size(), (int)descriptions2.size());
        Iterator<Description> descriptions1Itr = descriptions1.iterator();
        Iterator<Description> descriptions2Itr = descriptions2.iterator();
        while (descriptions1Itr.hasNext()) {
            Description description1 = descriptions1Itr.next();
            Description description2 = descriptions2Itr.next();
            Assert.assertEquals((String)description1.getLang(), (String)description2.getLang());
            Assert.assertEquals((String)description1.getValue(), (String)description2.getValue());
        }
    }

    public static void checkDiscoveryUrls(DiscoveryURLs discs1, DiscoveryURLs discs2) {
        if (discs1 == null || discs2 == null) {
            Assert.assertEquals((Object)discs1, (Object)discs2);
            return;
        }
        List discList1 = discs1.getDiscoveryURL();
        List discList2 = discs2.getDiscoveryURL();
        if (discList1 == null || discList2 == null) {
            Assert.assertEquals((Object)discList1, (Object)discList2);
            return;
        }
        Assert.assertEquals((int)discList1.size(), (int)discList2.size());
        Iterator discList1Itr = discList1.iterator();
        Iterator discList2Itr = discList2.iterator();
        while (discList1Itr.hasNext()) {
            DiscoveryURL disc1 = (DiscoveryURL)discList1Itr.next();
            DiscoveryURL disc2 = (DiscoveryURL)discList2Itr.next();
            Assert.assertEquals((String)disc1.getUseType(), (String)disc2.getUseType());
            Assert.assertEquals((String)disc1.getValue(), (String)disc2.getValue());
        }
    }

    public static void checkContacts(Contacts contacts1, Contacts contacts2) {
        if (contacts1 == null || contacts2 == null) {
            Assert.assertEquals((Object)contacts1, (Object)contacts2);
            return;
        }
        List contactList1 = contacts1.getContact();
        List contactList2 = contacts2.getContact();
        if (contactList1 == null || contactList2 == null) {
            Assert.assertEquals((Object)contactList1, (Object)contactList2);
            return;
        }
        Assert.assertEquals((int)contactList1.size(), (int)contactList2.size());
        Iterator contactList1Itr = contactList1.iterator();
        Iterator contactList2Itr = contactList2.iterator();
        while (contactList1Itr.hasNext()) {
            Contact contact1 = (Contact)contactList1Itr.next();
            Contact contact2 = (Contact)contactList2Itr.next();
            Assert.assertEquals((String)contact1.getUseType(), (String)contact2.getUseType());
            TckValidator.checkPersonNames(contact1.getPersonName(), contact2.getPersonName());
            TckValidator.checkDescriptions(contact1.getDescription(), contact2.getDescription());
        }
    }

    public static void checkPersonNames(List<PersonName> names1, List<PersonName> names2) {
        if (names1 == null || names2 == null) {
            Assert.assertEquals(names1, names2);
            return;
        }
        Assert.assertEquals((int)names1.size(), (int)names2.size());
        Iterator<PersonName> names1Itr = names1.iterator();
        Iterator<PersonName> names2Itr = names2.iterator();
        while (names1Itr.hasNext()) {
            PersonName name1 = names1Itr.next();
            PersonName name2 = names2Itr.next();
            Assert.assertEquals((String)name1.getLang(), (String)name2.getLang());
            Assert.assertEquals((String)name1.getValue(), (String)name2.getValue());
        }
    }

    public static void checkCategories(CategoryBag cbag1, CategoryBag cbag2) {
        if (cbag1 == null || cbag2 == null) {
            Assert.assertEquals((Object)cbag1, (Object)cbag2);
            return;
        }
        List elemList1 = cbag1.getKeyedReference();
        List elemList2 = cbag2.getKeyedReference();
        if (elemList1 == null || elemList2 == null) {
            Assert.assertEquals((Object)elemList1, (Object)elemList2);
            return;
        }
        Iterator elemList1Itr = elemList1.iterator();
        Iterator elemList2Itr = elemList2.iterator();
        while (elemList1Itr.hasNext()) {
            KeyedReference elem1 = (KeyedReference)elemList1Itr.next();
            if (!(elem1 instanceof KeyedReference)) continue;
            KeyedReference elem2 = (KeyedReference)elemList2Itr.next();
            Assert.assertEquals((String)elem1.getTModelKey(), (String)elem2.getTModelKey());
            Assert.assertEquals((String)elem1.getKeyName(), (String)elem2.getKeyName());
            Assert.assertEquals((String)elem1.getKeyValue(), (String)elem2.getKeyValue());
        }
    }

    public static void checkBindingTemplates(BindingTemplates bts1, BindingTemplates bts2) {
        if (bts1 == null || bts2 == null) {
            Assert.assertEquals((Object)bts1, (Object)bts2);
            return;
        }
        Assert.assertEquals((int)bts1.getBindingTemplate().size(), (int)bts2.getBindingTemplate().size());
        Iterator bt1Iter = bts1.getBindingTemplate().iterator();
        Iterator bt2Iter = bts2.getBindingTemplate().iterator();
        while (bt1Iter.hasNext()) {
            BindingTemplate bt1 = (BindingTemplate)bt1Iter.next();
            BindingTemplate bt2 = (BindingTemplate)bt2Iter.next();
            Assert.assertEquals((String)bt1.getAccessPoint().getValue(), (String)bt2.getAccessPoint().getValue());
            Assert.assertEquals((String)bt1.getAccessPoint().getUseType(), (String)bt2.getAccessPoint().getUseType());
            Assert.assertEquals((String)bt1.getBindingKey(), (String)bt2.getBindingKey());
            TckValidator.checkCategories(bt1.getCategoryBag(), bt2.getCategoryBag());
            TckValidator.checkDescriptions(bt1.getDescription(), bt2.getDescription());
            TckValidator.checkHostingRedirector(bt1.getHostingRedirector(), bt2.getHostingRedirector());
            if (bt1.getServiceKey() != null) {
                Assert.assertEquals((String)bt1.getServiceKey(), (String)bt2.getServiceKey());
            }
            TckValidator.checkTModelInstanceDetails(bt1.getTModelInstanceDetails(), bt2.getTModelInstanceDetails());
        }
    }

    public static void checkTModelInstanceDetails(TModelInstanceDetails tmds1, TModelInstanceDetails tmds2) {
        if (tmds1 == null || tmds2 == null) {
            Assert.assertEquals((Object)tmds1, (Object)tmds2);
            return;
        }
        Assert.assertEquals((int)tmds1.getTModelInstanceInfo().size(), (int)tmds2.getTModelInstanceInfo().size());
        Iterator tmIter1 = tmds1.getTModelInstanceInfo().iterator();
        Iterator tmIter2 = tmds2.getTModelInstanceInfo().iterator();
        while (tmIter1.hasNext()) {
            TModelInstanceInfo tmI1 = (TModelInstanceInfo)tmIter1.next();
            TModelInstanceInfo tmI2 = (TModelInstanceInfo)tmIter2.next();
            TckValidator.checkDescriptions(tmI1.getDescription(), tmI2.getDescription());
            TckValidator.checkInstanceDetails(tmI1.getInstanceDetails(), tmI2.getInstanceDetails());
            Assert.assertEquals((String)tmI1.getTModelKey(), (String)tmI2.getTModelKey());
        }
    }

    public static void checkInstanceDetails(InstanceDetails ids1, InstanceDetails ids2) {
        if (ids1 == null || ids2 == null) {
            Assert.assertEquals((Object)ids1, (Object)ids2);
            return;
        }
        List elem1s = ids1.getDescription();
        List elem2s = ids2.getDescription();
        Iterator elem1 = elem1s.iterator();
        boolean isMatch = false;
        if (elem1s.size() == 0 && elem2s.size() == 0) {
            isMatch = true;
        }
        block0: while (elem1.hasNext()) {
            Description desc1 = (Description)elem1.next();
            if (!(desc1 instanceof Description)) continue;
            for (Description desc2 : elem2s) {
                if (!(desc2 instanceof Description) || !desc1.getLang().equals(desc2.getLang()) || !desc1.getValue().equals(desc2.getValue())) continue;
                isMatch = true;
                continue block0;
            }
        }
        Assert.assertTrue((boolean)isMatch);
        List odoc1s = ids1.getOverviewDoc();
        List odoc2s = ids2.getOverviewDoc();
        Iterator docelem1 = odoc1s.iterator();
        isMatch = false;
        if (odoc1s.size() == 0 && odoc2s.size() == 0) {
            isMatch = true;
        }
        while (docelem1.hasNext()) {
            OverviewDoc odoc1 = (OverviewDoc)docelem1.next();
            if (!(odoc1 instanceof OverviewDoc)) continue;
            TckValidator.checkOverviewDocs(odoc1, odoc2s);
            isMatch = true;
        }
        Assert.assertEquals((String)ids1.getInstanceParms(), (String)ids2.getInstanceParms());
        Assert.assertTrue((boolean)isMatch);
    }

    public static void checkOverviewDocs(OverviewDoc doc1, List<OverviewDoc> elem2s) {
        OverviewDoc doc2;
        boolean isMatch = false;
        Iterator<OverviewDoc> elem2 = elem2s.iterator();
        while (!(!elem2.hasNext() || (doc2 = elem2.next()) instanceof OverviewDoc && (isMatch = TckValidator.compareOverviewDocs(doc1, doc2)))) {
        }
        Assert.assertTrue((boolean)isMatch);
    }

    public static void checkOverviewDocs(OverviewDoc doc1, Collection<OverviewDoc> doc2s) {
        OverviewDoc doc2;
        boolean isMatch = false;
        Iterator<OverviewDoc> docIter = doc2s.iterator();
        while (docIter.hasNext() && !(isMatch = TckValidator.compareOverviewDocs(doc1, doc2 = docIter.next()))) {
        }
        Assert.assertTrue((boolean)isMatch);
    }

    public static boolean compareOverviewDocs(OverviewDoc doc1, OverviewDoc doc2) {
        boolean descMatch = false;
        boolean urlMatch = false;
        OverviewURL url1 = doc1.getOverviewURL();
        OverviewURL url2 = doc2.getOverviewURL();
        if (url1.getUseType().equals(url2.getUseType()) && url1.getValue().equals(url2.getValue())) {
            urlMatch = true;
        }
        List descList1 = doc1.getDescription();
        Iterator descIter1 = descList1.iterator();
        if (descList1.size() == 0 && doc2.getDescription().size() == 0) {
            descMatch = true;
        }
        while (descIter1.hasNext()) {
            Description descr1 = (Description)descIter1.next();
            List descList2 = doc2.getDescription();
            for (Description descr2 : descList2) {
                if (!descr1.getLang().equals(descr2.getLang()) || !descr1.getValue().equals(descr2.getValue())) continue;
                descMatch = true;
            }
        }
        return urlMatch && descMatch;
    }

    public static void checkHostingRedirector(HostingRedirector hr1, HostingRedirector hr2) {
        if (hr1 == null || hr2 == null) {
            Assert.assertEquals((Object)hr1, (Object)hr2);
            return;
        }
        Assert.assertEquals((String)hr1.getBindingKey(), (String)hr2.getBindingKey());
    }
}

