/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.test.MockMetricsReporter;
import org.junit.Assert;
import org.junit.Test;

public class KafkaConsumerTest {
    private final String topic = "test";
    private final TopicPartition tp0 = new TopicPartition("test", 0);

    @Test
    public void testConstructorClose() throws Exception {
        Properties props = new Properties();
        props.setProperty("client.id", "testConstructorClose");
        props.setProperty("bootstrap.servers", "some.invalid.hostname.foo.bar:9999");
        props.setProperty("metric.reporters", MockMetricsReporter.class.getName());
        int oldInitCount = MockMetricsReporter.INIT_COUNT.get();
        int oldCloseCount = MockMetricsReporter.CLOSE_COUNT.get();
        try {
            KafkaConsumer kafkaConsumer = new KafkaConsumer(props, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        }
        catch (KafkaException e) {
            Assert.assertEquals((long)(oldInitCount + 1), (long)MockMetricsReporter.INIT_COUNT.get());
            Assert.assertEquals((long)(oldCloseCount + 1), (long)MockMetricsReporter.CLOSE_COUNT.get());
            Assert.assertEquals((Object)"Failed to construct kafka consumer", (Object)e.getMessage());
            return;
        }
        Assert.fail((String)"should have caught an exception and returned");
    }

    @Test
    public void testSubscription() {
        Properties props = new Properties();
        props.setProperty("client.id", "testSubscription");
        props.setProperty("bootstrap.servers", "localhost:9999");
        props.setProperty("metric.reporters", MockMetricsReporter.class.getName());
        KafkaConsumer consumer = new KafkaConsumer(props, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        consumer.subscribe(Collections.singletonList("test"));
        Assert.assertEquals(Collections.singleton("test"), (Object)consumer.subscription());
        Assert.assertTrue((boolean)consumer.assignment().isEmpty());
        consumer.subscribe(Collections.emptyList());
        Assert.assertTrue((boolean)consumer.subscription().isEmpty());
        Assert.assertTrue((boolean)consumer.assignment().isEmpty());
        consumer.assign(Collections.singletonList(this.tp0));
        Assert.assertTrue((boolean)consumer.subscription().isEmpty());
        Assert.assertEquals(Collections.singleton(this.tp0), (Object)consumer.assignment());
        consumer.unsubscribe();
        Assert.assertTrue((boolean)consumer.subscription().isEmpty());
        Assert.assertTrue((boolean)consumer.assignment().isEmpty());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSeekNegative() {
        Properties props = new Properties();
        props.setProperty("client.id", "testSeekNegative");
        props.setProperty("bootstrap.servers", "localhost:9999");
        props.setProperty("metric.reporters", MockMetricsReporter.class.getName());
        KafkaConsumer consumer = new KafkaConsumer(props, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        consumer.assign(Arrays.asList(new TopicPartition("nonExistTopic", 0)));
        consumer.seek(new TopicPartition("nonExistTopic", 0), -1L);
    }
}

