/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.requests.ControlledShutdownRequest;
import org.apache.kafka.common.requests.ControlledShutdownResponse;
import org.apache.kafka.common.requests.DescribeGroupsRequest;
import org.apache.kafka.common.requests.DescribeGroupsResponse;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.GroupCoordinatorRequest;
import org.apache.kafka.common.requests.GroupCoordinatorResponse;
import org.apache.kafka.common.requests.HeartbeatRequest;
import org.apache.kafka.common.requests.HeartbeatResponse;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.requests.JoinGroupResponse;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.common.requests.LeaveGroupRequest;
import org.apache.kafka.common.requests.LeaveGroupResponse;
import org.apache.kafka.common.requests.ListGroupsRequest;
import org.apache.kafka.common.requests.ListGroupsResponse;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.StopReplicaResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.requests.UpdateMetadataResponse;
import org.junit.Assert;
import org.junit.Test;

public class RequestResponseTest {
    @Test
    public void testSerialization() throws Exception {
        List<AbstractRequestResponse> requestResponseList = Arrays.asList(this.createRequestHeader(), this.createResponseHeader(), this.createGroupCoordinatorRequest(), this.createGroupCoordinatorRequest().getErrorResponse(0, (Throwable)new UnknownServerException()), this.createGroupCoordinatorResponse(), this.createControlledShutdownRequest(), this.createControlledShutdownResponse(), this.createControlledShutdownRequest().getErrorResponse(1, (Throwable)new UnknownServerException()), this.createFetchRequest(), this.createFetchRequest().getErrorResponse(0, (Throwable)new UnknownServerException()), this.createFetchResponse(), this.createHeartBeatRequest(), this.createHeartBeatRequest().getErrorResponse(0, (Throwable)new UnknownServerException()), this.createHeartBeatResponse(), this.createJoinGroupRequest(), this.createJoinGroupRequest().getErrorResponse(0, (Throwable)new UnknownServerException()), this.createJoinGroupResponse(), this.createLeaveGroupRequest(), this.createLeaveGroupRequest().getErrorResponse(0, (Throwable)new UnknownServerException()), this.createLeaveGroupResponse(), this.createListGroupsRequest(), this.createListGroupsRequest().getErrorResponse(0, (Throwable)new UnknownServerException()), this.createListGroupsResponse(), this.createDescribeGroupRequest(), this.createDescribeGroupRequest().getErrorResponse(0, (Throwable)new UnknownServerException()), this.createDescribeGroupResponse(), this.createListOffsetRequest(), this.createListOffsetRequest().getErrorResponse(0, (Throwable)new UnknownServerException()), this.createListOffsetResponse(), this.createMetadataRequest(), this.createMetadataRequest().getErrorResponse(0, (Throwable)new UnknownServerException()), this.createMetadataResponse(), this.createOffsetCommitRequest(), this.createOffsetCommitRequest().getErrorResponse(0, (Throwable)new UnknownServerException()), this.createOffsetCommitResponse(), this.createOffsetFetchRequest(), this.createOffsetFetchRequest().getErrorResponse(0, (Throwable)new UnknownServerException()), this.createOffsetFetchResponse(), this.createProduceRequest(), this.createProduceRequest().getErrorResponse(0, (Throwable)new UnknownServerException()), this.createProduceResponse(), this.createStopReplicaRequest(), this.createStopReplicaRequest().getErrorResponse(0, (Throwable)new UnknownServerException()), this.createStopReplicaResponse(), this.createUpdateMetadataRequest(1), this.createUpdateMetadataRequest(1).getErrorResponse(1, (Throwable)new UnknownServerException()), this.createUpdateMetadataResponse(), this.createLeaderAndIsrRequest(), this.createLeaderAndIsrRequest().getErrorResponse(0, (Throwable)new UnknownServerException()), this.createLeaderAndIsrResponse());
        for (AbstractRequestResponse req : requestResponseList) {
            this.checkSerialization(req, null);
        }
        this.checkSerialization((AbstractRequestResponse)this.createUpdateMetadataRequest(0), 0);
        this.checkSerialization(this.createUpdateMetadataRequest(0).getErrorResponse(0, (Throwable)new UnknownServerException()), 0);
    }

    private void checkSerialization(AbstractRequestResponse req, Integer version) throws Exception {
        AbstractRequestResponse deserialized;
        ByteBuffer buffer = ByteBuffer.allocate(req.sizeOf());
        req.writeTo(buffer);
        buffer.rewind();
        if (version == null) {
            Method deserializer = req.getClass().getDeclaredMethod("parse", ByteBuffer.class);
            deserialized = (AbstractRequestResponse)deserializer.invoke(null, buffer);
        } else {
            Method deserializer = req.getClass().getDeclaredMethod("parse", ByteBuffer.class, Integer.TYPE);
            deserialized = (AbstractRequestResponse)deserializer.invoke(null, buffer, version);
        }
        Assert.assertEquals((String)("The original and deserialized of " + req.getClass().getSimpleName() + " should be the same."), (Object)req, (Object)deserialized);
        Assert.assertEquals((String)("The original and deserialized of " + req.getClass().getSimpleName() + " should have the same hashcode."), (long)req.hashCode(), (long)deserialized.hashCode());
    }

    @Test
    public void produceResponseVersionTest() {
        HashMap<TopicPartition, ProduceResponse.PartitionResponse> responseData = new HashMap<TopicPartition, ProduceResponse.PartitionResponse>();
        responseData.put(new TopicPartition("test", 0), new ProduceResponse.PartitionResponse(Errors.NONE.code(), 10000L));
        ProduceResponse v0Response = new ProduceResponse(responseData);
        ProduceResponse v1Response = new ProduceResponse(responseData, 10);
        Assert.assertEquals((String)"Throttle time must be zero", (long)0L, (long)v0Response.getThrottleTime());
        Assert.assertEquals((String)"Throttle time must be 10", (long)10L, (long)v1Response.getThrottleTime());
        Assert.assertEquals((String)"Should use schema version 0", (Object)ProtoUtils.responseSchema((int)ApiKeys.PRODUCE.id, (int)0), (Object)v0Response.toStruct().schema());
        Assert.assertEquals((String)"Should use schema version 1", (Object)ProtoUtils.responseSchema((int)ApiKeys.PRODUCE.id, (int)1), (Object)v1Response.toStruct().schema());
        Assert.assertEquals((String)"Response data does not match", responseData, (Object)v0Response.responses());
        Assert.assertEquals((String)"Response data does not match", responseData, (Object)v1Response.responses());
    }

    @Test
    public void fetchResponseVersionTest() {
        HashMap<TopicPartition, FetchResponse.PartitionData> responseData = new HashMap<TopicPartition, FetchResponse.PartitionData>();
        responseData.put(new TopicPartition("test", 0), new FetchResponse.PartitionData(Errors.NONE.code(), 1000000L, ByteBuffer.allocate(10)));
        FetchResponse v0Response = new FetchResponse(responseData);
        FetchResponse v1Response = new FetchResponse(responseData, 10);
        Assert.assertEquals((String)"Throttle time must be zero", (long)0L, (long)v0Response.getThrottleTime());
        Assert.assertEquals((String)"Throttle time must be 10", (long)10L, (long)v1Response.getThrottleTime());
        Assert.assertEquals((String)"Should use schema version 0", (Object)ProtoUtils.responseSchema((int)ApiKeys.FETCH.id, (int)0), (Object)v0Response.toStruct().schema());
        Assert.assertEquals((String)"Should use schema version 1", (Object)ProtoUtils.responseSchema((int)ApiKeys.FETCH.id, (int)1), (Object)v1Response.toStruct().schema());
        Assert.assertEquals((String)"Response data does not match", responseData, (Object)v0Response.responseData());
        Assert.assertEquals((String)"Response data does not match", responseData, (Object)v1Response.responseData());
    }

    @Test
    public void testControlledShutdownResponse() {
        ControlledShutdownResponse response = this.createControlledShutdownResponse();
        ByteBuffer buffer = ByteBuffer.allocate(response.sizeOf());
        response.writeTo(buffer);
        buffer.rewind();
        ControlledShutdownResponse deserialized = ControlledShutdownResponse.parse((ByteBuffer)buffer);
        Assert.assertEquals((long)response.errorCode(), (long)deserialized.errorCode());
        Assert.assertEquals((Object)response.partitionsRemaining(), (Object)deserialized.partitionsRemaining());
    }

    private AbstractRequestResponse createRequestHeader() {
        return new RequestHeader(10, 1, "", 10);
    }

    private AbstractRequestResponse createResponseHeader() {
        return new ResponseHeader(10);
    }

    private AbstractRequest createGroupCoordinatorRequest() {
        return new GroupCoordinatorRequest("test-group");
    }

    private AbstractRequestResponse createGroupCoordinatorResponse() {
        return new GroupCoordinatorResponse(Errors.NONE.code(), new Node(10, "host1", 2014));
    }

    private AbstractRequest createFetchRequest() {
        HashMap<TopicPartition, FetchRequest.PartitionData> fetchData = new HashMap<TopicPartition, FetchRequest.PartitionData>();
        fetchData.put(new TopicPartition("test1", 0), new FetchRequest.PartitionData(100L, 1000000));
        fetchData.put(new TopicPartition("test2", 0), new FetchRequest.PartitionData(200L, 1000000));
        return new FetchRequest(-1, 100, 100000, fetchData);
    }

    private AbstractRequestResponse createFetchResponse() {
        HashMap<TopicPartition, FetchResponse.PartitionData> responseData = new HashMap<TopicPartition, FetchResponse.PartitionData>();
        responseData.put(new TopicPartition("test", 0), new FetchResponse.PartitionData(Errors.NONE.code(), 1000000L, ByteBuffer.allocate(10)));
        return new FetchResponse(responseData, 0);
    }

    private AbstractRequest createHeartBeatRequest() {
        return new HeartbeatRequest("group1", 1, "consumer1");
    }

    private AbstractRequestResponse createHeartBeatResponse() {
        return new HeartbeatResponse(Errors.NONE.code());
    }

    private AbstractRequest createJoinGroupRequest() {
        ByteBuffer metadata = ByteBuffer.wrap(new byte[0]);
        ArrayList<JoinGroupRequest.ProtocolMetadata> protocols = new ArrayList<JoinGroupRequest.ProtocolMetadata>();
        protocols.add(new JoinGroupRequest.ProtocolMetadata("consumer-range", metadata));
        return new JoinGroupRequest("group1", 30000, "consumer1", "consumer", protocols);
    }

    private AbstractRequestResponse createJoinGroupResponse() {
        HashMap<String, ByteBuffer> members = new HashMap<String, ByteBuffer>();
        members.put("consumer1", ByteBuffer.wrap(new byte[0]));
        members.put("consumer2", ByteBuffer.wrap(new byte[0]));
        return new JoinGroupResponse(Errors.NONE.code(), 1, "range", "consumer1", "leader", members);
    }

    private AbstractRequest createListGroupsRequest() {
        return new ListGroupsRequest();
    }

    private AbstractRequestResponse createListGroupsResponse() {
        List<ListGroupsResponse.Group> groups = Arrays.asList(new ListGroupsResponse.Group("test-group", "consumer"));
        return new ListGroupsResponse(Errors.NONE.code(), groups);
    }

    private AbstractRequest createDescribeGroupRequest() {
        return new DescribeGroupsRequest(Collections.singletonList("test-group"));
    }

    private AbstractRequestResponse createDescribeGroupResponse() {
        String clientId = "consumer-1";
        String clientHost = "localhost";
        ByteBuffer empty = ByteBuffer.allocate(0);
        DescribeGroupsResponse.GroupMember member = new DescribeGroupsResponse.GroupMember("memberId", clientId, clientHost, empty, empty);
        DescribeGroupsResponse.GroupMetadata metadata = new DescribeGroupsResponse.GroupMetadata(Errors.NONE.code(), "STABLE", "consumer", "roundrobin", Arrays.asList(member));
        return new DescribeGroupsResponse(Collections.singletonMap("test-group", metadata));
    }

    private AbstractRequest createLeaveGroupRequest() {
        return new LeaveGroupRequest("group1", "consumer1");
    }

    private AbstractRequestResponse createLeaveGroupResponse() {
        return new LeaveGroupResponse(Errors.NONE.code());
    }

    private AbstractRequest createListOffsetRequest() {
        HashMap<TopicPartition, ListOffsetRequest.PartitionData> offsetData = new HashMap<TopicPartition, ListOffsetRequest.PartitionData>();
        offsetData.put(new TopicPartition("test", 0), new ListOffsetRequest.PartitionData(1000000L, 10));
        return new ListOffsetRequest(-1, offsetData);
    }

    private AbstractRequestResponse createListOffsetResponse() {
        HashMap<TopicPartition, ListOffsetResponse.PartitionData> responseData = new HashMap<TopicPartition, ListOffsetResponse.PartitionData>();
        responseData.put(new TopicPartition("test", 0), new ListOffsetResponse.PartitionData(Errors.NONE.code(), Arrays.asList(100L)));
        return new ListOffsetResponse(responseData);
    }

    private AbstractRequest createMetadataRequest() {
        return new MetadataRequest(Arrays.asList("topic1"));
    }

    private AbstractRequestResponse createMetadataResponse() {
        Node node = new Node(1, "host1", 1001);
        Node[] replicas = new Node[]{node};
        Node[] isr = new Node[]{node};
        Cluster cluster = new Cluster(Arrays.asList(node), Arrays.asList(new PartitionInfo("topic1", 1, node, replicas, isr)), Collections.emptySet());
        HashMap<String, Errors> errors = new HashMap<String, Errors>();
        errors.put("topic2", Errors.LEADER_NOT_AVAILABLE);
        return new MetadataResponse(cluster, errors);
    }

    private AbstractRequest createOffsetCommitRequest() {
        HashMap<TopicPartition, OffsetCommitRequest.PartitionData> commitData = new HashMap<TopicPartition, OffsetCommitRequest.PartitionData>();
        commitData.put(new TopicPartition("test", 0), new OffsetCommitRequest.PartitionData(100L, ""));
        return new OffsetCommitRequest("group1", 100, "consumer1", 1000000L, commitData);
    }

    private AbstractRequestResponse createOffsetCommitResponse() {
        HashMap<TopicPartition, Short> responseData = new HashMap<TopicPartition, Short>();
        responseData.put(new TopicPartition("test", 0), Errors.NONE.code());
        return new OffsetCommitResponse(responseData);
    }

    private AbstractRequest createOffsetFetchRequest() {
        return new OffsetFetchRequest("group1", Arrays.asList(new TopicPartition("test11", 1)));
    }

    private AbstractRequestResponse createOffsetFetchResponse() {
        HashMap<TopicPartition, OffsetFetchResponse.PartitionData> responseData = new HashMap<TopicPartition, OffsetFetchResponse.PartitionData>();
        responseData.put(new TopicPartition("test", 0), new OffsetFetchResponse.PartitionData(100L, "", Errors.NONE.code()));
        return new OffsetFetchResponse(responseData);
    }

    private AbstractRequest createProduceRequest() {
        HashMap<TopicPartition, ByteBuffer> produceData = new HashMap<TopicPartition, ByteBuffer>();
        produceData.put(new TopicPartition("test", 0), ByteBuffer.allocate(10));
        return new ProduceRequest(1, 5000, produceData);
    }

    private AbstractRequestResponse createProduceResponse() {
        HashMap<TopicPartition, ProduceResponse.PartitionResponse> responseData = new HashMap<TopicPartition, ProduceResponse.PartitionResponse>();
        responseData.put(new TopicPartition("test", 0), new ProduceResponse.PartitionResponse(Errors.NONE.code(), 10000L));
        return new ProduceResponse(responseData, 0);
    }

    private AbstractRequest createStopReplicaRequest() {
        HashSet<TopicPartition> partitions = new HashSet<TopicPartition>(Arrays.asList(new TopicPartition("test", 0)));
        return new StopReplicaRequest(0, 1, true, partitions);
    }

    private AbstractRequestResponse createStopReplicaResponse() {
        HashMap<TopicPartition, Short> responses = new HashMap<TopicPartition, Short>();
        responses.put(new TopicPartition("test", 0), Errors.NONE.code());
        return new StopReplicaResponse(Errors.NONE.code(), responses);
    }

    private AbstractRequest createControlledShutdownRequest() {
        return new ControlledShutdownRequest(10);
    }

    private ControlledShutdownResponse createControlledShutdownResponse() {
        HashSet<TopicPartition> topicPartitions = new HashSet<TopicPartition>(Arrays.asList(new TopicPartition("test2", 5), new TopicPartition("test1", 10)));
        return new ControlledShutdownResponse(Errors.NONE.code(), topicPartitions);
    }

    private AbstractRequest createLeaderAndIsrRequest() {
        HashMap<TopicPartition, LeaderAndIsrRequest.PartitionState> partitionStates = new HashMap<TopicPartition, LeaderAndIsrRequest.PartitionState>();
        List<Integer> isr = Arrays.asList(1, 2);
        List<Integer> replicas = Arrays.asList(1, 2, 3, 4);
        partitionStates.put(new TopicPartition("topic5", 105), new LeaderAndIsrRequest.PartitionState(0, 2, 1, new ArrayList<Integer>(isr), 2, new HashSet<Integer>(replicas)));
        partitionStates.put(new TopicPartition("topic5", 1), new LeaderAndIsrRequest.PartitionState(1, 1, 1, new ArrayList<Integer>(isr), 2, new HashSet<Integer>(replicas)));
        partitionStates.put(new TopicPartition("topic20", 1), new LeaderAndIsrRequest.PartitionState(1, 0, 1, new ArrayList<Integer>(isr), 2, new HashSet<Integer>(replicas)));
        HashSet<LeaderAndIsrRequest.EndPoint> leaders = new HashSet<LeaderAndIsrRequest.EndPoint>(Arrays.asList(new LeaderAndIsrRequest.EndPoint(0, "test0", 1223), new LeaderAndIsrRequest.EndPoint(1, "test1", 1223)));
        return new LeaderAndIsrRequest(1, 10, partitionStates, leaders);
    }

    private AbstractRequestResponse createLeaderAndIsrResponse() {
        HashMap<TopicPartition, Short> responses = new HashMap<TopicPartition, Short>();
        responses.put(new TopicPartition("test", 0), Errors.NONE.code());
        return new LeaderAndIsrResponse(Errors.NONE.code(), responses);
    }

    private AbstractRequest createUpdateMetadataRequest(int version) {
        HashMap<TopicPartition, UpdateMetadataRequest.PartitionState> partitionStates = new HashMap<TopicPartition, UpdateMetadataRequest.PartitionState>();
        List<Integer> isr = Arrays.asList(1, 2);
        List<Integer> replicas = Arrays.asList(1, 2, 3, 4);
        partitionStates.put(new TopicPartition("topic5", 105), new UpdateMetadataRequest.PartitionState(0, 2, 1, new ArrayList<Integer>(isr), 2, new HashSet<Integer>(replicas)));
        partitionStates.put(new TopicPartition("topic5", 1), new UpdateMetadataRequest.PartitionState(1, 1, 1, new ArrayList<Integer>(isr), 2, new HashSet<Integer>(replicas)));
        partitionStates.put(new TopicPartition("topic20", 1), new UpdateMetadataRequest.PartitionState(1, 0, 1, new ArrayList<Integer>(isr), 2, new HashSet<Integer>(replicas)));
        if (version == 0) {
            HashSet<UpdateMetadataRequest.BrokerEndPoint> liveBrokers = new HashSet<UpdateMetadataRequest.BrokerEndPoint>(Arrays.asList(new UpdateMetadataRequest.BrokerEndPoint(0, "host1", 1223), new UpdateMetadataRequest.BrokerEndPoint(1, "host2", 1234)));
            return new UpdateMetadataRequest(1, 10, liveBrokers, partitionStates);
        }
        HashMap<SecurityProtocol, UpdateMetadataRequest.EndPoint> endPoints1 = new HashMap<SecurityProtocol, UpdateMetadataRequest.EndPoint>();
        endPoints1.put(SecurityProtocol.PLAINTEXT, new UpdateMetadataRequest.EndPoint("host1", 1223));
        HashMap<SecurityProtocol, UpdateMetadataRequest.EndPoint> endPoints2 = new HashMap<SecurityProtocol, UpdateMetadataRequest.EndPoint>();
        endPoints2.put(SecurityProtocol.PLAINTEXT, new UpdateMetadataRequest.EndPoint("host1", 1244));
        endPoints2.put(SecurityProtocol.SSL, new UpdateMetadataRequest.EndPoint("host2", 1234));
        HashSet<UpdateMetadataRequest.Broker> liveBrokers = new HashSet<UpdateMetadataRequest.Broker>(Arrays.asList(new UpdateMetadataRequest.Broker(0, endPoints1), new UpdateMetadataRequest.Broker(1, endPoints2)));
        return new UpdateMetadataRequest(1, 10, partitionStates, liveBrokers);
    }

    private AbstractRequestResponse createUpdateMetadataResponse() {
        return new UpdateMetadataResponse(Errors.NONE.code());
    }
}

