/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import org.apache.kafka.clients.InFlightRequests;
import org.apache.kafka.clients.NetworkClient;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InFlightRequestsTest {
    private InFlightRequests inFlightRequests;

    @Before
    public void setup() {
        this.inFlightRequests = new InFlightRequests(12);
        NetworkClient.InFlightRequest ifr = new NetworkClient.InFlightRequest(null, 0L, "dest", null, false, false, null, null, 0L);
        this.inFlightRequests.add(ifr);
    }

    @Test
    public void checkIncrementAndDecrementOnLastSent() {
        Assert.assertEquals((long)1L, (long)this.inFlightRequests.count());
        this.inFlightRequests.completeLastSent("dest");
        Assert.assertEquals((long)0L, (long)this.inFlightRequests.count());
    }

    @Test
    public void checkDecrementOnClear() {
        this.inFlightRequests.clearAll("dest");
        Assert.assertEquals((long)0L, (long)this.inFlightRequests.count());
    }

    @Test
    public void checkDecrementOnCompleteNext() {
        this.inFlightRequests.completeNext("dest");
        Assert.assertEquals((long)0L, (long)this.inFlightRequests.count());
    }

    @Test(expected=IllegalStateException.class)
    public void throwExceptionOnNeverBeforeSeenNode() {
        this.inFlightRequests.completeNext("not-added");
    }
}

