/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.utils.Time;

public class AdminClientUnitTestEnv
implements AutoCloseable {
    private final Time time;
    private final Cluster cluster;
    private final MockClient mockClient;
    private final KafkaAdminClient adminClient;

    public AdminClientUnitTestEnv(Cluster cluster, String ... vals) {
        this(Time.SYSTEM, cluster, vals);
    }

    public AdminClientUnitTestEnv(Time time, Cluster cluster, String ... vals) {
        this(time, cluster, AdminClientUnitTestEnv.newStrMap(vals));
    }

    public AdminClientUnitTestEnv(Time time, Cluster cluster, Map<String, Object> config) {
        this.time = time;
        this.cluster = cluster;
        AdminClientConfig adminClientConfig = new AdminClientConfig(config);
        Metadata metadata = new Metadata(adminClientConfig.getLong("retry.backoff.ms").longValue(), adminClientConfig.getLong("metadata.max.age.ms").longValue(), false);
        this.mockClient = new MockClient(time, metadata);
        this.adminClient = KafkaAdminClient.createInternal((AdminClientConfig)adminClientConfig, (KafkaClient)this.mockClient, (Metadata)metadata, (Time)time);
    }

    public Time time() {
        return this.time;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public AdminClient adminClient() {
        return this.adminClient;
    }

    public MockClient kafkaClient() {
        return this.mockClient;
    }

    @Override
    public void close() {
        this.adminClient.close();
    }

    private static Map<String, Object> newStrMap(String ... vals) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bootstrap.servers", "localhost:8121");
        map.put("request.timeout.ms", "1000");
        if (vals.length % 2 != 0) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < vals.length; i += 2) {
            map.put(vals[i], vals[i + 1]);
        }
        return map;
    }
}

