/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.junit.Assert;
import org.junit.Test;

public class LeaderAndIsrResponseTest {
    @Test
    public void testErrorCountsFromGetErrorResponse() {
        HashMap<TopicPartition, LeaderAndIsrRequest.PartitionState> partitionStates = new HashMap<TopicPartition, LeaderAndIsrRequest.PartitionState>();
        partitionStates.put(new TopicPartition("foo", 0), new LeaderAndIsrRequest.PartitionState(15, 1, 10, Collections.singletonList(10), 20, Collections.singletonList(10), false));
        partitionStates.put(new TopicPartition("foo", 1), new LeaderAndIsrRequest.PartitionState(15, 1, 10, Collections.singletonList(10), 20, Collections.singletonList(10), false));
        LeaderAndIsrRequest request = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 15, 20, partitionStates, Collections.emptySet()).build();
        LeaderAndIsrResponse response = request.getErrorResponse(0, (Throwable)Errors.CLUSTER_AUTHORIZATION_FAILED.exception());
        Assert.assertEquals(Collections.singletonMap(Errors.CLUSTER_AUTHORIZATION_FAILED, 2), (Object)response.errorCounts());
    }

    @Test
    public void testErrorCountsWithTopLevelError() {
        HashMap<TopicPartition, Errors> errors = new HashMap<TopicPartition, Errors>();
        errors.put(new TopicPartition("foo", 0), Errors.NONE);
        errors.put(new TopicPartition("foo", 1), Errors.NOT_LEADER_FOR_PARTITION);
        LeaderAndIsrResponse response = new LeaderAndIsrResponse(Errors.UNKNOWN_SERVER_ERROR, errors);
        Assert.assertEquals(Collections.singletonMap(Errors.UNKNOWN_SERVER_ERROR, 2), (Object)response.errorCounts());
    }

    @Test
    public void testErrorCountsNoTopLevelError() {
        HashMap<TopicPartition, Errors> errors = new HashMap<TopicPartition, Errors>();
        errors.put(new TopicPartition("foo", 0), Errors.NONE);
        errors.put(new TopicPartition("foo", 1), Errors.CLUSTER_AUTHORIZATION_FAILED);
        LeaderAndIsrResponse response = new LeaderAndIsrResponse(Errors.NONE, errors);
        Map errorCounts = response.errorCounts();
        Assert.assertEquals((long)2L, (long)errorCounts.size());
        Assert.assertEquals((long)1L, (long)((Integer)errorCounts.get(Errors.NONE)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)errorCounts.get(Errors.CLUSTER_AUTHORIZATION_FAILED)).intValue());
    }
}

