/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.StopReplicaResponse;
import org.apache.kafka.common.utils.Utils;
import org.junit.Assert;
import org.junit.Test;

public class StopReplicaResponseTest {
    @Test
    public void testErrorCountsFromGetErrorResponse() {
        StopReplicaRequest request = (StopReplicaRequest)new StopReplicaRequest.Builder(15, 20, false, Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("foo", 1)})).build();
        StopReplicaResponse response = request.getErrorResponse(0, (Throwable)Errors.CLUSTER_AUTHORIZATION_FAILED.exception());
        Assert.assertEquals(Collections.singletonMap(Errors.CLUSTER_AUTHORIZATION_FAILED, 2), (Object)response.errorCounts());
    }

    @Test
    public void testErrorCountsWithTopLevelError() {
        HashMap<TopicPartition, Errors> errors = new HashMap<TopicPartition, Errors>();
        errors.put(new TopicPartition("foo", 0), Errors.NONE);
        errors.put(new TopicPartition("foo", 1), Errors.NOT_LEADER_FOR_PARTITION);
        StopReplicaResponse response = new StopReplicaResponse(Errors.UNKNOWN_SERVER_ERROR, errors);
        Assert.assertEquals(Collections.singletonMap(Errors.UNKNOWN_SERVER_ERROR, 2), (Object)response.errorCounts());
    }

    @Test
    public void testErrorCountsNoTopLevelError() {
        HashMap<TopicPartition, Errors> errors = new HashMap<TopicPartition, Errors>();
        errors.put(new TopicPartition("foo", 0), Errors.NONE);
        errors.put(new TopicPartition("foo", 1), Errors.CLUSTER_AUTHORIZATION_FAILED);
        StopReplicaResponse response = new StopReplicaResponse(Errors.NONE, errors);
        Map errorCounts = response.errorCounts();
        Assert.assertEquals((long)2L, (long)errorCounts.size());
        Assert.assertEquals((long)1L, (long)((Integer)errorCounts.get(Errors.NONE)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)errorCounts.get(Errors.CLUSTER_AUTHORIZATION_FAILED)).intValue());
    }
}

