/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import org.apache.kafka.common.utils.Java;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JavaTest {
    private String javaVendor;

    @Before
    public void before() {
        this.javaVendor = System.getProperty("java.vendor");
    }

    @After
    public void after() {
        System.setProperty("java.vendor", this.javaVendor);
    }

    @Test
    public void testIsIBMJdk() {
        System.setProperty("java.vendor", "Oracle Corporation");
        Assert.assertFalse((boolean)Java.isIbmJdk());
        System.setProperty("java.vendor", "IBM Corporation");
        Assert.assertTrue((boolean)Java.isIbmJdk());
    }

    @Test
    public void testLoadKerberosLoginModule() throws ClassNotFoundException {
        String clazz = Java.isIbmJdk() ? "com.ibm.security.auth.module.Krb5LoginModule" : "com.sun.security.auth.module.Krb5LoginModule";
        Class.forName(clazz);
    }

    @Test
    public void testJavaVersion() {
        Java.Version v = Java.parseVersion((String)"9");
        Assert.assertEquals((long)9L, (long)v.majorVersion);
        Assert.assertEquals((long)0L, (long)v.minorVersion);
        Assert.assertTrue((boolean)v.isJava9Compatible());
        Assert.assertTrue((boolean)v.isJava8Compatible());
        v = Java.parseVersion((String)"9.0.1");
        Assert.assertEquals((long)9L, (long)v.majorVersion);
        Assert.assertEquals((long)0L, (long)v.minorVersion);
        Assert.assertTrue((boolean)v.isJava9Compatible());
        Assert.assertTrue((boolean)v.isJava8Compatible());
        v = Java.parseVersion((String)"9.0.0.15");
        Assert.assertEquals((long)9L, (long)v.majorVersion);
        Assert.assertEquals((long)0L, (long)v.minorVersion);
        Assert.assertTrue((boolean)v.isJava9Compatible());
        Assert.assertTrue((boolean)v.isJava8Compatible());
        v = Java.parseVersion((String)"9.1");
        Assert.assertEquals((long)9L, (long)v.majorVersion);
        Assert.assertEquals((long)1L, (long)v.minorVersion);
        Assert.assertTrue((boolean)v.isJava9Compatible());
        Assert.assertTrue((boolean)v.isJava8Compatible());
        v = Java.parseVersion((String)"1.8.0_152");
        Assert.assertEquals((long)1L, (long)v.majorVersion);
        Assert.assertEquals((long)8L, (long)v.minorVersion);
        Assert.assertFalse((boolean)v.isJava9Compatible());
        Assert.assertTrue((boolean)v.isJava8Compatible());
        v = Java.parseVersion((String)"1.7.0_80");
        Assert.assertEquals((long)1L, (long)v.majorVersion);
        Assert.assertEquals((long)7L, (long)v.minorVersion);
        Assert.assertFalse((boolean)v.isJava9Compatible());
        Assert.assertFalse((boolean)v.isJava8Compatible());
    }
}

