/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.utils.Base64;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestCondition;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUtils {
    private static final Logger log = LoggerFactory.getLogger(TestUtils.class);
    public static final File IO_TMP_DIR = new File(System.getProperty("java.io.tmpdir"));
    public static final String LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    public static final String DIGITS = "0123456789";
    public static final String LETTERS_AND_DIGITS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    public static final String GROUP_METADATA_TOPIC_NAME = "__consumer_offsets";
    public static final Set<String> INTERNAL_TOPICS = Collections.singleton("__consumer_offsets");
    public static final Random SEEDED_RANDOM = new Random(192348092834L);
    public static final Random RANDOM = new Random();
    public static final long DEFAULT_MAX_WAIT_MS = 15000L;

    public static Cluster singletonCluster() {
        return TestUtils.clusterWith(1);
    }

    public static Cluster singletonCluster(Map<String, Integer> topicPartitionCounts) {
        return TestUtils.clusterWith(1, topicPartitionCounts);
    }

    public static Cluster singletonCluster(String topic, int partitions) {
        return TestUtils.clusterWith(1, topic, partitions);
    }

    public static Cluster clusterWith(int nodes) {
        return TestUtils.clusterWith(nodes, new HashMap<String, Integer>());
    }

    public static Cluster clusterWith(int nodes, Map<String, Integer> topicPartitionCounts) {
        Node[] ns = new Node[nodes];
        for (int i = 0; i < nodes; ++i) {
            ns[i] = new Node(i, "localhost", 1969);
        }
        ArrayList<PartitionInfo> parts = new ArrayList<PartitionInfo>();
        for (Map.Entry<String, Integer> topicPartition : topicPartitionCounts.entrySet()) {
            String topic = topicPartition.getKey();
            int partitions = topicPartition.getValue();
            for (int i = 0; i < partitions; ++i) {
                parts.add(new PartitionInfo(topic, i, ns[i % ns.length], ns, ns));
            }
        }
        return new Cluster("kafka-cluster", Arrays.asList(ns), parts, Collections.emptySet(), INTERNAL_TOPICS);
    }

    public static Cluster clusterWith(int nodes, String topic, int partitions) {
        return TestUtils.clusterWith(nodes, Collections.singletonMap(topic, partitions));
    }

    public static byte[] randomBytes(int size) {
        byte[] bytes = new byte[size];
        SEEDED_RANDOM.nextBytes(bytes);
        return bytes;
    }

    public static String randomString(int len) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            b.append(LETTERS_AND_DIGITS.charAt(SEEDED_RANDOM.nextInt(LETTERS_AND_DIGITS.length())));
        }
        return b.toString();
    }

    public static File tempFile() throws IOException {
        File file = File.createTempFile("kafka", ".tmp");
        file.deleteOnExit();
        return file;
    }

    public static File tempDirectory(String prefix) {
        return TestUtils.tempDirectory(null, prefix);
    }

    public static File tempDirectory() {
        return TestUtils.tempDirectory(null);
    }

    public static File tempDirectory(Path parent, String prefix) {
        File file;
        prefix = prefix == null ? "kafka-" : prefix;
        try {
            file = parent == null ? Files.createTempDirectory(prefix, new FileAttribute[0]).toFile() : Files.createTempDirectory(parent, prefix, new FileAttribute[0]).toFile();
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to create a temp dir", ex);
        }
        file.deleteOnExit();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    Utils.delete((File)file);
                }
                catch (IOException e) {
                    log.error("Error deleting {}", (Object)file.getAbsolutePath(), (Object)e);
                }
            }
        });
        return file;
    }

    public static Properties producerConfig(String bootstrapServers, Class keySerializer, Class valueSerializer, Properties additional) {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", bootstrapServers);
        properties.put("acks", "all");
        properties.put("retries", (Object)0);
        properties.put("key.serializer", keySerializer);
        properties.put("value.serializer", valueSerializer);
        properties.putAll((Map<?, ?>)additional);
        return properties;
    }

    public static Properties producerConfig(String bootstrapServers, Class keySerializer, Class valueSerializer) {
        return TestUtils.producerConfig(bootstrapServers, keySerializer, valueSerializer, new Properties());
    }

    public static Properties consumerConfig(String bootstrapServers, String groupId, Class keyDeserializer, Class valueDeserializer, Properties additional) {
        Properties consumerConfig = new Properties();
        consumerConfig.put("bootstrap.servers", bootstrapServers);
        consumerConfig.put("group.id", groupId);
        consumerConfig.put("auto.offset.reset", "earliest");
        consumerConfig.put("key.deserializer", keyDeserializer);
        consumerConfig.put("value.deserializer", valueDeserializer);
        consumerConfig.putAll((Map<?, ?>)additional);
        return consumerConfig;
    }

    public static Properties consumerConfig(String bootstrapServers, String groupId, Class keyDeserializer, Class valueDeserializer) {
        return TestUtils.consumerConfig(bootstrapServers, groupId, keyDeserializer, valueDeserializer, new Properties());
    }

    public static Properties consumerConfig(String bootstrapServers, Class keyDeserializer, Class valueDeserializer) {
        return TestUtils.consumerConfig(bootstrapServers, UUID.randomUUID().toString(), keyDeserializer, valueDeserializer, new Properties());
    }

    public static void waitForCondition(TestCondition testCondition, String conditionDetails) throws InterruptedException {
        TestUtils.waitForCondition(testCondition, 15000L, conditionDetails);
    }

    public static void waitForCondition(TestCondition testCondition, long maxWaitMs, String conditionDetails) throws InterruptedException {
        boolean testConditionMet;
        long startTime = System.currentTimeMillis();
        while (!(testConditionMet = testCondition.conditionMet()) && System.currentTimeMillis() - startTime < maxWaitMs) {
            Thread.sleep(Math.min(maxWaitMs, 100L));
        }
        if (!testConditionMet) {
            conditionDetails = conditionDetails != null ? conditionDetails : "";
            throw new AssertionError((Object)("Condition not met within timeout " + maxWaitMs + ". " + conditionDetails));
        }
    }

    public static void isValidClusterId(String clusterId) {
        Assert.assertNotNull((Object)clusterId);
        Assert.assertEquals((long)clusterId.length(), (long)22L);
        Pattern clusterIdPattern = Pattern.compile("[a-zA-Z0-9_\\-]+");
        Matcher matcher = clusterIdPattern.matcher(clusterId);
        Assert.assertTrue((boolean)matcher.matches());
        String originalClusterId = String.format("%s==", clusterId.replace("_", "/").replace("-", "+"));
        byte[] decodedUuid = Base64.decoder().decode(originalClusterId);
        Assert.assertEquals((long)decodedUuid.length, (long)16L);
        try {
            ByteBuffer uuidBuffer = ByteBuffer.wrap(decodedUuid);
            new UUID(uuidBuffer.getLong(), uuidBuffer.getLong()).toString();
        }
        catch (Exception e) {
            Assert.fail((String)(clusterId + " cannot be converted back to UUID."));
        }
    }

    public static <T> void checkEquals(Iterable<T> it1, Iterable<T> it2) {
        Assert.assertEquals(TestUtils.toList(it1), TestUtils.toList(it2));
    }

    public static <T> void checkEquals(Iterator<T> it1, Iterator<T> it2) {
        Assert.assertEquals((Object)Utils.toList(it1), (Object)Utils.toList(it2));
    }

    public static <T> void checkEquals(Set<T> c1, Set<T> c2, String firstDesc, String secondDesc) {
        if (!c1.equals(c2)) {
            HashSet<T> missing1 = new HashSet<T>(c2);
            missing1.removeAll(c1);
            HashSet<T> missing2 = new HashSet<T>(c1);
            missing2.removeAll(c2);
            Assert.fail((String)String.format("Sets not equal, missing %s=%s, missing %s=%s", firstDesc, missing1, secondDesc, missing2));
        }
    }

    public static <T> List<T> toList(Iterable<? extends T> iterable) {
        ArrayList<T> list = new ArrayList<T>();
        for (T item : iterable) {
            list.add(item);
        }
        return list;
    }

    public static ByteBuffer toBuffer(Struct struct) {
        ByteBuffer buffer = ByteBuffer.allocate(struct.sizeOf());
        struct.writeTo(buffer);
        buffer.rewind();
        return buffer;
    }
}

