/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.internals.ProcessorParameters;
import org.apache.kafka.streams.kstream.internals.StreamsGraphNode;
import org.apache.kafka.streams.processor.ProcessorSupplier;

abstract class BaseJoinProcessorNode<K, V1, V2, VR>
extends StreamsGraphNode {
    private final ProcessorSupplier<K, V1> joinThisProcessSupplier;
    private final ProcessorSupplier<K, V2> joinOtherProcessSupplier;
    private final ProcessorSupplier<K, VR> joinMergeProcessor;
    private final ValueJoiner<? super V1, ? super V2, ? extends VR> valueJoiner;
    private final String joinThisProcessorName;
    private final String joinOtherProcessorName;
    private final String joinMergeProcessorName;
    private final String thisJoinSide;
    private final String otherJoinSide;

    BaseJoinProcessorNode(String parentProcessorNodeName, String processorNodeName, ValueJoiner<? super V1, ? super V2, ? extends VR> valueJoiner, ProcessorParameters<K, V1> joinThisProcessorDetails, ProcessorParameters<K, V2> joinOtherProcessDetails, ProcessorParameters<K, VR> joinMergeProcessorDetails, String thisJoinSide, String otherJoinSide) {
        super(parentProcessorNodeName, processorNodeName, false);
        this.valueJoiner = valueJoiner;
        this.joinThisProcessSupplier = joinThisProcessorDetails.processorSupplier();
        this.joinOtherProcessSupplier = joinOtherProcessDetails.processorSupplier();
        this.joinMergeProcessor = joinMergeProcessorDetails.processorSupplier();
        this.joinThisProcessorName = joinThisProcessorDetails.processorName();
        this.joinOtherProcessorName = joinOtherProcessDetails.processorName();
        this.joinMergeProcessorName = joinMergeProcessorDetails.processorName();
        this.thisJoinSide = thisJoinSide;
        this.otherJoinSide = otherJoinSide;
    }

    ProcessorSupplier<K, V1> joinThisProcessorSupplier() {
        return this.joinThisProcessSupplier;
    }

    ProcessorSupplier<K, V2> joinOtherProcessorSupplier() {
        return this.joinOtherProcessSupplier;
    }

    ProcessorSupplier<K, VR> joinMergeProcessor() {
        return this.joinMergeProcessor;
    }

    ValueJoiner<? super V1, ? super V2, ? extends VR> valueJoiner() {
        return this.valueJoiner;
    }

    String joinThisProcessorName() {
        return this.joinThisProcessorName;
    }

    String joinOtherProcessorName() {
        return this.joinOtherProcessorName;
    }

    String joinMergeProcessorName() {
        return this.joinMergeProcessorName;
    }

    String thisJoinSide() {
        return this.thisJoinSide;
    }

    String otherJoinSide() {
        return this.otherJoinSide;
    }
}

