/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.ChangedDeserializer;
import org.apache.kafka.streams.kstream.internals.ChangedSerializer;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.kstream.internals.RepartitionNode;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.state.KeyValueStore;

class StatefulRepartitionNode<K, V, T>
extends RepartitionNode<K, V> {
    private final ProcessorSupplier<K, Change<V>> statefulProcessorSupplier;
    private final MaterializedInternal<K, T, KeyValueStore<Bytes, byte[]>> materialized;

    StatefulRepartitionNode(String parentProcessorNodeName, String processorNodeName, String sourceName, Serde<K> keySerde, Serde<V> valueSerde, String sinkName, String repartitionTopic, String processorName, ProcessorSupplier<K, Change<V>> statefulProcessorSupplier, MaterializedInternal<K, T, KeyValueStore<Bytes, byte[]>> materialized) {
        super(parentProcessorNodeName, processorNodeName, sourceName, null, keySerde, valueSerde, sinkName, repartitionTopic, processorName);
        this.statefulProcessorSupplier = statefulProcessorSupplier;
        this.materialized = materialized;
    }

    ProcessorSupplier<K, Change<V>> statefulProcessorSupplier() {
        return this.statefulProcessorSupplier;
    }

    MaterializedInternal<K, T, KeyValueStore<Bytes, byte[]>> materialized() {
        return this.materialized;
    }

    ChangedSerializer<? extends V> changedValueSerializer() {
        Serializer valueSerializer = this.valueSerde() == null ? null : this.valueSerde().serializer();
        return new ChangedSerializer(valueSerializer);
    }

    ChangedDeserializer<? extends V> changedValueDeserializer() {
        Deserializer valueDeserializer = this.valueSerde() == null ? null : this.valueSerde().deserializer();
        return new ChangedDeserializer(valueDeserializer);
    }

    static <K, V, T> StatefulRepartitionNodeBuilder<K, V, T> statefulRepartitionNodeBuilder() {
        return new StatefulRepartitionNodeBuilder();
    }

    @Override
    void writeToTopology(InternalTopologyBuilder topologyBuilder) {
    }

    static final class StatefulRepartitionNodeBuilder<K, V, T> {
        private String parentProcessorNodeName;
        private String processorNodeName;
        private Serde<K> keySerde;
        private Serde<V> valueSerde;
        private String sinkName;
        private String sourceName;
        private String repartitionTopic;
        private String processorName;
        private ProcessorSupplier<K, Change<V>> statefulProcessorSupplier;
        private MaterializedInternal<K, T, KeyValueStore<Bytes, byte[]>> materialized;

        private StatefulRepartitionNodeBuilder() {
        }

        StatefulRepartitionNodeBuilder<K, V, T> withKeySerde(Serde<K> keySerde) {
            this.keySerde = keySerde;
            return this;
        }

        StatefulRepartitionNodeBuilder<K, V, T> withValueSerde(Serde<V> valueSerde) {
            this.valueSerde = valueSerde;
            return this;
        }

        StatefulRepartitionNodeBuilder<K, V, T> withParentProcessorNodeName(String parentProcessorNodeName) {
            this.parentProcessorNodeName = parentProcessorNodeName;
            return this;
        }

        StatefulRepartitionNodeBuilder<K, V, T> withSinkName(String sinkName) {
            this.sinkName = sinkName;
            return this;
        }

        StatefulRepartitionNodeBuilder<K, V, T> withSourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        StatefulRepartitionNodeBuilder<K, V, T> withRepartitionTopic(String repartitionTopic) {
            this.repartitionTopic = repartitionTopic;
            return this;
        }

        StatefulRepartitionNodeBuilder<K, V, T> withProcessorNodeName(String processorNodeName) {
            this.processorName = processorNodeName;
            return this;
        }

        StatefulRepartitionNodeBuilder<K, V, T> withStatefulProcessorSupplier(ProcessorSupplier<K, Change<V>> statefulProcessorSupplier) {
            this.statefulProcessorSupplier = statefulProcessorSupplier;
            return this;
        }

        StatefulRepartitionNodeBuilder<K, V, T> withMaterialized(MaterializedInternal<K, T, KeyValueStore<Bytes, byte[]>> materialized) {
            this.materialized = materialized;
            return this;
        }

        StatefulRepartitionNodeBuilder<K, V, T> withNodeName(String nodeName) {
            this.processorNodeName = nodeName;
            return this;
        }

        public StatefulRepartitionNode<K, V, T> build() {
            return new StatefulRepartitionNode<K, V, T>(this.parentProcessorNodeName, this.processorNodeName, this.sourceName, this.keySerde, this.valueSerde, this.sinkName, this.repartitionTopic, this.processorName, this.statefulProcessorSupplier, this.materialized);
        }
    }
}

